# ---------------------------------------------------------------------------
#     AUTHLIB.PL
#
#      Ver: 9_15_4
# ---------------------------------------------------------------------------
# Lighthouse Studio - Web Surveying System
# Copyright Sawtooth Software, Inc. 1998-2023. All rights reserved.
# Provo, UT  USA  (801) 477-4700
#
# Any modification of this script will be considered violation of
# copyright (with the exception of the first line which can be
# modified to reflect the correct path to the Perl interpreter)
#
# Any use of this script or its code for purposes outside of
# the systems created by Sawtooth Software is prohibited.
# ---------------------------------------------------------------------------
 use strict; use Symbol qw(gensym); package authlib9_15_4; eval { require 5.014002; }; if ($@) { authlib9_15_4::_zr(339, "Lighthouse Studio requires Perl version 5.14.2 or greater to run properly. This server is running Perl version " . $^V . ".", "", $@); } use constant _ANI => 0; use constant _ANJ => -4; use constant _ANK => -3; use constant _ANL => -2; use constant _ANM => -1; use constant _ANN => 1; use constant _ANO => 2; use constant _ANP => 3; use constant _ANQ => 4; use constant _ANR => 5; use constant _ANS => 6; use constant _ANT => 7; use constant _ANU => 8; use constant _ANV => 9; use constant _ANW => 10; use constant _ANX => 13; use constant _ANY => 14; use constant _ANZ => 15; use constant _AOA => 16; use constant _AOB => 17; use constant _AOC => 18; use constant _AOD => 19; use constant _AOE => 20; use constant _AOF => 21; use constant _AOG => 22; use constant _AOH => 23; use constant _AOI => 24; use constant _AOJ => 25; use constant _AOK => 26; use constant _AOL => 27; use constant _AOM => 28; use constant _AON => 2; use constant _AOO => 4; use constant _AOP => 5; use constant _AOQ => 1; use constant _AOR => 2; use constant _AOS => 3; use constant _AOT => 4; use constant _AOU => 5; use constant _AOV => 6; use constant _AOW => 0; use constant _AOX => 1; use constant _AOY => 2; use constant _AOZ => 3; use constant _APA => 1; use constant _APB => 2; use constant _APC => 3; use constant _APD => 1; use constant _APE => 2; use constant _APF => 3; use constant _APG => 4; use constant _APH => 5; use constant _API => 1; use constant _APJ => 2; use constant _APK => 3; use constant _APL => 4; use constant _APM => 5; use constant _APN => 1; use constant _APO => 2; use constant _APP => 3; use constant _APQ => 10; use constant _APR => 250; use constant _APS => 250; use constant _APT => 100; $authlib9_15_4::_ako = ""; $authlib9_15_4::_akq = ""; $authlib9_15_4::_aht = {}; $authlib9_15_4::_akw = 0; %authlib9_15_4::_ahv = (); %authlib9_15_4::_akv = (); %authlib9_15_4::_ahx = (); $authlib9_15_4::_akn = {}; $authlib9_15_4::_ahz = {}; $authlib9_15_4::_aia = {}; %authlib9_15_4::_aib = (); $authlib9_15_4::_alf = 0; $authlib9_15_4::_alc = 0; $authlib9_15_4::_ald = 0; $authlib9_15_4::_ale = 0; $authlib9_15_4::_aig = ""; $authlib9_15_4::_aih = ""; $authlib9_15_4::_aii = "1702316560"; $authlib9_15_4::_akx = 0; $authlib9_15_4::_aky = 0; %authlib9_15_4::_ail = (); %authlib9_15_4::_aim = (); $authlib9_15_4::_ain = 0; $authlib9_15_4::_aio = 0; $authlib9_15_4::_aiq = 0; $authlib9_15_4::_air = 0; $authlib9_15_4::_als = 0; $authlib9_15_4::_ait = {}; $authlib9_15_4::_aml = 0; $authlib9_15_4::_alz = 0; $authlib9_15_4::_ama = ""; $authlib9_15_4::_amb = ""; %authlib9_15_4::_aiy = (); %authlib9_15_4::_aiz = (); $authlib9_15_4::_amo = 0; $authlib9_15_4::_ajb = 0; $authlib9_15_4::_alk = 0; $authlib9_15_4::_ajd = 0; %authlib9_15_4::_aje = (); $authlib9_15_4::_ajf = ""; $authlib9_15_4::_ajg = 0; $authlib9_15_4::_ali = 0; $authlib9_15_4::_alj = 0; $authlib9_15_4::_ajj = 0; $authlib9_15_4::_alg = 0; $authlib9_15_4::_ajl = 0; $authlib9_15_4::_ajm = 0; $authlib9_15_4::_ajo = ""; $authlib9_15_4::_ajp = 1; $authlib9_15_4::_ajq = ""; $authlib9_15_4::_all = 1; $authlib9_15_4::_ajs = 0; %authlib9_15_4::_ajt = (); $authlib9_15_4::_alm = 0; $authlib9_15_4::_aln = 0; $authlib9_15_4::_ajw = 0; $authlib9_15_4::_ajx = 0; $authlib9_15_4::_aip = 0; $authlib9_15_4::_ajy = 0; $authlib9_15_4::_amm = 0; $authlib9_15_4::_akl = 0; $authlib9_15_4::_aku = 0; $authlib9_15_4::_akc = {}; $authlib9_15_4::_akd = 0; $authlib9_15_4::_ake = 0; $authlib9_15_4::_akf = 0; $authlib9_15_4::_alp = 0; $authlib9_15_4::_akr = 0; $authlib9_15_4::_aho = ""; $authlib9_15_4::_ahp = ""; $authlib9_15_4::_akh = 0; sub _wc { my ($__bcc) = @_; $authlib9_15_4::_ako = ""; $authlib9_15_4::_akq = ""; $authlib9_15_4::_aht = {}; $authlib9_15_4::_akw = 0; %authlib9_15_4::_ahv = (); %authlib9_15_4::_akv = (); %authlib9_15_4::_ahx = (); $authlib9_15_4::_akn = {}; $authlib9_15_4::_ahz = {}; $authlib9_15_4::_aia = {}; %authlib9_15_4::_aib = (); $authlib9_15_4::_alf = 0; $authlib9_15_4::_alc = 0; $authlib9_15_4::_ald = 0; $authlib9_15_4::_ale = 0; $authlib9_15_4::_aig = "9_15_4"; $authlib9_15_4::_aih = ".pl"; $authlib9_15_4::_aii = "1702316560"; $authlib9_15_4::_akx = 0; $authlib9_15_4::_aky = 0; %authlib9_15_4::_ail = (); %authlib9_15_4::_aim = (); $authlib9_15_4::_ain = 0; $authlib9_15_4::_aio = 0; $authlib9_15_4::_aip = 0; $authlib9_15_4::_aiq = 0; $authlib9_15_4::_air = 0; $authlib9_15_4::_als = 0; $authlib9_15_4::_ait = {}; $authlib9_15_4::_aml = 0; $authlib9_15_4::_alz = 0; $authlib9_15_4::_ama = ""; $authlib9_15_4::_amb = ""; %authlib9_15_4::_aiy = (); %authlib9_15_4::_aiz = (); $authlib9_15_4::_amo = 0; $authlib9_15_4::_ajb = $__bcc; $authlib9_15_4::_alk = 0; $authlib9_15_4::_ajd = 0; %authlib9_15_4::_aje = (); $authlib9_15_4::_ajf = ""; $authlib9_15_4::_ajg = 0; $authlib9_15_4::_ali = 0; $authlib9_15_4::_alj = 0; $authlib9_15_4::_ajj = 0; $authlib9_15_4::_alg = 0; $authlib9_15_4::_ajl = 0; $authlib9_15_4::_ajm = 0; $authlib9_15_4::_ajn = 0; $authlib9_15_4::_ajo = ""; $authlib9_15_4::_ajp = 1; $authlib9_15_4::_ajq = ""; $authlib9_15_4::_all = 1; $authlib9_15_4::_ajs = 0; %authlib9_15_4::_ajt = (); $authlib9_15_4::_alm = 0; $authlib9_15_4::_aln = 0; $authlib9_15_4::_ajw = 0; $authlib9_15_4::_ajx = 0; $authlib9_15_4::_ajy = 0; $authlib9_15_4::_amm = 0; $authlib9_15_4::_akl = 0; $authlib9_15_4::_aku = 0; $authlib9_15_4::_akc = {}; $authlib9_15_4::_akd = 0; $authlib9_15_4::_ake = 0; $authlib9_15_4::_akf = 0; $authlib9_15_4::_alp = 0; if($ENV{"SSI_PERL_ENV"} eq "LOCAL"){ $authlib9_15_4::_akh = 0 } } sub _wd { my ($__bcn) = @_; my $__bcd = 0; my $__bce = 0; my $__bcf = ""; my $__bcg = ""; my $__bch = ""; eval { require DBI; $authlib9_15_4::_aht->{'_amp'} = 300; if (uc($__bcn->{"database_type"}) eq uc("mysql")) { $__bch = "dbi:" . $__bcn->{"database_type"} . ":" . $__bcn->{"database_name"} . ":" . $__bcn->{"database_address"}; if ($__bcn->{"database_port"}) { $__bch .= ":" . $__bcn->{"database_port"}; } $__bch .= ";mysql_connect_timeout=20;mysql_read_timeout=20;mysql_write_timeout=20"; $authlib9_15_4::_akl = DBI->connect($__bch, $__bcn->{"database_username"}, $__bcn->{"database_password"},{RaiseError => 1, PrintError => 0, AutoCommit => 0}); $authlib9_15_4::_aht->{'_amq'} = "ENGINE = INNODB CHARACTER SET utf8 COLLATE utf8_unicode_ci ROW_FORMAT=DYNAMIC"; $authlib9_15_4::_aht->{'_amr'} = "AUTO_INCREMENT"; $authlib9_15_4::_aht->{'_ams'} = $__bcn->{"database_name"}; } elsif (uc($__bcn->{"database_type"}) eq uc("SQLite")) { my $__bci = $authlib9_15_4::_aht->{'_pj'}; my $__bcj = "dbi:" . $__bcn->{"database_type"} . ":dbname=" . $authlib9_15_4::_aib{'_amt'} . $authlib9_15_4::_akq . ".sqlite"; $authlib9_15_4::_akl = DBI->connect($__bcj, undef, undef, {RaiseError => 1, PrintError => 0, AutoCommit => 0, "sqlite_use_immediate_transaction" => 1}); $authlib9_15_4::_aht->{'_amr'} = "AUTOINCREMENT"; } elsif (uc($__bcn->{"database_type"}) eq uc("ODBC")) { my $__bck = $__bcn->{"database_address"}; my $__bcl = "{SQL Server}"; if (exists $__bcn->{"database_driver"} && $__bcn->{"database_driver"} ne "") { $__bcl = $__bcn->{"database_driver"}; } $__bch = "DBI:" . $__bcn->{"database_type"} . ":" . "Driver=" . $__bcl . ";Server=" . $__bck . ";" . "Database=" . $__bcn->{"database_name"} . ";" . "uid=" . $__bcn->{"database_username"} . ";" . "pwd=" . $__bcn->{"database_password"} . ";" . "port=" . $__bcn->{"database_port"}; $authlib9_15_4::_akl = DBI->connect($__bch, undef, undef, {RaiseError => 1, PrintError => 0, AutoCommit => 0, odbc_query_timeout => 20}); my $__bcm = 1; if (exists $authlib9_15_4::_akc->{"respnum_start"}) { $__bcm = $authlib9_15_4::_akc->{"respnum_start"}; } $authlib9_15_4::_aht->{'_amr'} = "IDENTITY(" . $__bcm . ", 1)"; $authlib9_15_4::_akl->{"LongReadLen"} = 131070; $authlib9_15_4::_aht->{'_amp'} = 1000; $authlib9_15_4::_aht->{'_ams'} = $__bcn->{"database_name"}; } else { $__bce = 1; $__bcg = "Failed to connect to the database."; $__bcf = "Cannot find database for " . $__bcn->{"database_type"} . "."; } if (uc($__bcn->{"database_type"}) ne uc("SQLite")) { if (exists $__bcn->{"database_max_fields_table"}) { $authlib9_15_4::_aht->{'_amp'} = $__bcn->{"database_max_fields_table"}; } } }; if ($@) { $__bcg = "Failed to connect to the database."; $__bcf = $@; if ($__bcf =~ m/Unknown database/i || $__bcf =~ m/Cannot open database/i) { $__bcg .= " Cannot find the \"" . $__bcn->{"database_name"} . "\" database. Make sure that this database has been created and that you have access to it."; } elsif ($__bcf =~ m/Access denied for user/i || $__bcf =~ m/Login failed for user/i) { $__bcg .= " Access denied for database user \"" . $__bcn->{"database_username"} . "\". Check the database user name and password. Also verify that you have the database name (" . $__bcn->{"database_name"} . ") correct."; } elsif ($__bcf =~ m/install_driver(.*?)failed/i) { $__bcg .= " Cannot find database driver " . $__bcn->{"database_type"} . "."; } } elsif (!$authlib9_15_4::_akl) { ($__bcd, $__bcg, $__bcf) = _wk($__bcn->{"database_type"}); $__bce = 1; $__bcg = "Failed to connect to the database."; } elsif (!$__bce) { ($__bcd, $__bcg, $__bcf) = _wk($__bcn->{"database_type"}); $authlib9_15_4::_aht->{'_pj'} = lc($__bcn->{"database_type"}); } else { $__bcd = 1; } if ($__bcf ne "") { $__bcf = "The system error message has been removed for security reasons. Consider using db_test.pl for debugging purposes. Contact Sawtooth Software for assistance."; } return ($__bcd, $__bcg, $__bcf); } sub _we { if ($authlib9_15_4::_akl) { $authlib9_15_4::_akl->commit(); $authlib9_15_4::_akl->disconnect; $authlib9_15_4::_akl = 0; } } sub _wf { my ($__bcq) = @_; my $__bco = ""; if (uc($authlib9_15_4::_akc->{"database_type"}) eq uc("mysql")) { $__bco = "LOCK TABLES `" . $__bcq . "` WRITE"; } elsif (uc($authlib9_15_4::_akc->{"database_type"}) eq uc("ODBC")) { $__bco = "SET TRANSACTION ISOLATION LEVEL SERIALIZABLE"; } if ($__bco) { eval { my $__bcp = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__bco, 0)); $__bcp->execute(); $authlib9_15_4::_akl->commit(); }; if ($@) { authlib9_15_4::_zr(360, "", "Error locking the " . $__bcq . " table.", $@); } } } sub _wg { my $__bcr = ""; if (uc($authlib9_15_4::_akc->{"database_type"}) eq uc("mysql")) { $__bcr = "UNLOCK TABLES"; } elsif (uc($authlib9_15_4::_akc->{"database_type"}) eq uc("ODBC")) { $__bcr = "SET TRANSACTION ISOLATION LEVEL READ COMMITTED"; } if ($__bcr) { eval { my $__bcs = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__bcr, 0)); $__bcs->execute(); $authlib9_15_4::_akl->commit(); }; if ($@) { authlib9_15_4::_zr(361, "", "Error unlocking table.", $@); } } } sub _wh { my ($__bct) = @_; if ($authlib9_15_4::_aht->{'_pj'} eq "odbc" && defined($__bct)) { $__bct = pack("U0C*", unpack("C*", $__bct)); } return $__bct; } sub _wi { my ($__bcu) = @_; if ($authlib9_15_4::_aht->{'_pj'} eq "odbc" && defined($__bcu)) { $__bcu = pack("C*", unpack("U0C*", $__bcu)); } return $__bcu; } sub _wj { my ($__bcv) = @_; $__bcv =~ s{([\x00-\x29\x2C\x3A-\x40\x5B-\x5E\x60\x7B-\x7F])} {'%' . uc(unpack('H2', $1))}eg; return $__bcv; } sub _wk { my ($__bcx) = @_; if ($authlib9_15_4::_aih eq ".pl") { my @__bcw = DBI->available_drivers(); unless (grep(/$__bcx/i, @__bcw)) { return (0, "", "A " . $__bcx . " driver is not installed for Perl. Please make sure that the CPAN module DBD::" . $__bcx . " is installed and reachable from Perl."); } } return (1, "", ""); } sub _wl { my ($__bcz) = @_; my $__bcy = ""; if ($authlib9_15_4::_aht->{'_pj'} eq "odbc") { $__bcy .= "IF OBJECT_ID('" . $__bcz . "') IS NOT NULL DROP TABLE \"" . $__bcz . "\""; } else { $__bcy .= "DROP TABLE IF EXISTS `" . $__bcz . "`"; } return $__bcy; } sub _wm { my ($__bdf) = @_; my $__bda = ""; my $__bdb = 0; my $__bdc = 0; my $__bdd = ""; my $__bde = ""; if ($authlib9_15_4::_aht->{'_pj'} eq "sqlite") { $__bda = "PRAGMA table_info(`" . $__bdf . "`)"; $__bdb = 1; $__bdc = 2; $__bdd = "name"; $__bde = "type"; } elsif ($authlib9_15_4::_aht->{'_pj'} eq "odbc") { $__bda = "SELECT COLUMN_NAME 'Field', DATA_TYPE 'Type' FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '" . $__bdf . "'"; $__bdb = 0; $__bdc = 1; $__bdd = "Field"; $__bde = "Type"; } else { $__bda = "DESCRIBE `" . $__bdf . "`"; $__bdb = 0; $__bdc = 1; $__bdd = "Field"; $__bde = "Type"; } return ($__bda, $__bdb, $__bdc, $__bdd, $__bde); } sub _wn { my ($__bdg, $__bdh) = @_; if ($authlib9_15_4::_aht->{'_pj'} eq "odbc") { $__bdg =~ s/`/\"/g; if ($__bdh) { $__bdg =~ s/\s+TINYINT\(\d+\)([,\s\)])/ TINYINT$1/ig; $__bdg =~ s/\s+INTEGER([,\s\)])/ INT$1/ig; $__bdg =~ s/\s+LONGTEXT([,\s\)])/ nvarchar\(max\)$1/ig; $__bdg =~ s/\s+TEXT([,\s\)])/ nvarchar\(max\)$1/ig; $__bdg =~ s/\s+VARCHAR\s*\((\d+)\)([,\s\)])/ nvarchar\($1\)$2/ig; $__bdg =~ s/\s+DOUBLE([,\s\)])/ decimal\(38, 16\)$1/ig; $__bdg =~ s/CREATE\s+INDEX/CREATE NONCLUSTERED INDEX/ig; } } elsif ($authlib9_15_4::_aht->{'_pj'} eq "sqlite") { if ($__bdh) { $__bdg =~ s/\s+INT([,\s\)])/ INTEGER$1/ig; $__bdg =~ s/\s+TEXT/ TEXT COLLATE NOCASE/ig; $__bdg =~ s/\s+VARCHAR\s*(?:\(\d+\))?/ TEXT COLLATE NOCASE/ig; $__bdg =~ s/^double$/TEXT COLLATE BINARY/ig; } } return $__bdg; } sub _wo { my ($__bdm, $__bdn) = @_; if ($authlib9_15_4::_aht->{'_pj'} eq "odbc") { $authlib9_15_4::_akl->do('IF EXISTS (SELECT name FROM sys.indexes WHERE name=\''. $__bdn ."')\n\tDROP INDEX \"" . $__bdn .'" ON "'. $__bdm .'"'); } elsif ($authlib9_15_4::_aht->{'_pj'} eq "mysql") { my $__bdi = $authlib9_15_4::_akl->selectrow_arrayref("SHOW TABLES LIKE '". $__bdm ."'"); if ($__bdi) { my $__bdj = $authlib9_15_4::_akl->selectall_arrayref("SHOW INDEX FROM `". $__bdm ."`", {Slice=>{}}); my %__bdk = ("PRIMARY" => 1); foreach my $__bdl (@{$__bdj}) { if (not exists $__bdk{$__bdl->{"Key_name"}}) { $__bdk{$__bdl->{"Key_name"}} = 1; $authlib9_15_4::_akl->do('DROP INDEX `' . $__bdl->{"Key_name"} . '` ON `'. $__bdm .'`'); } } } } elsif ($authlib9_15_4::_aht->{'_pj'} eq "sqlite") { $authlib9_15_4::_akl->do('DROP INDEX IF EXISTS `'. $__bdn .'`'); } } sub _wp { my ($__bdo) = @_; if ($authlib9_15_4::_aht->{'_pj'} eq "odbc") { $__bdo =~ s/^bool$/tinyint/ig; $__bdo =~ s/^INTEGER$/int/ig; $__bdo =~ s/^LONGTEXT$/nvarchar\(max\)/ig; $__bdo =~ s/^TEXT$/nvarchar\(max\)/ig; $__bdo =~ s/^VARCHAR$/nvarchar\(max\)/ig; $__bdo =~ s/^DOUBLE$/decimal\(38, 16\)/ig; } elsif ($authlib9_15_4::_aht->{'_pj'} eq "sqlite") { $__bdo =~ s/^bool$/tinyint\(1\)/ig; $__bdo =~ s/^int$/INTEGER/ig; $__bdo =~ s/^double$/text/ig; } else { $__bdo =~ s/^bool$/tinyint\(1\)/ig; } return $__bdo; } sub _wq { my ($__bdq) = @_; my $__bdp = 0; if ($__bdq =~ m/text/i || $__bdq =~ m/varchar/i) { $__bdp = 1; } return $__bdp; } sub _wr { my ($__bdu, $__bdv) = @_; my $__bdr = $authlib9_15_4::_akl->last_insert_id(undef, undef, "`" . $__bdu . "`", $__bdv); if (!$__bdr) { my $__bds = ""; if ($authlib9_15_4::_aht->{'_pj'} eq "odbc") { $__bds = "SELECT \@\@IDENTITY FROM `" . $__bdu . "`"; } else { $__bds = "SELECT LAST_INSERT_ID() FROM `" . $__bdu . "`"; } my $__bdt = $authlib9_15_4::_akl->selectrow_arrayref(authlib9_15_4::_wn($__bds, 0)); $__bdr = $__bdt->[0]; if (!$__bdr) { authlib9_15_4::_zr(267, "Database error.", "Database error. Cannot get last_insert_id for " . $__bdu, $@); } } return $__bdr; } sub _ws { my ($__bem, $__ben, $__beo) = @_; my $__bdw = ""; my $__bdx = ciwlib9_15_4::_rj(); if ($__bdx > 0) { my $__bdy = 0; my $__bdz = ""; my $__bea = ""; my $__beb = 0; if (keys %{$authlib9_15_4::_akn} == 0 && !$authlib9_15_4::_amo) { _wu($__bdx); } if (exists $authlib9_15_4::_ahz->{$__bem}) { $__bdw = ""; $__bdy = 1; } elsif (exists $authlib9_15_4::_akn->{$__bem}) { $__bdw = $authlib9_15_4::_akn->{$__bem}; $__bdy = 1; } elsif (_aev()) { my ($__bep, $__beq) = _xk($__bem); if ($__bep) { $__bdy = 1; my $__bec = "SELECT " . $__beq . " FROM `" . $authlib9_15_4::_akq . "_data" . $__bep . "` WHERE `sys_RespNum` = " . $__bdx; my $__bed = 0; my $__bee = ""; eval { $__bed = $authlib9_15_4::_akl->selectrow_hashref(authlib9_15_4::_wn($__bec, 0)); }; if ($@ || $__bed == 0) { } else { foreach $__bee (keys %{$__bed}) { $authlib9_15_4::_akn->{$__bee} = _wi($__bed->{$__bee}); } if (exists $authlib9_15_4::_akn->{$__bem}) { $__bdw = $authlib9_15_4::_akn->{$__bem}; $__bdy = 1; } } } if (!$__bdy) { $__beb = _ads($__bdx); if (exists $authlib9_15_4::_akn->{$__bem}) { $__bdw = $authlib9_15_4::_akn->{$__bem}; $__bdy = 1; } } if (!$__bdy) { if (exists $authlib9_15_4::_akv{"hid_loops"}) { if ($__ben) { if ($__bem =~ m/(.*?)\.\d+$/o) { $__bdw = _ws($1, 1); } } else { my $__bef = 0; my $__beg = _xl($__bem); if ($__beg) { $__bef = 1; } elsif ($__beb) { foreach my $__beh (keys %{$__beb}) { if ($__beh =~ m/(.*?)\./o) { if ($__bem eq $1) { $__bef = 1; last; } } } } if ($__bef) { my $__bei = 0; my ($__bdz, $__bea, $__ber) = authlib9_15_4::_abu($__bem); if (exists $authlib9_15_4::_ahv{$__bdz}) { my $__bej = $authlib9_15_4::_ahv{$__bdz}; $__bei = $__bej->{'_ji'}; } else { $__bei = _aae(); } my $__bek = $authlib9_15_4::_akw->[$__bei - 1]; my $__bel = ciwlib9_15_4::_qz($authlib9_15_4::_akv{"hid_loops"}); my ($__bes, $__bet) = ciwlib9_15_4::_rb($__bek, $__bel, $__beo); if ($__bes) { $__bdw = _ws($__bem . $__bes, 1); } } } if ($__bdw) { $authlib9_15_4::_akn->{$__bem} = $__bdw; $__bdy = 1; } } } } } return $__bdw; } sub _wt { my ($__beu, $__bev) = @_; delete $authlib9_15_4::_ahz->{$__beu}; $authlib9_15_4::_akn->{$__beu} = $__bev; } sub _wu { my ($__bez) = @_; my @__bew = ("`sys_RespNum`", "`sys_CheckSum`", "`sys_StartTimeStamp`", "`sys_EndTimeStamp`", "`sys_RespStatus`", "`sys_DispositionCode`", "`sys_LastQuestion`", "`sys_UserJavaScript`"); my $__bex = "SELECT " . join(",", @__bew) . " FROM `" . $authlib9_15_4::_akq . "_data1` WHERE `sys_RespNum` = " . $__bez; eval { $authlib9_15_4::_akn = $authlib9_15_4::_akl->selectrow_hashref(authlib9_15_4::_wn($__bex, 0)); }; if ($@ || $authlib9_15_4::_akn == 0) { authlib9_15_4::_zr(207, "Database error.", "Database error. Initial data read failed.", $@); } my $__bey = authlib9_15_4::_aae(); if ($__bey > 1) { _adu(); } } sub _wv { my $__bfa = _aac(); if ($__bfa =~ m/Googlebot|Baiduspider|msnbot|bingbot|spider|robot|crawler|crawling|slurp/i) { authlib9_15_4::_acv(); } } sub _ww { my ($__bfd, $__bfe) = @_; my $__bfb = 0; if ($__bfd) { my $__bfc = Time::HiRes::tv_interval($__bfd); $__bfb = ($__bfc < $__bfe) ? 0 : 1; } return $__bfb; } sub _wx { my ($__bfi) = @_; my $__bff = 0; my $__bfg = "SELECT `sys_RespNum` FROM `" . $authlib9_15_4::_akq . "_data1` WHERE `sys_RespNum` = " . $__bfi; my $__bfh = 0; eval { $__bfh = $authlib9_15_4::_akl->selectrow_hashref(authlib9_15_4::_wn($__bfg, 0)); }; if ($@) { authlib9_15_4::_zr(277, "Database error.", "Database error. Error checking if record exists.", $@); } if ($__bfh) { if (exists $__bfh->{"sys_RespNum"}) { if ($__bfh->{"sys_RespNum"} == $__bfi) { $__bff = 1; } } } return $__bff; } sub _wy { my ($__bfj) = @_; $authlib9_15_4::_ako = $__bfj; $authlib9_15_4::_akq = $authlib9_15_4::_ako; if (exists $authlib9_15_4::_akv{"hid_test_db"}) { $authlib9_15_4::_akq = authlib9_15_4::_aeo(); } } sub _wz { my ($__bfn) = @_; my $__bfk = ""; my $__bfl = ref $__bfn; if ($__bfl eq "ARRAY") { $__bfk .= "["; my $__bfm = 0; foreach $__bfm (@{$__bfn}) { $__bfl = ref $__bfm; if ($__bfl eq "ARRAY") { $__bfk .= "["; $__bfk .= join(",", @{$__bfm}); $__bfk .= "],"; } else { $__bfk .= $__bfm . ","; } } $__bfk =~ s/,$//; $__bfk .= "]"; } return $__bfk; } sub _xa { my ($__bft, $__bfu, $__bfv, $__bfw) = @_; my $__bfo = 0; eval { require "Digest.pm"; $__bfo = Digest->new("MD5"); }; if ($@) { authlib9_15_4::_zr(0, "Unable to load Digest.pm<br/><br/>", $@, ""); } my $__bfp = 0; if (exists $authlib9_15_4::_akv{"hid_test_db"}) { $__bfp = 1; } $__bfo->add(0xFF02); $__bfo->add($__bfv); $__bfo->add($__bfu); $__bfo->add($__bft); $__bfo->add($__bfw); $__bfo->add($authlib9_15_4::_akv{"hid_respnum"}); $__bfo->add($authlib9_15_4::_ajw); $__bfo->add($authlib9_15_4::_ako); $__bfo->add($__bfp); $__bfo->add($authlib9_15_4::_ahp); my $__bfq = $__bfo->digest(); my $__bfr = join(",", ($__bfv, $__bfu, $__bft, $__bfw, $authlib9_15_4::_akv{"hid_respnum"}, $authlib9_15_4::_ajw, $authlib9_15_4::_ako, $__bfp, $authlib9_15_4::_ahp)); my $__bfs = pack("V", 0xFF02) . $__bfq; $__bfs .= pack("V", length($__bfr)) . _xb($__bfr, $__bfq); return _xe($__bfs); } sub _xb { my ($__bgf, $__bgg) = @_; my $__bfx = length($__bgf); my $__bfy = ""; my $__bfz = 0; my $__bga = length($__bgg); for (; $__bfz < $__bfx - $__bga; $__bfz += $__bga) { $__bfy .= $__bgg ^ substr($__bgf, $__bfz, $__bga); } my %__bgb = (0 => 0, 1 => 1, 2 => 2, 3 => 3, 4 => 4, 5 => 5, 6 => 6, 7 => 7, 8 => 8, 9 => 9, 10 => 'A', 11 => 'B', 12 => 'C', 13 => 'D', 14 => 'E', 15 => 'F'); my $__bgc = ""; my $__bgd = 0; my @__bge = (); if ($__bfx % $__bga) { $__bgd = $__bga - ($__bfx % $__bga); @__bge = ($__bgb{$__bgd}) x ($__bgd * 2); $__bgc = pack("H*", join("", @__bge)); } $__bfy .= $__bgg ^ ($__bgc . substr($__bgf, $__bfz)); return $__bfy; } sub _xc { my ($__bgz) = @_; if ($__bgz !~ m/^(?:(?:[A-Z0-9_-]{4})*(?:[A-Z0-9_-]{2,3})?){1}$/io) { authlib9_15_4::_zr(304, "Page link is invalid.", "Page link is invalid: " . $__bgz, ""); } my $__bgh = _xf($__bgz); my $__bgi = unpack("V", $__bgh); my $__bgj = 0; my $__bgk = 0; my $__bgl = 0; my $__bgm = 0; my $__bgn = 0; my $__bgo = ""; my $__bgp = 0; my $__bgq = 0; my $__bgr = ""; if ($__bgi == 0xFF01) { my $__bgs = substr($__bgh, 4, 16); my $__bgt = unpack("V", substr($__bgh, 20, 4)); my $__bgu = substr($__bgh, 24); my $__bgv = _xd($__bgu, $__bgt, $__bgs); ($__bgl, $__bgk, $__bgj, $__bgm, $__bgn, $__bgp, $__bgo) = split(',', $__bgv); my $__bgw = 0; eval { require "Digest.pm"; $__bgw = Digest->new("MD5"); }; if ($@) { authlib9_15_4::_zr(0, "Unable to load Digest.pm<br/><br/>", $@, ""); } $__bgw->add(0xFF01); $__bgw->add($__bgl); $__bgw->add($__bgk); $__bgw->add($__bgj); $__bgw->add($__bgm); $__bgw->add($__bgn); $__bgw->add($__bgp); $__bgw->add($__bgo); my $__bgx = $__bgw->digest; if ($__bgs != $__bgx) { my $__bgy = "Expected_digest=" . unpack('H*', $__bgs) . ", actual_digest=" . unpack("H*", $__bgx); $__bgy .= ", version=$__bgi, id=$__bgj, checksum=$__bgk, timestamp=$__bgm, respnum=$__bgn, studyname=$__bgo, istestmode=$__bgl, previous=$__bgp"; authlib9_15_4::_zr(309, "URL values do not match expected values.", $__bgy, ""); } } elsif ($__bgi == 0xFF02) { my $__bgs = substr($__bgh, 4, 16); my $__bgt = unpack("V", substr($__bgh, 20, 4)); my $__bgu = substr($__bgh, 24); my $__bgv = _xd($__bgu, $__bgt, $__bgs); ($__bgl, $__bgk, $__bgj, $__bgm, $__bgn, $__bgp, $__bgo, $__bgq, $__bgr) = split(',', $__bgv); my $__bgw = 0; eval { require "Digest.pm"; $__bgw = Digest->new("MD5"); }; if ($@) { authlib9_15_4::_zr(0, "Unable to load Digest.pm<br/><br/>", $@, ""); } $__bgw->add(0xFF02); $__bgw->add($__bgl); $__bgw->add($__bgk); $__bgw->add($__bgj); $__bgw->add($__bgm); $__bgw->add($__bgn); $__bgw->add($__bgp); $__bgw->add($__bgo); $__bgw->add($__bgq); $__bgw->add($__bgr); my $__bgx = $__bgw->digest; if ($__bgs != $__bgx) { my $__bgy = "Expected_digest=" . unpack('H*', $__bgs) . ", actual_digest=" . unpack("H*", $__bgx); $__bgy .= ", version=$__bgi, id=$__bgj, checksum=$__bgk, timestamp=$__bgm, respnum=$__bgn, studyname=$__bgo, istestmode=$__bgl, previous=$__bgp, test_db=$__bgq, csrfTokenHash=$__bgr"; authlib9_15_4::_zr(325, "URL values do not match expected values.", $__bgy, ""); } } else { authlib9_15_4::_zr(341, "Page link is invalid.", "Page link is invalid: " . $__bgz, ""); } return ($__bgi, $__bgj, $__bgo, $__bgk, $__bgl, $__bgm, $__bgn, $__bgp, $__bgq, $__bgr); } sub _xd { my ($__bhh, $__bhi, $__bhj) = @_; my $__bha = length($__bhj); my $__bhb = 0; my $__bhc = ""; my $__bhd = $__bhi - $__bha; if (!$__bhh || $__bhd > 1000) { authlib9_15_4::_zr(342, "Page link is invalid.", "Page link is invalid.", ""); } for ($__bhb = 0; $__bhb < $__bhd; $__bhb += $__bha) { $__bhc .= $__bhj ^ substr($__bhh, $__bhb, $__bha); } my %__bhe = (0 => 0, 1 => 1, 2 => 2, 3 => 3, 4 => 4, 5 => 5, 6 => 6, 7 => 7, 8 => 8, 9 => 9, 'a' => 10, 'b' => 11, 'c' => 12, 'd' => 13, 'e' => 14, 'f' => 15, 'A' => 10, 'B' => 11, 'C' => 12, 'D' => 13, 'E' => 14, 'F' => 15); my $__bhf = $__bhj ^ substr($__bhh, $__bhb); if ($__bhi % $__bha) { my $__bhg = unpack("H", substr($__bhf, 0, 1)); $__bhc .= substr($__bhf, $__bhe{$__bhg}); } else { $__bhc .= $__bhf; } return $__bhc; } sub _xe { require "MIME/Base64.pm"; return MIME::Base64::encode_base64url(shift, ""); } sub _xf { require "MIME/Base64.pm"; return MIME::Base64::decode_base64url(shift); } sub _xg { my $__bhk = @{$_[0]} - 1; my $__bhl = 0; if ($__bhk == 1) { if (rand() > 0.5) { ($_[0]->[0], $_[0]->[1]) = ($_[0]->[1], $_[0]->[0]); } } else { for (; $__bhk > 0; $__bhk--) { $__bhl = int(rand($__bhk + 1)); ($_[0]->[$__bhk], $_[0]->[$__bhl]) = ($_[0]->[$__bhl], $_[0]->[$__bhk]); } } } sub _xh { my ($__bhn) = @_; my $__bhm = ""; $__bhm .= nonceinserter9_15_4::_bvq("<script type=\"text/javascript\">\n"); $__bhm .= $__bhn; $__bhm .= "\n</script>\n"; return $__bhm; } sub _xi { my ($__bhy) = @_; my $__bho = ""; my $__bhp = ""; my $__bhq = 0; my $__bhr = ""; foreach $__bho (sort keys(%authlib9_15_4::_akv)) { $__bhp = $authlib9_15_4::_akv{$__bho}; if($authlib9_15_4::_akr == 0){ $__bhp = htmlentity::encode($__bhp); } $authlib9_15_4::_akv{$__bho} = $__bhp; if (!$__bhy && ref($__bhp) eq "ARRAY") { $__bhq = $__bhp; $__bhp = $__bhq->[0]; $authlib9_15_4::_akv{$__bho} = $__bhp; my $__bhs = @{$__bhq}; my $__bht = 0; my $__bhu = $__bhq->[0]; my $__bhv = 0; for ($__bht = 1; $__bht < $__bhs; $__bht++) { if ($__bhu ne $__bhq->[$__bht]) { $__bhv = 1; last; } } if ($__bhv) { $__bhr .= "Found Null character in the %in hash. Key: " . $__bho . " Value: " . join(" | ", @{$__bhq}); } } elsif (!$__bhy && $__bhp =~ m/\0/o) { my @__bhw = split("\0", $__bhp); my $__bhx = $__bhp; $__bhp = $__bhw[0]; $authlib9_15_4::_akv{$__bho} = $__bhp; $__bhr .= "Found Null character in the %in hash (null in string). Key: " . $__bho . " Value: " . $__bhx; } if ($__bho eq "hid_respnum") { if ($__bhp !~ m/^\w{0,100},?\w{0,100}$/o) { authlib9_15_4::_zr(103, "", "Malformed respondent number input.", ""); } } elsif ($__bho eq "hid_studyname") { if ($__bhp !~ m/^\w{0,50}$/o) { authlib9_15_4::_zr(104, "", "Malformed studyname input.", ""); } } elsif ($__bho eq "hid_pagenum") { if ($__bhp !~ m/^\d{0,10}$/o) { authlib9_15_4::_zr(105, "", "Malformed page number input.", ""); } } elsif ($__bho eq "hid_javascript") { if ($__bhp !~ m/^[0-1]$/o) { authlib9_15_4::_zr(106, "", "Malformed JavaScript flag input.", ""); } } elsif ($__bho eq "hid_backup") { if ($__bhp !~ m/^[\w,]{0,100}$/o) { authlib9_15_4::_zr(107, "", "Malformed backup input.", ""); } } } return $__bhr; } sub _xj { my ($__biv, $__biw, $__bix, $__biy) = @_; my $__bhz = $authlib9_15_4::_aku->{"num_data_tables"}; my @__bia = (); my @__bib = (); my $__bic = 0; for ($__bic = 0; $__bic < $__bhz; $__bic++) { push @__bia, []; push @__bib, []; } my $__bid = 0; my $__bie = ""; my $__bif = ""; my $__big = 0; my $__bih = 0; my $__bii = ""; my $__bij = ""; if (@{$__biv} > 0) { my @__bik = (); my @__bil = (); my @__bim = (); my @__bin = (); my @__bio = (); my $__bip = ""; my %__biq = (); if (!$__bix) { my $__bir = time(); my $__bis = $__bir - authlib9_15_4::_ws("sys_StartTimeStamp"); push @{$__biv}, ["sys_EndTimeStamp", $__bir]; push @{$__biv}, ["sys_ElapsedTime", $__bis]; my $__bit = _aet(); if ($__bit > 0) { push @{$__biv}, ["sys_ScreenWidth", $__bit]; } } foreach $__big (@{$__biv}) { $__bie = $__big->[0]; $__bif = authlib9_15_4::_zp($__big->[1]); $__bii = ""; $__biq{$__bie} = 1; if (exists $authlib9_15_4::_akv{"hid_loops"}) { $__bii = $__bie; $__bii =~ s/(\.\d+)+//; } if ($__bif eq "") { delete $authlib9_15_4::_akn->{$__bie}; $__bif = undef; if ($__bii) { delete $authlib9_15_4::_akn->{$__bii}; } } else { authlib9_15_4::_wt($__bie, $__bif); if ($__bii) { authlib9_15_4::_wt($__bii, $__bif); } } ($__bih, $__bij) = _xk($__bie); if ($__bih) { if (_xu($__bie)) { push @{$__bib[$__bih - 1]}, "`$__bie`= coalesce(`$__bie`, 0) + ?"; } else { push @{$__bib[$__bih - 1]}, "`$__bie`=?"; } push @{$__bia[$__bih - 1]}, _wh($__bif); } else { authlib9_15_4::_zr(331, "Database error.", "Database error. Cannot find the field '" . $__bie . "' in the map table.", $@); } } for ($__bic = 0; $__bic < $__bhz; $__bic++) { @__bin = @{$__bib[$__bic]}; @__bim = @{$__bia[$__bic]}; if (@__bim) { if ($__biy) { my @__biu = @{$__biw}; eval { $__bip = "UPDATE `" . $authlib9_15_4::_akq . "_data" . ($__bic + 1) . "` SET " . join(",", @__bin) . " WHERE `sys_RespNum` IN (" . join(",", ("?") x scalar @__biu) . ");"; my $__bid = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__bip, 0)); $__bid->execute(@__bim, @__biu); }; } else { eval { $__bip = "UPDATE `" . $authlib9_15_4::_akq . "_data" . ($__bic + 1) . "` SET " . join(",", @__bin) . " WHERE `sys_RespNum` = " . $__biw; my $__bid = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__bip, 0)); $__bid->execute(@__bim); }; } if ($@) { authlib9_15_4::_zr(240, "Database error.", "Database error. Cannot update data row.", $@); } } } $authlib9_15_4::_akl->commit(); } } sub _xk { my ($__bjh) = @_; my $__biz = 0; my $__bja = ""; my @__bjb = (); my $__bjc = ""; if (exists $authlib9_15_4::_aia->{$__bjh}) { $__biz = $authlib9_15_4::_aia->{$__bjh}; push @__bjb, $__bjh; } else { my $__bjd = ""; if ($__bjh eq "sys_RespNum") { $__biz = 1; } else { $__bjd = "SELECT * FROM `" . $authlib9_15_4::_akq . "_map` WHERE `name` = '" . $__bjh . "'"; eval { my @__bje = $authlib9_15_4::_akl->selectrow_array(authlib9_15_4::_wn($__bjd, 0)); if (@__bje) { $__biz = $__bje[0]; $__bja = $__bje[2]; } }; if ($@) { authlib9_15_4::_zr(261, "Database error.", "Database error. Cannot select map row.", $@); } } if ($__biz) { if ($__bja) { $__bjd = "SELECT * FROM `" . $authlib9_15_4::_akq . "_map` WHERE `base_name` = '" . $__bja. "' AND `table` = " . $__biz; eval { my $__bjf = $authlib9_15_4::_akl->selectall_arrayref(authlib9_15_4::_wn($__bjd, 0)); my $__bjg = 0; foreach $__bjg (@{$__bjf}) { $__biz = $__bjg->[0]; $__bjh = $__bjg->[1]; $authlib9_15_4::_aia->{$__bjh} = $__biz; push @__bjb, $__bjh; } }; if ($@) { authlib9_15_4::_zr(340, "Database error.", "Database error. Cannot select map row.", $@); } } else { push @__bjb, $__bjh; $authlib9_15_4::_aia->{$__bjh} = $__biz; } } else { $authlib9_15_4::_aia->{$__bjh} = 0; } } $__bjc = "`" . join("`,`", @__bjb) . "`"; return ($__biz, $__bjc); } sub _xl { my ($__bjm) = @_; my $__bji = 0; my $__bjj = "SELECT * FROM `" . $authlib9_15_4::_akq . "_map` WHERE `name` LIKE '" . $__bjm . ".%'"; my $__bjk = 0; eval { my @__bjl = $authlib9_15_4::_akl->selectrow_array(authlib9_15_4::_wn($__bjj, 0)); if (@__bjl) { $__bji = 1; } }; if ($@) { authlib9_15_4::_zr(347, "Database error.", "Database error. Cannot select map row.", $@); } return $__bji; } sub _xm { my ($__bjt, $__bju) = @_; my $__bjn = 0; my $__bjo = ""; my $__bjp = ""; my @__bjq = (); my $__bjr = ""; my $__bjs = 0; eval { $__bjr = "INSERT INTO `" . $authlib9_15_4::_akq . "_clists` (`sys_RespNum`,`list_name`,`value`) VALUES (?, ?, ?)"; $__bjs = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__bjr, 0)); }; if ($@) { authlib9_15_4::_zr(253, "Database error.", "Database error. Cannot prepare SQL for inserting clist row.", $@); } foreach $__bjn (@{$__bjt}) { $__bjo = $__bjn->[0]; $__bjp = $__bjn->[1]; authlib9_15_4::_wt($__bjo, $__bjp); eval { $__bjs->execute($__bju, $__bjo, authlib9_15_4::_wh($__bjp)); }; if ($@) { push @__bjq, $__bjn; } } if (@__bjq) { eval { $__bjr = "UPDATE `" . $authlib9_15_4::_akq . "_clists` SET `value` = ? WHERE `sys_RespNum` = ? AND `list_name` = ?"; $__bjs = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__bjr, 0)); }; if ($@) { authlib9_15_4::_zr(315, "Database error.", "Database error. Cannot prepare SQL for updating clist row.", $@); } } foreach $__bjn (@__bjq) { $__bjo = $__bjn->[0]; $__bjp = $__bjn->[1]; authlib9_15_4::_wt($__bjo, $__bjp); eval { $__bjs->execute(authlib9_15_4::_wh($__bjp), $__bju, $__bjo); }; if ($@) { authlib9_15_4::_zr(316, "Database error.", "Database error. Cannot update clist row.", $@); } } eval { $authlib9_15_4::_akl->commit(); }; if ($@) { authlib9_15_4::_zr(317, "Database error.", "Database error. Cannot insert clist row.", $@); } } sub _xn { my ($__bke, $__bkf) = @_; my @__bjv = (); my @__bjw = (); my @__bjx = reverse @{authlib9_15_4::_xy($__bke, {'limbo' => 0})}; my @__bjy = sort {$__bkf->{$a} <=> $__bkf->{$b}} keys %{$__bkf}; my $__bjz = shift(@__bjy); my $__bka = 0; my $__bkb = 0; my $__bkc = 0; my $__bkd = 1; while ($__bkd && $__bjz) { $__bkd = 0; for ($__bka = 0; $__bka < @__bjx; $__bka++) { if (&authlib9_15_4::_ANI) { next if ($__bjx[$__bka]->{"quest_name"} eq "hid_page_vars_history" || $__bjx[$__bka]->{"page_num"} == 1); } else { next if ($__bjx[$__bka]->{"quest_name"} eq "hid_page_vars_history"); } last if ($__bjx[$__bka]->{"quest_name"} eq $__bjz || exists $__bjx[$__bka]->{"data"}->{$__bjz}); } $__bkc = $__bka; $__bkb = 0; for ($__bka++; $__bka < @__bjx; $__bka++) { if (&authlib9_15_4::_ANI) { next if ($__bjx[$__bka]->{"quest_name"} eq "hid_page_vars_history" || $__bjx[$__bka]->{"page_num"} == 1); } else { next if ($__bjx[$__bka]->{"quest_name"} eq "hid_page_vars_history"); } if ($__bjx[$__bka]->{"quest_name"} eq $__bjz || exists $__bjx[$__bka]->{"data"}->{$__bjz}) { $__bkb = _xo($__bjx[$__bkc]->{"data"}, $__bjx[$__bka]->{"data"}); if ($__bkb) { eval { $__bkd = 1; do { $authlib9_15_4::_akl->do(authlib9_15_4::_wn("UPDATE `" . $authlib9_15_4::_akq . "_history` SET `limbo`=1 WHERE `sys_RespNum`=" . $__bke . " AND `hop`=" . $__bjx[$__bkc]->{"hop"}, 0)); $__bjz = shift(@__bjy); splice(@__bjx, $__bkc, 1); $__bkc--; } while ($__bjz =~ m/^(?>sys|hid)_/io && $__bkc >= 0); $authlib9_15_4::_akl->commit(); last; }; if ($@) { authlib9_15_4::_zr(311, "Unable to update history row", $@, ""); } } else { @__bjw = (($__bkc + 1)..$__bka); } last; } } if (@__bjw) { _xp($__bke, \@__bjx, \@__bjw); last; } } } sub _xo { my ($__bkm, $__bkn) = @_; my $__bkg = 1; my @__bkh = keys %{$__bkm}; my @__bki = keys %{$__bkn}; my $__bkj = ""; my $__bkk = ""; my $__bkl = ""; if (@__bkh == @__bki) { foreach $__bkl (@__bkh) { if ($__bkm->{$__bkl} ne $__bkn->{$__bkl}) { $__bkg = 0; last; } } } else { $__bkg = 0; } return $__bkg; } sub _xp { my ($__blg, $__blh, $__bli) = @_; my @__bko = @{$__blh}; my @__bkp = @{$__bli}; my @__bkq = (); my $__bkr = $authlib9_15_4::_aku->{"num_data_tables"}; my $__bks = 0; my $__bkt = 0; my $__bku = ""; my $__bkv = ""; my %__bkw = (); _acy(); if ($authlib9_15_4::_als && @__bkp > 0) { while (my ($__bkx, $__blj) = each %{$authlib9_15_4::_als}) { if (ref($__blj) eq "CList") { $__bkw{$__bkx} = 1; $__bkw{$__bkx . "_others"} = 1; } } $__bkt = 0; while ($__bkt < @__bkp) { my $__bkx = $__bko[$__bkp[$__bkt]]->{"quest_name"}; $__bkx =~ s/^(\w+)(?:\.\d+)*$/$1/o; if (exists $__bkw{$__bkx}) { push(@__bkq, $__bkp[$__bkt]); splice(@__bkp, $__bkt, 1); } else { $__bkt++; } } } if (@__bkp > 0) { my @__bky = (); my @__bkz = (); my @__bla = (); for ($__bkt = 0; $__bkt < $__bkr; $__bkt++) { push @__bky, []; push @__bla, {}; } foreach my $__blb (@__bkp) { my $__blc = $__bko[$__blb]; if (&authlib9_15_4::_ANI) { next if ($__blc->{"quest_name"} eq "hid_page_vars_history" || _xu($__blc->{"quest_name"}) || $__blc->{"page_num"} == 1); } else { next if ($__blc->{"quest_name"} eq "hid_page_vars_history" || _xu($__blc->{"quest_name"})); } foreach my $__bld (sort keys %{$__blc->{"data"}}) { ($__bks, $__bku) = _xk($__bld); if ($__bks == 0 || exists $__bla[$__bks - 1]->{$__bld}) { next; } $__bla[$__bks - 1]->{$__bld} = 1; $authlib9_15_4::_ahz->{$__bld} = 1; push @{$__bky[$__bks - 1]}, "`" . $__bld . "`=null"; } } foreach my $__blb (@__bkp) { my $__blc = $__bko[$__blb]; push (@__bkz, "UPDATE `" . $authlib9_15_4::_akq . "_history` SET `limbo`=1 WHERE `sys_RespNum`=" . $__blg . " AND `hop`=" . $__blc->{"hop"}); } for ($__bkt = 0; $__bkt < $__bkr; $__bkt++) { my @__ble = @{$__bky[$__bkt]}; if (@__ble) { eval { $__bkv = "UPDATE `" . $authlib9_15_4::_akq . "_data" . ($__bkt + 1) . "` SET " . join(",", @__ble) . " WHERE `sys_RespNum` = " . $__blg; $authlib9_15_4::_akl->do(authlib9_15_4::_wn($__bkv, 0)); }; if ($@) { authlib9_15_4::_zr(203, "Database error.", "Database error. Cannot update data row. SQL: " . $__bkv, $@); } } } eval { foreach $__bkv (@__bkz) { $authlib9_15_4::_akl->do(authlib9_15_4::_wn($__bkv, 0)); } }; if ($@) { authlib9_15_4::_zr(272, "Database error.", "Database error. Cannot update history row.", $@); } } foreach my $__blf (@__bkq) { my $__blc = $__bko[$__blf]; $__bkv = "UPDATE `" . $authlib9_15_4::_akq . "_history` SET `limbo`=1 WHERE `sys_RespNum`=" . $__blg . " AND `hop`=" . $__blc->{"hop"}; $authlib9_15_4::_akl->do(authlib9_15_4::_wn($__bkv, 0)); $__bkv = "DELETE FROM `" . $authlib9_15_4::_akq . "_clists` WHERE `sys_RespNum`=" . $__blg . " AND `list_name`='" . $__blc->{"quest_name"}. "'"; $authlib9_15_4::_akl->do(authlib9_15_4::_wn($__bkv, 0)); $authlib9_15_4::_ahz->{$__blc->{"quest_name"}} = 1; } $authlib9_15_4::_akl->commit(); } sub _xq { my ($__blu) = @_; my $__blk = 0; my $__bll = ""; my $__blm = ""; my $__bln = 0; my $__blo = ""; eval { my $__blp = 1; my $__blq = $authlib9_15_4::_akq . "_info"; if ($authlib9_15_4::_aht->{'_pj'} eq "odbc") { $__blo = "SELECT OBJECT_ID('" . $__blq . "')"; my $__blr = $authlib9_15_4::_akl->selectrow_arrayref(authlib9_15_4::_wn($__blo, 0)); if (!$__blr->[0]) { $__blp = 0; } } $authlib9_15_4::_aku = 0; if ($__blp) { $__blo = "SELECT * FROM `" . $__blq . "`"; $authlib9_15_4::_aku = $authlib9_15_4::_akl->selectrow_hashref(authlib9_15_4::_wn($__blo, 0)); $authlib9_15_4::_aku->{"study_path"} = authlib9_15_4::_wi($authlib9_15_4::_aku->{"study_path"}); $authlib9_15_4::_aku->{"close_survey_msg"} = authlib9_15_4::_wi($authlib9_15_4::_aku->{"close_survey_msg"}); } }; if ($@ || $authlib9_15_4::_aku == 0) { $__blm = "Cannot read database info table."; $__bll = $@; } else { if (exists($ENV{'SSI_NO_PATH_CHECK'}) || (defined ($ENV{'SSI_NO_PATH_CHECK'}))) { $__blk = 1; } elsif (exists $authlib9_15_4::_aku->{"study_path"}) { my $__bls = $authlib9_15_4::_aku->{"study_path"}; my $__blt = $authlib9_15_4::_aib{'_amt'}; if (authlib9_15_4::_zd()) { $__bls = uc($__bls); $__blt = uc($__blt); } if (!$__blu && ($__bls eq $__blt)) { $__blk = 1; } else { if ($__blu) { $__blm .= "Error reading QST file. Entering setup mode...\n\n"; } $__blm .= "There are already database tables setup for \"" . $authlib9_15_4::_akq . "\" in this database."; $__blm .= " Either remove the \"" . $authlib9_15_4::_akq . "\" tables in this database or create a new database for this study."; $__blm .= "\n\n(Note: Another possibility is that the original path to the admin directory has changed. See the \"study_path\" column in the \"" . $authlib9_15_4::_akq . "_info\" table.)"; $__bln = 1; } } } return ($__blk, $__blm, $__bll, $__bln); } sub _xr { eval { my $__blv = "UPDATE `" . $authlib9_15_4::_akq . "_info` SET `close_survey` = 1"; $authlib9_15_4::_akl->do(authlib9_15_4::_wn($__blv, 0)); $authlib9_15_4::_akl->commit(); $authlib9_15_4::_aku->{"close_survey"} = 1; }; if ($@) { authlib9_15_4::_zr(219, "Database error.", "Database error. Error closing survey.", $@); } } sub _xs { my $__blw = {}; if (exists($ENV{'SSI_DATABASE_PASSWORD'})) { my @__blx = ("database_password", "database_username", "database_type", "database_address", "database_name", "database_port", "database_driver", "database_max_fields_table", "respnum_start"); $__blw->{"database_username"} = ""; $__blw->{"database_password"} = ""; $__blw->{"database_type"} = "mysql"; $__blw->{"database_address"} = "localhost"; $__blw->{"database_name"} = ""; $__blw->{"database_port"} = ""; foreach my $__bly (@__blx) { my $__blz = "SSI_" . uc($__bly); if (exists($ENV{$__blz})) { $__blw->{$__bly} = $ENV{$__blz}; } } } else { $__blw = _xt(); } return $__blw; } sub _xt { my %__bma = (); my $__bmb = $authlib9_15_4::_aib{'_amt'} . $authlib9_15_4::_ako . "_config.cgi"; my $__bmc = ""; my $__bmd = ""; my ($__bmh, $__bmi) = authlib9_15_4::_yg($__bmb, "read", 0, 1); my $__bme = _yb($__bmh); close $__bmh; my $__bmf = ""; my $__bmg = ""; while ($__bme =~ m/^(.*?):(.*?)$/mg) { $__bmf = authlib9_15_4::_zp($1); $__bmg = authlib9_15_4::_zp($2); $__bma{$__bmf} = $__bmg; } return \%__bma; } sub _xu { my ($__bmj) = @_; return ($__bmj eq "sys_SumPageTimes" || $__bmj =~ m/^sys_pagetime_\d+/i); } sub _xv { my ($__bnm, $__bnn, $__bno, $__bnp) = @_; my $__bmk = ""; my $__bml = 0; eval { $__bmk = "SELECT MAX(hop) FROM `" . $authlib9_15_4::_akq . "_history` WHERE `sys_RespNum`=" . $__bnn; ($__bml) = $authlib9_15_4::_akl->selectrow_array(authlib9_15_4::_wn($__bmk, 0)); }; if ($@) { authlib9_15_4::_zr(273, "Database error.", "Database error. Cannot get history row.", $@); } $__bml++; $__bmk = "INSERT INTO `" . $authlib9_15_4::_akq . "_history` (`ipaddress`,`user_agent`,`timestamp`,`qst_version`,`quest_name`,`quest_version`,`page_num`,`limbo`,`data`,`sys_RespNum`,`hop`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"; my $__bmm = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__bmk, 0)); $__bmk = "UPDATE `". $authlib9_15_4::_akq ."_history` SET `ipaddress`=?,`user_agent`=?,`timestamp`=?,`qst_version`=?,`quest_name`=?,`quest_version`=?,`page_num`=?,`limbo`=?,`data`=? WHERE `sys_RespNum`=? AND `hop`=?"; my $__bmn = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__bmk, 0)); my @__bmo = (); my $__bmp = ""; my $__bmq = ""; my @__bmr = @{$__bnm}; my $__bms = time(); my $__bmt = $authlib9_15_4::_aku->{"qst_version"}; my $__bmu = ""; my %__bmv = (); my $__bmw = 0; my $__bmx = ""; if (exists $authlib9_15_4::_akx->{'_gh'}) { $__bmu = _aad(); } my $__bmy = ""; if (exists $authlib9_15_4::_akx->{'_pr'}) { $__bmy = _wh(_aac()); } foreach my $__bmz (grep(/hid_prev_/, sort keys %authlib9_15_4::_akv)) { my ($__bnq, $__bnr, $__bna, $__bns) = split(",", $authlib9_15_4::_akv{$__bmz}); push(@__bmo, {hop => $__bnq, quest_name => $__bnr, quest_version => $__bns, page_num => $__bna}); } my $__bna = 0; my $__bnb = ""; my $__bnc = ""; my $__bnd = ""; if (not $__bno) { foreach my $__bne (sort {$a->{"hop"} <=> $b->{"hop"}} @__bmo) { $__bmq = ""; ($__bmp, $__bnc, $__bnd) = _abu($__bne->{"quest_name"}); for (my $__bnf = 0; $__bnf < @__bmr; $__bnf++) { ($__bnb, $__bnc, $__bnd) = _abu($__bmr[$__bnf]->[0]); if ($__bnb eq $__bmp) { $__bmq .= "'" . $__bmr[$__bnf]->[0] . "' => "; my $__bng = ""; if (exists $authlib9_15_4::_akv{$__bnb . "_" . $__bnc}) { $__bng = $authlib9_15_4::_akv{$__bnb . "_" . $__bnc}; } elsif (exists $authlib9_15_4::_akv{$__bmp}) { $__bng = $authlib9_15_4::_akv{$__bmp}; } else { $__bng = $__bmr[$__bnf]->[1]; } $__bng = _xx($__bng); $__bmq .= $__bng . ","; splice(@__bmr, $__bnf, 1); $__bnf--; } } chop($__bmq); $__bna = $__bne->{"page_num"}; if (not exists $__bmv{$__bne->{"quest_name"}} && !_xu($__bne->{"quest_name"}) ) { $__bmv{$__bne->{"quest_name"}} = $__bmw++; } eval { $__bmm->execute($__bmu, $__bmy, $__bms, $__bmt, $__bne->{"quest_name"}, $__bne->{"quest_version"}, $__bne->{"page_num"}, 0, _wh("{" . $__bmq . "}"), $__bnn, $__bml); $__bml++; }; if ($@) { my $__bnh = @_; eval { $__bmn->execute($__bmu, $__bmy, $__bms, $__bmt, $__bne->{"quest_name"}, $__bne->{"quest_version"}, $__bne->{"page_num"}, 0, _wh("{" . $__bmq . "}"), $__bnn, $__bml); }; if ($@) { $__bmm->finish; $__bmn->finish; authlib9_15_4::_zr(274, "Database error.", "Database error. Cannot insert or update history row.", $__bnh ."\t". $@); } } } } if ($__bna == 0) { foreach my $__bni (@__bmr) { my ($__bnb, $__bnc, $__bnd) = _abu($__bni->[0]); my $__bnj = $authlib9_15_4::_ahv{$__bnb}; if ($__bnj) { $__bna = $__bnj->{'_ji'}; last; } } if ($__bna == 0) { $__bna = $authlib9_15_4::_akv{"hid_pagenum"}; } } foreach my $__bni (@__bmr) { my $__bng = $__bni->[1]; $__bng = _xx($__bng); $__bmq = "'" . $__bni->[0] . "' => " . $__bng; if (!exists $__bmv{$__bni->[0]} && !_xu($__bni->[0])) { $__bmv{$__bni->[0]} = $__bmw++; } eval { $__bmm->execute($__bmu, $__bmy, $__bms, $__bmt, $__bni->[0], "0", $__bna, 0, _wh("{" . $__bmq . "}"), $__bnn, $__bml); $__bml++; }; if ($@) { my $__bnh = $@; eval { $__bmn->execute($__bmu, $__bmy, $__bms, $__bmt, $__bni->[0], "0", $__bna, 0, _wh("{" . $__bmq . "}"), $__bnn, $__bml); }; if ($@) { $__bmm->finish; $__bmn->finish; authlib9_15_4::_zr(274, "Database error.", "Database error. Cannot insert or update history row.", $__bnh ."\t". $@); } } } if (exists $authlib9_15_4::_akv{"hid_page_vars"}) { $__bmq = ""; my @__bnk = split(/,/, $authlib9_15_4::_akv{"hid_page_vars"}); foreach my $__bnl (@__bnk) { $__bmq .= "'" . $__bnl . "' => "; my $__bng = ""; if (exists $authlib9_15_4::_akv{$__bnl}) { $__bng = $authlib9_15_4::_akv{$__bnl}; } $__bng = _xx($__bng); $__bmq .= $__bng . ","; } chop($__bmq); eval { $__bmm->execute($__bmu, $__bmy, $__bms, $__bmt, "hid_page_vars_history", "0", $__bna, 0, _wh("{" . $__bmq . "}"), $__bnn, $__bml); $__bml++; }; if ($@) { my $__bnh = $@; eval { $__bmn->execute($__bmu, $__bmy, $__bms, $__bmt, "hid_page_vars_history", "0", $__bna, 0, _wh("{" . $__bmq . "}"), $__bnn, $__bml); }; if ($@) { $__bmm->finish; $__bmn->finish; authlib9_15_4::_zr(274, "Database error.", "Database error. Cannot insert or update history row.", $__bnh ."\t". $@); } } } $__bmm->finish; $__bmn->finish; unless ($__bnp) { _xn($__bnn, \%__bmv); } $authlib9_15_4::_akl->commit(); $authlib9_15_4::_akv{"sys_next_hop"} = $__bml; } sub _xw { my ($__boc, $__bod) = @_; my @__bnt = @{$__boc}; my $__bnu = 0; my $__bnv = 0; while ($__bnv < @__bnt) { my $__bnw = $__bnt[$__bnv]->[0]; my $__bnx = $__bnt[$__bnv]->[1]; my @__bny = (); eval { my $__bnz = "SELECT * FROM `" . $authlib9_15_4::_akq . "_history` WHERE `sys_RespNum`=" . $__bod . " AND `quest_name`='" . $__bnw . "' AND `quest_version`!='0' AND `limbo`=0 ORDER BY `hop` DESC"; @__bny = @{$authlib9_15_4::_akl->selectall_arrayref(authlib9_15_4::_wn($__bnz, 0), { Slice => {} })}; }; if ($@) { authlib9_15_4::_zr(282, "Database error.", "Database error. Cannot retrieve history row.", $@); } if (@__bny) { $__bnu = 1; my $__boa = authlib9_15_4::_xx($__bnx); eval { my $__bnz = "UPDATE `" . $authlib9_15_4::_akq . "_history` SET `data`=? WHERE `sys_RespNum`=" . $__bod . " AND `hop`=" . $__bny[0]->{"hop"}; my $__bob = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__bnz, 0)); $__bob->execute(_wh("{'" . $__bnw. "' => " . $__boa . "}")); splice(@__bnt, $__bnv, 1); }; if ($@) { authlib9_15_4::_zr(283, "Database error.", "Database error. Cannot update history row.", $@); } } else { $__bnv++; } } if ($__bnu) { $authlib9_15_4::_akl->commit(); } if (@__bnt) { authlib9_15_4::_xv(\@__bnt, $__bod, 1, 0); } } sub _xx { my ($__boe) = @_; $__boe =~ s/\\/\\\\/go; $__boe =~ s/'/\\'/go; if ($__boe eq "") { $__boe = "''"; } else { $__boe = "'" . $__boe . "'"; } return $__boe; } sub _xy { my ($__bom, $__bon) = @_; my %__bof = $__bon ? %{$__bon} : (); my $__bog = delete $__bof{"data"}; my $__boh = "SELECT * FROM `" . $authlib9_15_4::_akq . "_history` WHERE `sys_RespNum`=" . $__bom; if (keys %__bof) { while (my ($__boo, $__bop) = each %__bof) { $__boh .= " AND "; $__boh .= "`" . $__boo . "`="; $__boh .= $authlib9_15_4::_akl->quote($__bop); } } $__boh .= " ORDER BY `hop` ASC"; my $__boi = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__boh, 0)); my @__boj = (); eval { $__boi->execute(); }; if ($@ && !$authlib9_15_4::_amo) { authlib9_15_4::_zr(206, "Database error while retrieving history.", $authlib9_15_4::_akl->errstr, $@); } my @__bok = @{$__boi->fetchall_arrayref({})}; foreach my $__bol (@__bok) { next if (keys %{$__bol} == 1); eval { $__bol->{"data"} = eval(_wi($__bol->{"data"})); }; if ($@) { authlib9_15_4::_zr(278, "Database error while retrieving history.", "Database error while evaling history.", $@); } if ($__bog) { push(@__boj, $__bol) if (exists $__bol->{"data"}->{$__bog}); } else { push(@__boj, $__bol); } } return \@__boj; } sub _xz { my $__boq = $authlib9_15_4::_akv{"hid_respnum"}; my $__bor = 0; my $__bos = 0; if (exists $authlib9_15_4::_akv{"sys_next_hop"} && $authlib9_15_4::_akv{"sys_next_hop"} > 0) { $__bos = $authlib9_15_4::_akv{"sys_next_hop"}; } elsif (exists $authlib9_15_4::_akv{"sys_prev_low_hop"} && $authlib9_15_4::_akv{"sys_prev_low_hop"} > 0) { $__bos = $authlib9_15_4::_akv{"sys_prev_low_hop"}; } else { my @__bot = (); foreach my $__bou (grep(/hid_prev_/, (sort keys %authlib9_15_4::_akv))) { my ($__box,$__boy, $__boz, $__bpa) = split(",", $authlib9_15_4::_akv{$__bou}); push(@__bot, [ $__boy, $__box ]); } @__bot = sort {$a->[1] <=> $b->[1]} @__bot; $__bos = $__bot[0]->[1]; } my $__bov = "SELECT COUNT(*) FROM `" . $authlib9_15_4::_akq . "_history` WHERE `sys_RespNum`=" . $__boq . " AND `limbo` = 0 AND `quest_version` != '0' AND `hop` <= " . $__bos; eval { my $__bow = $authlib9_15_4::_akl->selectrow_arrayref(authlib9_15_4::_wn($__bov, 0)); $__bor = $__bow->[0]; }; if ($@ && !$authlib9_15_4::_amo) { authlib9_15_4::_zr(252, "Database error while retrieving history.", $authlib9_15_4::_akl->errstr, $@); } return $__bor; } sub _ya { my ($__bpd) = @_; my $__bpb = 0; if ($authlib9_15_4::_amo) { if (!$authlib9_15_4::_ajl) { $__bpb = $authlib9_15_4::_akx->{'_kc'}; } } elsif ($__bpd == 2) { if (!exists $authlib9_15_4::_akx->{'_nt'}) { my $__bpc = _ws("sys_ShowPrev"); if (exists $authlib9_15_4::_akv{"hid_test_mode_settings"} || exists $authlib9_15_4::_akv{"hid_show_prev"} || $__bpc) { $__bpb = $authlib9_15_4::_akx->{'_kc'}; } } } elsif ($__bpd > 2) { $__bpb = $authlib9_15_4::_akx->{'_kc'}; } return $__bpb; } sub _yb { my ($__bpi) = @_; binmode $__bpi; my $__bpe = -s $__bpi; my $__bpf = tell $__bpi; my $__bpg = ""; my $__bph = read($__bpi, $__bpg, $__bpe); if ($__bph != ($__bpe - $__bpf)) { authlib9_15_4::_zr(270, "File read error.", "File read error.", ""); } return $__bpg; } sub _yc { my ($__bpj, $__bpk) = @_; return do { local $/ = $__bpk; <$__bpj> }; } sub _yd { my ($__bpl) = @_; return do {local $/; <$__bpl> }; } sub _ye { my ($__bpn) = @_; my $__bpm = 0; if (&authlib9_15_4::_ANT <= $__bpn && $__bpn <= &authlib9_15_4::_ANW) { $__bpm = 1; } return $__bpm; } sub _yf { my ($__bpp) = @_; my $__bpo = 0; if (&authlib9_15_4::_AOG <= $__bpp && $__bpp <= &authlib9_15_4::_AOL) { $__bpo = 1; } return $__bpo; } sub _yg { my ($__bpw, $__bpx, $__bpy, $__bpz) = @_; my $__bpq = Symbol::gensym(); my $__bpr = ""; my $__bps = ""; my $__bpt = ""; if ($__bpx eq "write") { $__bpr = ">"; } elsif ($__bpx eq "read") { $__bpr = "<"; } elsif ($__bpx eq "update") { $__bpr = "+<"; } elsif ($__bpx eq "create_update") { $__bpr = "+>"; } elsif ($__bpx eq "append") { $__bpr = ">>"; } else { die("Unrecognized parameter in OpenFile() with: " . $__bpw); } my $__bpu = 0; my $__bpv = 0; open $__bpq, $__bpr . $__bpw or eval{$__bpu = 1}; if ($__bpu) { $__bps = "Can't open file " . $__bpw . "."; $__bpt = $!; if ($__bpz) { authlib9_15_4::_zr(117, "File open error.", $__bps, $__bpt); } else { $__bpv = {}; $__bpv->{'_amu'} = $__bps; $__bpv->{'_amv'} = $__bpt; } } return ($__bpq, $__bpv); } sub _yh { my ($__bqb) = @_; if (!exists $authlib9_15_4::_aje{$__bqb}) { my $__bqa = ""; if (!(-e $authlib9_15_4::_ajf . "/" . $__bqb)) { $__bqa = "Cannot find library in " . $authlib9_15_4::_ajf; } eval { require $__bqb; if ($__bqb eq "acalib9_15_4.pl") { acalib9_15_4::_arp(); } elsif ($__bqb eq "acbclib9_15_4.pl") { acbclib9_15_4::_bhq(); } }; if ($@) { $__bqa = $@; } if ($__bqa ne "") { print "Content-type: text/html\r\n\r\n"; print "<html><body><br><span style=\"color: red;\"><u>Error:</u> &nbsp;</span> "; print "Cannot load library: <span style=\"color: blue;\">" . $__bqb . "</span> <br><br>" . $__bqa; print "</body></html>"; exit(); } else { $authlib9_15_4::_aje{$__bqb} = 1; } } } sub _yi { my ($__bqe) = @_; my $__bqc = ""; if ($authlib9_15_4::_akx && exists $authlib9_15_4::_akx->{'_dn'}) { $__bqc .= $authlib9_15_4::_akx->{'_dn'}; } else { $__bqc .= "<!DOCTYPE html>"; } $__bqc .= "\n<html"; if (exists($authlib9_15_4::_akv{"hid_test_mode"})) { $__bqc .= " class=\"test_mode"; if (exists($authlib9_15_4::_akv{"hid_test_frame"})) { $__bqc .= " test_frame"; } $__bqc .= "\""; } $__bqc .= ">\n"; $__bqc .= "<head>\n\n"; $__bqc .= "<!-- Sawtooth Software Web Interviewing System - Lighthouse Studio " . $authlib9_15_4::_aig . " -->\n"; $__bqc .= "<!-- Copyright Sawtooth Software, Inc. 1998-2022 - www.sawtoothsoftware.com - USA - (801) 477-4700 -->\n\n"; my $__bqd = $authlib9_15_4::_aib{'_ur'} . "system/"; if ($__bqe) { $__bqd .= "ssi.ico"; } else { $__bqd .= "survey.ico"; } $__bqc .= "<link rel=\"shortcut icon\" href=\"" . $__bqd . "\" type=\"image/x-icon\">\n"; if ($authlib9_15_4::_akx && exists $authlib9_15_4::_akx->{'_mg'}) { } else { $__bqc .= "<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n"; $__bqc .= "<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n"; $__bqc .= "<meta name=\"robots\" content=\"noindex, nofollow\">\n\n"; $__bqc .= "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n"; if ($authlib9_15_4::_amo || exists $authlib9_15_4::_akv{"hid_test_mode"}) { $__bqc .= "<meta http-equiv=\"Cache-Control\" content=\"no-cache, no-store, must-revalidate\"/>\n"; $__bqc .= "<meta http-equiv=\"Pragma\" content=\"no-cache\" />\n"; $__bqc .= "<meta http-equiv=\"Expires\" content=\"0\" />\n"; } } return $__bqc; } sub _yj { my $__bqf = ""; my $__bqg = ""; $__bqf .= "<div id=\"demo_header\">"; $__bqf .= "<div id=\"demo_title\">Sawtooth Software - Demo Version</div>"; $__bqf .= "<div id=\"demo_warning\">NOTE: The demo version is limited to 10 respondent data records</div>"; $__bqf .= "</div>"; return $__bqf; } sub _yk { my $__bqh = lite::new(); %authlib9_15_4::_akv = $__bqh->parse_new_form_data(); if ($authlib9_15_4::_akv{'hid_studyname'} =~ m/\W/g) { authlib9_15_4::_zr(327, "Access error.", "The studyname passed in contains invalid characters.", "", 0); } } sub _yl { my ($__bqp, $__bqq, $__bqr, $__bqs) = @_; my $__bqi = 0; my $__bqj = ""; my $__bqk = ""; my $__bql = ""; my $__bqm = ""; if ($__bqr) { no strict; open($authlib9_15_4::_ajs, '<', \$__bqr); } elsif ($__bqs) { ($authlib9_15_4::_ajs, $__bqi) = authlib9_15_4::_yg($__bqs, "read", 1, $__bqq); } else { my $__bqn = $authlib9_15_4::_aib{'_amt'} . $authlib9_15_4::_ako . "_qst.cgi"; ($authlib9_15_4::_ajs, $__bqi) = authlib9_15_4::_yg($__bqn, "read", 1, $__bqq); } if (!$__bqi) { binmode $authlib9_15_4::_ajs; seek $authlib9_15_4::_ajs, 0, 0; ($__bqj, $__bqk, $__bql, $__bqi) = _ym($authlib9_15_4::_ajs, $__bqq, 0); if (!$authlib9_15_4::_amo && $authlib9_15_4::_aku) { $authlib9_15_4::_aku->{"qst_version"} = $__bqj; } if (!$__bqi) { ($authlib9_15_4::_aiq, $authlib9_15_4::_ain, $authlib9_15_4::_ajg, $authlib9_15_4::_ajj, $authlib9_15_4::_aio, $authlib9_15_4::_aip, $authlib9_15_4::_air) = _yn($authlib9_15_4::_ajs); if ($__bqp) { return ($__bqj, $__bqk, $__bqi); } $authlib9_15_4::_akw = authlib9_15_4::_zj(0); $authlib9_15_4::_akx = authlib9_15_4::_zj(0); my %__bqo = (); $authlib9_15_4::_aky = authlib9_15_4::_zj(0); } } return ($__bqj, $__bqk, $__bql, $__bqi); } sub _ym { my ($__brf, $__brg, $__brh) = @_; my $__bqt = ""; my $__bqu = <$__brf>; $__bqu = authlib9_15_4::_zp($__bqu); my @__bqv = split(",", $__bqu); my $__bqw = authlib9_15_4::_zp($__bqv[0]); if (($authlib9_15_4::_ako ne $__bqw) && !$authlib9_15_4::_amo) { authlib9_15_4::_zr(118, "Study name error.", "The study name passed in (" . $authlib9_15_4::_ako . ") does not match the study name in the STUDYNAME_qst.cgi file (" . $__bqw . "). The study name is case-sensitive." . "Make sure that the study name that you are passing in matches the name " . "of your study and try again.", ""); } my $__bqx = authlib9_15_4::_zp($__bqv[2]); if ($__bqx ne $authlib9_15_4::_aig) { $__bqt = "The Lighthouse Studio version number from STUDYNAME_qst.cgi (" . $__bqx . ") does not match the version number in the Perl files (" . $authlib9_15_4::_aig . ")."; if ($__brg) { authlib9_15_4::_zr(119, "Version number does not match.", $__bqt); } } my $__bqy = authlib9_15_4::_zp($__bqv[3]); my $__bqz = authlib9_15_4::_zp($__bqv[4]); my $__bra = authlib9_15_4::_zp($__bqv[5]); my $__brb = authlib9_15_4::_zp($__bqv[6]); if ($__brb ne $authlib9_15_4::_aii) { $__bqt = "The Build ID in the QST (" . $__brb . ") does not match the Build ID in the Perl files (" . $authlib9_15_4::_aii . "). Make sure you are using the Perl files that installed with Lighthouse Studio."; if ($__brg) { authlib9_15_4::_zr(120, "Build ID error.", $__bqt); } } if (!$__brh) { my $__brc = authlib9_15_4::_zp($__bqv[7]); if ($__brc == 1) { $authlib9_15_4::_alc = 1; } elsif ($__brc == 2) { $authlib9_15_4::_ald = 1; } elsif ($__brc == 3) { $authlib9_15_4::_ale = 1; } else { $authlib9_15_4::_alc = 0; $authlib9_15_4::_ald = 0; $authlib9_15_4::_ale = 0; } $authlib9_15_4::_alf = authlib9_15_4::_zp($__bqv[8]); if (exists $authlib9_15_4::_akv{"hid_test_mode"}) { my $__brd = $authlib9_15_4::_akv{"hid_test_mode"}; if ($__brd ne $authlib9_15_4::_alf) { authlib9_15_4::_zr(324, "Invalid test ID.", "The test ID passed in the URL does not match the test ID in the QST."); } } } my $__bre = 0; if ($__bqt) { $__bre = {}; $__bre->{'_amu'} = "Error reading QST file."; $__bre->{'_amv'} = $__bqt; } return($__bqy, $__bqz, $__bra, $__bre); } sub _yn { my ($__brr) = @_; my $__bri = <$__brr>; $__bri = authlib9_15_4::_zp($__bri); my @__brj = split(",", $__bri); my $__brk = authlib9_15_4::_zp($__brj[0]); my $__brl = authlib9_15_4::_zp($__brj[1]); my $__brm = authlib9_15_4::_zp($__brj[2]); my $__brn = authlib9_15_4::_zp($__brj[3]); my $__bro = authlib9_15_4::_zp($__brj[4]); my $__brp = authlib9_15_4::_zp($__brj[5]); my $__brq = authlib9_15_4::_zp($__brj[6]); return ($__brk, $__brl, $__brm, $__brn, $__bro, $__brp, $__brq); } sub _yo { if (!$authlib9_15_4::_alg) { if ($authlib9_15_4::_ajj > 0) { seek $authlib9_15_4::_ajs, $authlib9_15_4::_ajj, 0; $authlib9_15_4::_alg = _zj(1); } } } sub _yp { my ($__brx, $__bry) = @_; my @__brs = split("", $__brx); my $__brt = ""; my $__bru = ""; my $__brv = @__brs; my $__brw = 0; for ($__brw = 0; $__brw < $__brv; $__brw++) { $__bru .= sprintf "%lx", ord($__brs[$__brw]); } if (length($__bru) > $__bry) { if ($__bru =~ m/(.{$__bry})/) { $__bru = $1; } } return $__bru; } sub _yq { my $__brz = "<!--INPUT-->"; authlib9_15_4::_yo(); if (exists $authlib9_15_4::_alg->{'_ju'}) { my $__bsa = $authlib9_15_4::_alg->{'_ju'}->{'_jt'}; my $__bsb = 0; foreach $__bsb (@{$__bsa}) { $__brz .= "&" . $__bsb->{'_if'} . "=VALUE"; } } if (exists $authlib9_15_4::_alg->{'_jr'}) { my $__bsa = $authlib9_15_4::_alg->{'_jr'}; my $__bsb = 0; foreach $__bsb (@{$__bsa}) { $__brz .= "&" . $__bsb->{'_if'} . "=VALUE"; } } $__brz .= "<!--END INPUT-->"; return $__brz; } sub _yr { my ($__btf, $__btg) = @_; my $__bsc = ""; my $__bsd = 0; my @__bse = (); my @__bsf = (); foreach $__bsd (@{$__btf}) { my $__bsg = $__bsd->{'_uf'}; my $__bsh = $__bsg->{'_lf'}; my $__bsi = @{$__bsh}; my $__bsj = $__bsg->{'_bx'}; my $__bsk = 0; my $__bsl = 0; my $__bsm = 0; my $__bsn = 0; my $__bso = 0; my $__bsp = 0; my $__bsq = 0; my $__bsr = $__bsd->{'_if'}; my $__bss = 7919 + ($__btg - 1) * 100000 + _acu($__bsr); if ($__bsj == &authlib9_15_4::_API) { my @__bst = (0..($__bsi - 1)); $__bsp = \@__bst; } elsif ($__bsj == &authlib9_15_4::_APJ || $__bsj == &authlib9_15_4::_APK) { my $__bsu = _acp($__btg, $__bsi, $__bss); my $__bsv = 0; my @__bsw = (); my $__bsx = 0; my $__bsy = _yv($__bsd->{'_if'}, 0); my $__bsz = 0; my $__bta = 0; foreach $__bsv (@{$__bsu}) { $__bsz = 0; $__bsl = $__bsh->[$__bsv]; $__bta = $__bsy->{$__bsl->{'_pt'}}; if ($__bta->{'_hi'} > 0) { if ($__bsj == &authlib9_15_4::_APJ) { $__bsz = ($__bta->{'_amw'} / $__bta->{'_hi'}); } else { $__bsz = $__bta->{'_amw'}; } } push @__bsw, {'_fz' => $__bsv, '_nv' => $__bsz}; } @__bsw = sort{$a->{'_nv'} <=> $b->{'_nv'}} @__bsw; $__bsp = (); foreach $__bsx (@__bsw) { push @{$__bsp}, $__bsx->{'_fz'}; } } elsif ($__bsj == &authlib9_15_4::_APL || $__bsj == &authlib9_15_4::_APM) { my $__btb = 1; my $__btc = $__bsi; if ($__bsj == &authlib9_15_4::_APM && exists $__bsg->{'_lp'}) { $__btb = $__bsg->{'_lp'}->[0]; $__btc = $__bsg->{'_lp'}->[1]; } $__bsp = authlib9_15_4::_aco($__btg, $__bsi, $__bss, $__btb, $__btc); } else { authlib9_15_4::_zr(364, "Quota error.", "Quota check for cell membership method not defined.", ""); } for ($__bsk = 0; $__bsk < $__bsi; $__bsk++) { $__bsl = $__bsh->[$__bsp->[$__bsk]]; if (_yt($__bsd, $__bsl->{'_pt'})) { $__bsm = _zy($__bsl->{'_hk'}, "quota control"); if ($__bsm) { $__bso = 1; $__bsq = $__bsl->{'_pt'}; last; } else { $__bsq = -1; } } elsif ($__bsq == 0) { $__bsq = -2; } } push @__bse, {'_if'=> $__bsd->{'_if'}, '_pt'=> $__bsq}; if (!$__bso && $__bsc eq "") { $__bsc = $__bsg->{'_dy'}; } } my @__btd = (); my $__bte = 0; foreach $__bte (@__bse) { push @__btd, [$__bte->{'_if'}, $__bte->{'_pt'}]; } authlib9_15_4::_xw(\@__btd, $__btg); authlib9_15_4::_xj(\@__btd, $__btg, 0); return $__bsc; } sub _ys { if ($authlib9_15_4::_ali == 0) { if ($authlib9_15_4::_ajg) { my $__bth = tell $authlib9_15_4::_ajs; if ($__bth < 0) { authlib9_15_4::_yl(1, 1, ""); } seek $authlib9_15_4::_ajs, ($authlib9_15_4::_ajg), 0; $authlib9_15_4::_ali = _zj(0); if ($__bth < 0) { close $authlib9_15_4::_ajs; } else { seek $authlib9_15_4::_ajs, $__bth, 0; } } else { authlib9_15_4::_zr(122, "File read error.", "Problem reading QST Quota section: Quotas are not defined.", ""); } } } sub _yt { my ($__btn, $__bto) = @_; my $__bti = 0; my $__btj = $__btn->{'_uf'}; my $__btk = _yv($__btn->{'_if'}, $__btj); my $__btl = $__btk->{$__bto}->{'_amw'}; my $__btm = $__btk->{$__bto}->{'_hi'}; if (exists $__btj->{'_fw'}) { $__bti = $__btl + $__btk->{$__bto}->{'in-progress'}; } else { $__bti = $__btl; } if ($__btm > $__bti) { return 1; } else { return 0; } } sub _yu { my ($__bun, $__buo) = @_; my $__btp = 0; if ($authlib9_15_4::_alj) { if (!exists $authlib9_15_4::_alj->{uc($__bun)}) { $__btp = 1; } } else { $__btp = 1; $authlib9_15_4::_alj = {}; } if ($__btp && _aev()) { my $__btq = 0; my $__btr = {}; my ($__bup, $__buq) = _xk($__bun); my ($__bur, $__buq) = _xk("sys_RespRemoved"); my $__bts = 0; my $__btt = 0; my $__btu = 0; my $__btv = $__buo->{'_lf'}; my $__btw = 0; foreach $__btw (@{$__btv}) { $__btr->{$__btw->{'_pt'}} = {'_amw' => 0, 'in-progress' => 0, 'admin-in-progress' => 0, 'in-active' => 0, '_hi' => 0}; } if (exists $__buo->{'_fw'}) { $__bts = 1; if (exists $__buo->{'_fw'}->{'_ou'}) { $__btt = int($__buo->{'_fw'}->{'_ou'} * 60); } if (exists $__buo->{'_fw'}->{'_lx'}) { $__btu = $__buo->{'_fw'}->{'_lx'}; } } my $__btx = ""; my $__bty = ""; my $__btz = time(); my $__bua = ""; my $__bub = "`$authlib9_15_4::_akq\_data1`"; my $__buc = "`$authlib9_15_4::_akq\_data$__bur`"; if ($__bup > 1) { $__bua = "`$authlib9_15_4::_akq\_data$__bup`"; $__btx .= "SELECT $__bua.`$__bun`, $__bub.`sys_RespStatus`, COUNT(*) FROM $__bub INNER JOIN $__bua ON $__bua.`sys_RespNum` = $__bub.`sys_RespNum`"; if ($__buc ne $__bua && $__buc ne $__bub) { $__btx .= " INNER JOIN $__buc ON $__buc.`sys_RespNum` = $__bub.`sys_RespNum`"; } $__btx .= " WHERE (($__buc.`sys_RespRemoved` IS NULL) OR ($__buc.`sys_RespRemoved` = 0))"; if (!$__bts) { $__btx .= " AND $__bub.`sys_RespStatus` = ". &authlib9_15_4::_AOP; } $__bty = " GROUP BY $__bua.`$__bun`, $__bub.`sys_RespStatus`"; } else { $__btx .= "SELECT `$__bun`, `sys_RespStatus`, COUNT(*) FROM $__bub"; if ($__bur > 1) { $__btx .= " INNER JOIN $__buc ON $__buc.`sys_RespNum` = $__bub.`sys_RespNum`"; } $__btx .= " WHERE (($__buc.`sys_RespRemoved` IS NULL) OR ($__buc.`sys_RespRemoved` = 0))"; if (!$__bts) { $__btx .= " AND `sys_RespStatus` = ". &authlib9_15_4::_AOP; } $__bty = " GROUP BY `$__bun`,`sys_RespStatus`"; } eval { $__btq = $authlib9_15_4::_akl->selectall_arrayref(authlib9_15_4::_wn($__btx . $__bty, 0)); }; if ($@) { authlib9_15_4::_zr(229, "Database error.", "Database error reading data for quotas.", $@); } my $__bud = 0; my $__bue = 0; my $__buf = 0; my $__bug = 0; my $__buh = 0; my $__bui = 0; foreach $__bud (@{$__btq}) { $__buh = $__bud->[0]; $__buf = $__bud->[1]; $__bui = $__bud->[2]; if ($__buh > 0) { if ($__buf == &authlib9_15_4::_AOP) { $__btr->{$__buh}->{'_amw'} += $__bui; } elsif ($__buf == &authlib9_15_4::_AON) { $__btr->{$__buh}->{'in-progress'} += $__bui; } } } if ($__btt) { my $__buj = 0; $__btx .= " AND "; if ($__bup > 1) { $__btx .= $__bub . "."; } $__btx .= "`sys_RespStatus` = ". &authlib9_15_4::_AON . " AND "; if ($__bup > 1) { $__btx .= $__bub . "."; } $__btx .= "`sys_EndTimeStamp` < ". ($__btz - $__btt); eval { $__buj = $authlib9_15_4::_akl->selectall_arrayref(authlib9_15_4::_wn($__btx . $__bty, 0)); }; if ($@) { authlib9_15_4::_zr(323, "Database error.", "Database error reading data for quotas.", $@); } foreach $__bud (@{$__buj}) { $__buh = $__bud->[0]; $__buf = $__bud->[1]; $__bui = $__bud->[2]; if ($__buh > 0) { $__btr->{$__buh}->{'in-active'} += $__bui; $__btr->{$__buh}->{'in-progress'} -= $__bui; } } } if ($__bts) { my $__buk = 0; foreach $__buh (keys %{$__btr}) { $__buk = $__btr->{$__buh}->{'in-progress'}; $__btr->{$__buh}->{'actual-in-progress'} = $__buk; $__btr->{$__buh}->{'in-progress'} = $__buk; if ($__btu) { $__btr->{$__buh}->{'in-progress'} = int($__buk * ($__btu / 100)); } } } $__btx = "SELECT `cell_value`, `cell_limit` FROM `" . $authlib9_15_4::_akq . "_quotas` WHERE `quota_name` = " . $authlib9_15_4::_akl->quote($__bun); eval { $__btq = $authlib9_15_4::_akl->selectall_arrayref(authlib9_15_4::_wn($__btx, 0)); }; if ($@) { authlib9_15_4::_zr(230, "Database error.", "Database error reading quota table.", $@); } if (@{$__btq}) { my $__bul = 0; my $__bum = 0; foreach $__bud (@{$__btq}) { $__bul = $__bud->[0]; $__bum = $__bud->[1]; $__btr->{$__bul}->{'_hi'} = $__bum; } } else { authlib9_15_4::_zr(231, "Database error.", "Database error quota table returned nothing.", $@); } $authlib9_15_4::_alj->{uc($__bun)} = $__btr; } } sub _yv { my ($__buu, $__buv) = @_; if ($__buv == 0) { my $__bus = _yy($__buu); $__buv = $__bus->{'_uf'}; } _yu($__buu, $__buv); my $__but = 0; if (exists $authlib9_15_4::_alj->{uc($__buu)}) { $__but = $authlib9_15_4::_alj->{uc($__buu)}; } return $__but; } sub _yw { my ($__bve) = @_; my $__buw = 0; my $__bux = ""; _ys(); if ($authlib9_15_4::_ali) { my $__buy = $authlib9_15_4::_ali->{'_lg'}; my $__buz = ""; my $__bva = 0; my $__bvb = 0; foreach $__buz (@{$__buy}) { $__bva = authlib9_15_4::_ws($__buz); if ($__bva > 0) { $__bvb = _abd($__buz, $__bva); if ($__bvb == 0) { $__buw = 1; my $__bvc = _yy($__buz); $__bux = $__bvc->{'_uf'}->{'_dy'}; my @__bvd = (); push @__bvd, [$__buz, -3]; authlib9_15_4::_xj(\@__bvd, $__bve, 0); last; } } } } return ($__buw, $__bux); } sub _yx { my ($__bvh, $__bvi) = @_; my $__bvf = ""; if ($__bvi > 0) { my $__bvg = _yz($__bvh, $__bvi); if ($__bvg) { $__bvf = $__bvg->{'_if'}; } } elsif ($__bvi == -1) { $__bvf = "[Disqualified]"; } elsif ($__bvi == -2) { $__bvf = "[Over Quota]"; } elsif ($__bvi == -3) { $__bvf = "[Over Quota - Qualified Restart]"; } return $__bvf; } sub _yy { my ($__bvn) = @_; my $__bvj = 0; if (exists $authlib9_15_4::_ahv{$__bvn}) { $__bvj = $authlib9_15_4::_ahv{$__bvn}; my $__bvk = $__bvj->{'_iz'}; my $__bvl = tell $authlib9_15_4::_ajs; seek $authlib9_15_4::_ajs, $__bvk, 0; my $__bvm = _zj(1); $__bvj->{'_uf'} = $__bvm; seek $authlib9_15_4::_ajs, $__bvl, 0; } return $__bvj; } sub _yz { my ($__bvs, $__bvt) = @_; my $__bvo = _yy($__bvs); my $__bvp = 0; if ($__bvo) { my $__bvq = $__bvo->{'_uf'}->{'_lf'}; my $__bvr = 0; foreach $__bvr (@{$__bvq}) { if ($__bvr->{'_pt'} == $__bvt) { $__bvp = $__bvr; last; } } } return $__bvp; } sub _za { my ($__bvv, $__bvw) = @_; if ($__bvv =~ m/(.*?)_/i) { $__bvv = $1; } authlib9_15_4::_yh("acalib9_15_4.pl"); acalib9_15_4::_arq($__bvv, $__bvw); my $__bvu = $acalib9_15_4::_asw->{$__bvv}; return $__bvu; } sub _zb { my ($__bwd) = @_; my $__bvx = ""; my $__bvy = 0; my $__bvz = 0; my $__bwa = ""; my $__bwb = "text/html"; if ($authlib9_15_4::_akf) { $__bwb = "application/json"; } $__bwa .= authlib9_15_4::_zc($__bwd); $__bwa .= "Content-type: " . $__bwb . "\r\n\r\n"; if (exists($ENV{'MOD_PERL'}) && defined($ENV{'MOD_PERL'})) { $__bvy = 1; $__bvz = $ENV{'MOD_PERL'}; $__bvz =~ s/mod_perl\/(\d\.\d)(.*?)$/$1/i; } if ($ENV{'PERL_SEND_HEADER'} || ($__bvy == 0)) { $__bvx = $__bwa; } else { if ($__bvz < 1.9) { my $__bwc = Apache->request; $__bwc->content_type($__bwb); $__bwc->send_http_header; } else { $__bvx = $__bwa; } } $authlib9_15_4::_alk = 1; return $__bvx; } sub _zc { my ($__bwn) = @_; my $__bwe = ""; my $__bwf = ""; $__bwn //= 0; if (exists $ENV{"REMOTE_ADDR"}) { $__bwf = $ENV{"REMOTE_ADDR"}; } if(!($authlib9_15_4::_akx || $__bwn)){ return ""; } my $__bwg = ""; if($__bwn){ my $__bwh = ""; if($authlib9_15_4::_aho){ $__bwh = cookies9_15_4::_bwb(cookies9_15_4::_bwg(), $authlib9_15_4::_aho); } my $__bwi = "'" . "none" . "'"; my $__bwj = "'" . "nonce-[\%NONCE()\%]" . "'"; my $__bwk = "'" . "strict-dynamic" . "'"; my $__bwl = "'" . "self" . "'"; my $__bwm = "'" . "unsafe-inline" . "'"; $__bwg = "Cache-Control: no-cache, max-age=86400\nContent-Security-Policy: default-src $__bwi; script-src $__bwj $__bwk; connect-src $__bwl; object-src $__bwi; base-uri $__bwi; frame-ancestors $__bwl; img-src $__bwl data:; style-src $__bwm $__bwl; form-action $__bwl; frame-src $__bwl; font-src $__bwl;\n"."$__bwh"."Strict-Transport-Security: max-age=31536000; includeSubDomains\nX-Content-Type-Options: nosniff\nX-Frame-Options: DENY"; } elsif($authlib9_15_4::_akx){ if(!($__bwf !~ m/^::1$/ || exists $authlib9_15_4::_akx->{'_pp'})){ return ""; } if(!(exists $authlib9_15_4::_akx->{'_nb'})){ return ""; } $__bwg = $authlib9_15_4::_akx->{'_nb'}; } $__bwg =~ s/\n/\r\n/g; $__bwg = nonceinserter9_15_4::_bvp($__bwg); $__bwe .= $__bwg . "\r\n"; return $__bwe; } sub _zd { if (exists($ENV{'WINDIR'})) { return 1; } else { return 0; } } sub _ze { my ($__bwp, $__bwq) = @_; my $__bwo = 1; eval { if ($__bwq) { flock $__bwp, 2; } else { flock $__bwp, 1; } }; if ($@) { $@ = ""; $__bwo = 0; $authlib9_15_4::_all = 0; } seek $__bwp, 0, 0; return $__bwo; } sub _zf { my ($__bwu, $__bwv, $__bww) = @_; my $__bwr = 0; my $__bws = 0; if ($__bww) { ($__bwr, $__bws) = _yg($__bwu, "write", 1, 1); } else { ($__bwr, $__bws) = _yg($__bwu, "write", 0, 0); if ($__bws) { authlib9_15_4::_zr(328, "File error.", "Error opening lock file.", $__bws->{'_amv'}, 0); } } my $__bwt = authlib9_15_4::_ze($__bwr, $__bwv); if ($__bwt == 0) { if ($authlib9_15_4::_aih eq ".pl") { print authlib9_15_4::_zb(); print "<h4><u>Error</u>: This system does not support flock() for file locking. Please call Sawtooth Software.</h4>"; exit(); } _zg($__bwr); } return($__bwr); } sub _zg { my ($__bxa) = @_; my $__bwx = time + 20; my $__bwy = time; my $__bwz = $authlib9_15_4::_aib{'_amt'} . $authlib9_15_4::_ako . "_lockfiles/" . $__bxa . "_LOCKFILE.cgi"; while (-e $__bwz && $__bwy < $__bwx) { $__bwy = time; } if (-e $__bwz) { unlink($__bwz); } my ($__bxb, $__bxc) = authlib9_15_4::_yg($__bwz, "write", 0, 0); if ($__bxc) { print "Content-type: text/html\r\n\r\n Can't create file $__bwz. Check your write permissions." . $!; } close $__bxb; } sub _zh { my ($__bxe) = @_; my $__bxd = $authlib9_15_4::_aib{'_amt'} . $authlib9_15_4::_ako . "_lockfiles/" . $__bxe . "_LOCKFILE.cgi"; unlink $__bxd; } sub _zi { my ($__bxk) = @_; my $__bxf = {}; my @__bxg = (); my $__bxh = "SELECT COUNT(`sys_respnum`) FROM "; if ($__bxk) { push @__bxg, authlib9_15_4::_aex($__bxf, 1); push @__bxg, "`sys_RespStatus` = " . &authlib9_15_4::_AOP; } $__bxh = authlib9_15_4::_aew($__bxh, \@__bxg, $__bxf); my $__bxi = 0; eval { $__bxi = $authlib9_15_4::_akl->selectall_arrayref(authlib9_15_4::_wn($__bxh, 0)); }; if ($@) { authlib9_15_4::_zr(359, "Database error.", "Database error. Cannot get records.", $@); } my $__bxj = $__bxi->[0]->[0]; return $__bxj; } sub _zj { my ($__bxl) = @_; return _zk($authlib9_15_4::_ajs, $authlib9_15_4::_ako . "_qst.cgi", $__bxl); } sub _zk { my ($__bxy, $__bxz, $__bya) = @_; my $__bxm = 0; my $__bxn = ""; my $__bxo = "<\0\0/>"; if ($authlib9_15_4::_alc || $authlib9_15_4::_ald || $authlib9_15_4::_ale) { $__bxo = "<\0/>"; } $__bxn .= _yc($__bxy, $__bxo); if ($__bxn !~ s/^$__bxo//m) { authlib9_15_4::_zr(126, "File read error.", "The offsets in the " . $__bxz . " file are incorrect. Please recreate the file and try again.", $!); } <$__bxy>; if ($__bya && !$authlib9_15_4::_akd && !$authlib9_15_4::_alp) { $__bxn = _zx($__bxn, 1); } $__bxm = eval($__bxn); if ($@) { authlib9_15_4::_zr(127, "File read error.", "Problem reading QST section. Make sure that you have uploaded the " . $__bxz . " file in binary mode.", $@); } if (!defined($__bxm)) { authlib9_15_4::_zr(128, "File read error.", "Problem reading QST file. Text: " . $__bxn, ""); } if (exists($ciwlib9_15_4::_tx{'remove_rand'})) { my $__bxp = ref $__bxm; if (($__bxp ne "SCALAR") && ($__bxp ne "ARRAY")) { my $__bxq = $__bxm; if ($__bxp =~ m/^grid$/i) { $__bxq = $__bxm->{'_mv'}; _zl($__bxq); $__bxq = $__bxm->{'_cl'}; _zl($__bxq); my $__bxr = @{$__bxm->{'_pv'}}; my $__bxs = 0; my $__bxt = 0; for ($__bxt = 0; $__bxt < $__bxr; $__bxt++) { $__bxs = $__bxm->{'_pv'}->[$__bxt]; $__bxp = ref $__bxs; if ($__bxp eq "ComboVar") { _zl($__bxs); } elsif ($__bxp eq "RankVar") { _zl($__bxs); } } } elsif ($__bxp eq "HASH") { my $__bxu = 0; my $__bxv = ""; my $__bxw = ""; my $__bxx = ""; foreach $__bxv (keys %{$__bxm}) { $__bxu = $__bxm->{$__bxv}; $__bxw = ref $__bxu; if (($__bxw eq "CList") || ($__bxw eq "PList")) { if ($__bxw eq "CList") { $__bxx = $__bxu->{'_hk'}; $__bxx =~ s/RANDOMIZE(.*?);//; $__bxu->{'_hk'} = $__bxx; } } else { last; } } } else { if ($__bxp ne "") { _zl($__bxq); } } } } return $__bxm; } sub _zl { my ($__byc) = @_; my $__byb = ""; if (exists $__byc->{'_la'}) { delete($__byc->{'_la'}); } if (exists $__byc->{'_jn'}) { delete($__byc->{'_jn'}); } if (exists $__byc->{'_ln'}) { delete($__byc->{'_ln'}); } if (exists $__byc->{'_amx'}) { delete($__byc->{'_amy'}); } } sub _zm { my ($__byp) = @_; my $__byd = 0; my $__bye = $__byp; my $__byf = ""; $__bye = reverse($__bye); $__bye =~ s/^.*?\///; $__bye = reverse($__bye); my $__byg = $__bye . '/admin/' . $authlib9_15_4::_ako . "_path.cgi"; my $__byh = $__bye . "/" . $authlib9_15_4::_ako . "/admin/" . $authlib9_15_4::_ako . "_path.cgi"; my $__byi = $__byp . "/" . $authlib9_15_4::_ako . "_path.cgi"; my $__byj = $authlib9_15_4::_ako . "_path.cgi"; my $__byk = 0; my $__byl = 0; my $__bym = 0; my $__byn = ""; if (-e $__byg) { $__byn = $__byg; } elsif (-e $__byh) { $__byn = $__byh; } elsif (-e $__byi) { $__byn = $__byi; } elsif (-e $__byj) { $__byn = $__byj; $__byk = 1; } else { _zr(129, "Cannot find the study name.", "Can't find file " . $authlib9_15_4::_ako . "_path.cgi.", "", 1); } ($__byl, $__bym) = authlib9_15_4::_yg($__byn, "read", 1, 1); $__byf = <$__byl>; $__byf = _zp($__byf); if ($__byk) { $authlib9_15_4::_aib{'_amt'} = $__byf; } else { $authlib9_15_4::_aib{'_amt'} = _zo($__byp, $__byf); } $authlib9_15_4::_aib{'_amt'} = _zx($authlib9_15_4::_aib{'_amt'}, 0); $authlib9_15_4::_aib{'_amz'} = $__byf; if (! -e $authlib9_15_4::_aib{'_amt'}) { _zr(130, "Directory does not exist.", "The directory: " . $authlib9_15_4::_aib{'_amt'} . " does not exist. Check your study paths under Advanced Settings.", ""); } $__byf = <$__byl>; $__byf = _zp($__byf); if ($__byk) { $authlib9_15_4::_aib{'_ana'} = $__byf; } else { $authlib9_15_4::_aib{'_ana'} = _zo($__byp, $__byf); } my $__byo = $__byf; if ($__byo =~ m/^@(.*?)$/) { $__byo = $1; } else { $__byo = _zn($__byo); } $authlib9_15_4::_aib{'_ur'} = $__byo; close $__byl; } sub _zn { my ($__byr) = @_; my $__byq = ""; $__byq = $ENV{'SCRIPT_NAME'}; $__byq =~ s/\/ciwweb\.pl//; $__byq =~ s/\/admin\.pl//; $__byq =~ s/\/testmode\.pl//; $__byq = _zx(_zo($__byq, $__byr), 0); return $__byq; } sub _zo { my ($__byt, $__byu) = @_; my $__bys = ""; if ($__byu =~ m/https?:\/\//i) { $__bys = $__byu; } else { $__byt = reverse($__byt); while ($__byu =~ m/^\.\.\//) { $__byu =~ s/^\.\.\///; $__byt =~ s/^.*?\///; } $__byt = reverse($__byt); $__bys = $__byt . "/" . $__byu; } return $__bys; } sub _zp { my ($__byv) = @_; if (length($__byv)) { $__byv =~ s/^\s+//; $__byv =~ s/\s+$//; } return $__byv; } sub _zq { my ($__bzf, $__bzg) = @_; if ($authlib9_15_4::_amo) { return; } my $__byw = $authlib9_15_4::_aku->{"qst_version"}; my $__byx = ""; if (exists $authlib9_15_4::_akx->{'_gh'}) { $__byx = _aad(); } my $__byy = ""; if (exists $authlib9_15_4::_akx->{'_pr'}) { $__byy = _aac(); } my $__byz = time(); my $__bza = $authlib9_15_4::_akv{"hid_respnum"}; my $__bzb = ""; my $__bzc = ""; while (my ($__bzh, $__bzi) = each %authlib9_15_4::_akv) { $__bzb .= $__bzc; $__bzb .= $__bzh . "=>" . $__bzi; $__bzc = ", "; } my $__bzd = "INSERT INTO `" . $authlib9_15_4::_akq . "_design_log` (`sys_RespNum`,`ipaddress`,`user_agent`,`timestamp`,`qst_version`,`exercisename`,`input`,`message`) VALUES(?, ?, ?, ?, ?, ?, ?, ?)"; eval { my $__bze = $authlib9_15_4::_akl->prepare(_wn($__bzd, 0)); $__bze->execute($__bza, $__byx, _wh($__byy), $__byz, $__byw, $__bzf, _wh($__bzb), _wh($__bzg)); }; if ($@) { _zr(296, "Database error.", "Database error. Cannot insert design log row.", $@); } } sub _zr { my ($__bzj, $__bzk, $__bzl, $__bzm, $__bzn, $__bzo) = @_; if ($__bzk eq "") { $__bzk = $__bzl; } if (!$__bzn) { _aci(&authlib9_15_4::_APA, $__bzj, $__bzl, $__bzm, $__bzo); } if ($authlib9_15_4::_ajb) { if ($__bzm ne "") { $__bzm = ": " . $__bzm; } eval { require "Carp.pm"; Carp::confess("Error: " . $__bzl . $__bzm . " Error"); }; if ($@) { _aci(&authlib9_15_4::_APA, 0, "Cannot load Carp.pm.", $@); } } else { if ($authlib9_15_4::_akf) { print authlib9_15_4::_zb(1); print "{"; print "\"result\": false,"; print "\"error\": \"Error #" . $__bzj . " - " . _zs($__bzk) . "\""; print "}"; } else { if (!$authlib9_15_4::_alk) { print authlib9_15_4::_zb(1); } if (!$ciwlib9_15_4::_uc) { print authlib9_15_4::_yi(0) . "\n<body>\n"; } print "<div style=\"border: 1px solid black; background-color: white; color: black; font-family: arial; padding: 5px;"; print " width: 800px; margin-left: auto; margin-right: auto; padding: 5px;\">\n"; print "<div style=\"color: red; text-decoration: underline; font-weight: bold;\">Sawtooth Error"; if ($__bzj) { print " # " . $__bzj; } print "</div><div><p>" . $__bzk . "</p></div>"; print "<div style=\"margin-top: 30px;\">"; print "Please try to refresh your browser or try to backup and submit again. If the error continues please contact the survey administrator."; if ($__bzj == 129 || $__bzj == 102) { print " If you are starting the survey, please check the survey link and try again."; } print "</div></div>"; print _zv(); print "</body>\n</html>\n"; } authlib9_15_4::_acv(); } } sub _zs { my ($__bzp) = @_; $__bzp =~ s/(?<!\\)"/\\"/g; $__bzp =~ s/\n/ /g; return $__bzp; } sub _zt { my $__bzq = ""; my $__bzr = Symbol::gensym(); opendir($__bzr, "../admin/") || authlib9_15_4::_zr(314, "Cannot find default studyname.", "", "", 1); my @__bzs = readdir($__bzr); closedir $__bzr; my $__bzt = ""; foreach $__bzt(@__bzs) { if ($__bzt =~ m/(.*?)_config\.cgi/i) { $__bzq = $1; last; } } return $__bzq; } sub _zu { my ($__bzu) = @_; if (!$authlib9_15_4::_alk) { print authlib9_15_4::_zb(); } if (!$ciwlib9_15_4::_uc) { print authlib9_15_4::_yi(0) . "\n<body>\n"; } print "<div style=\"border: 2px solid orange; background-color: white; color: black; font-family: arial; padding: 5px;"; print " width: 800px; margin-left: auto; margin-right: auto; padding: 5px;\">\n"; print "<div style=\"color: blue; text-decoration: underline; font-weight: bold;\">Test Mode Error</div>"; print "<div><p>" . $__bzu . "</p></div>"; print "</div>"; print "</body>\n</html>\n"; authlib9_15_4::_acv(); } sub _zv { my $__bzv = ""; $__bzv .= "\n<style type=\"text/css\">\n"; $__bzv .= ".loading{display: none;}\n"; $__bzv .= ".stage{display: block;}\n"; $__bzv .= "</style>\n"; return $__bzv; } sub _zw { my ($__bzx, $__bzy) = @_; my $__bzw = ""; $__bzw .= "<div style=\"border: 1px solid black; background-color: white; font-family: arial;"; $__bzw .= " width: 800px; margin-left: auto; margin-right: auto; padding: 5px;\">\n"; $__bzw .= "<div style=\"color: red; text-decoration: underline; font-weight: bold;\">Sawtooth Error:</div>"; $__bzw .= "<div style=\"color: black; padding: 5px;\">" . $__bzx . "</div>"; $__bzw .= "<div style=\"color: blue; padding: 5px;\">" . $__bzy . "</div>"; $__bzw .= "</div>"; return $__bzw; } sub _zx { my ($__cab, $__cac) = @_; my $__bzz = ""; my $__caa = ""; while($__cab =~ m/\[%(.*?)%\]/sg) { $__bzz = $1; if ($__cac) { $__bzz =~ s/\\'/'/sg; $__bzz =~ s/\\\\/\\/sg; } $__caa = _zy($__bzz, "Lighthouse Studio Scripting"); $__caa =~ s/\[%(.*?)%\]/$1/sg; if ($__cac) { $__caa =~ s/\\/\\\\/sg; $__caa =~ s/'/\\'/sg; } $__cab =~ s/\[%(.*?)%\]/$__caa/s; } return nonceinserter9_15_4::_bvq($__cab); } sub _zy { my ($__cae, $__caf) = @_; my $__cad = ""; $__cad = eval($__cae); if ($authlib9_15_4::_amo && ($__cad eq "" || $@)) { $__cad = "<span class=script_preview>[Script]</span>"; } elsif ($@) { authlib9_15_4::_zr(132, "Script error.", "There is an error in " . $__caf . ": Script:" . $__cae, $@); } else { return $__cad; } } sub NONCE { return nonceinserter9_15_4::_bvr(); } sub RADIOSELECT { my ($__cag, $__cah) = @_; return ciwlib9_15_4::_tm($__cag, $__cah, 1, 0); } sub CHECKSELECT { my ($__cai, $__caj) = @_; return ciwlib9_15_4::_tm($__cai . "_" . $__caj, 1, 0, 0); } sub REMOVEPREVIOUS { my $__cak = ""; $__cak .= "<style type=\"text/css\">#previous_button{display: none;}</style>"; return $__cak; } sub PAGETIME { my ($__cax, $__cay) = @_; my $__cal = 0; my $__cam = 0; my $__can = ""; my @__cao = (); my $__cap = ciwlib9_15_4::_rj(); my $__caq = (); if ($__cay eq "") { $__cay = $__cax; } if ($__cax =~ m/^\d+$/ && $__cay =~ m/^\d+$/) { my $__car = 0; my $__cas = (); my $__cat = ""; for ($__car = $__cax; $__car <= $__cay; $__car++) { $__cas = _zz("sys_pagetime_" . $__car); @__cao = keys %{ $__cas }; foreach my $__cau (@__cao) { my @__cav = @{ $__cas->{$__cau} }; $__can = "SELECT " . join(",", @__cav) . " FROM `" . $authlib9_15_4::_akq . "_data" . $__cau . "` WHERE `sys_RespNum` = " . $__cap; eval { $__caq = $authlib9_15_4::_akl->selectrow_arrayref(authlib9_15_4::_wn($__can, 0)); }; foreach my $__caw (@{ $__caq }) { $__cal += $__caw; } } } } return $__cal; } sub _zz { my ($__cbd) = @_; my $__caz = ""; my $__cba = 0; my $__cbb = ""; my $__cbc = (); if (_xl($__cbd)) { $__caz = "SELECT `name`, `table` FROM `" . $authlib9_15_4::_akq . "_map` WHERE `name` LIKE '" . $__cbd . ".%'"; } else { $__caz = "SELECT `name`, `table` FROM `" . $authlib9_15_4::_akq . "_map` WHERE `name` = '" . $__cbd . "'"; } eval { $__cba = $authlib9_15_4::_akl->selectall_arrayref(authlib9_15_4::_wn($__caz, 0)); }; if ($@) { authlib9_15_4::_zr(266, "Database error.", "Database error. Cannot select map row.", $@); } foreach $__cbb (@{$__cba}) { if (!exists $__cbc->{$__cbb->[1]}) { $__cbc->{$__cbb->[1]} = (); } push @{ $__cbc->{$__cbb->[1]} }, "`" . $__cbb->[0] . "`"; } return $__cbc; } sub BLOCKPOSITION { my $__cbe = $authlib9_15_4::_ahv{$authlib9_15_4::_ajq}; my $__cbf = $__cbe->{'_ji'}; my $__cbg = $authlib9_15_4::_akw->[$__cbf - 1]; my $__cbh = ""; if (exists $__cbg->{'_ba'}) { my $__cbi = $__cbg->{'_ba'}; my @__cbj = @{ciwlib9_15_4::_rf(ciwlib9_15_4::_rj(), $__cbf)}; my @__cbk = @{ciwlib9_15_4::_qw($__cbi->{'_nj'})}; for (my $__cbl = 0; $__cbl < @__cbj; $__cbl++) { my $__cbm = $__cbk[$__cbj[$__cbl] - 1]; if ($__cbm->[0] <= $__cbf && $__cbm->[1] >= $__cbf) { $__cbh = $__cbl + 1; last; } } } return $__cbh; } sub VALUE { my ($__cbn) = @_; return _ws($__cbn); } sub LABEL { my ($__cbr) = @_; my $__cbo = ""; my $__cbp = ""; my $__cbq = 0; $__cbo = _zp(authlib9_15_4::_ws($__cbr)); if ($__cbo ne "") { ($__cbp, $__cbq) = _abv($__cbr, 1, $__cbo, 0); $__cbp = _zx($__cbp, 0); } return $__cbp; } sub JAVASCRIPT { my $__cbs = 0; if (exists $authlib9_15_4::_akv{"hid_javascript"} && defined $authlib9_15_4::_akv{"hid_javascript"}) { if ($authlib9_15_4::_akv{"hid_javascript"} == 1) { $__cbs = 1; } else { $__cbs = 0; } } return $__cbs; } sub BROWSER { return _aaa(); } sub _aaa { my $__cbt = ""; if (exists($ENV{'HTTP_USER_AGENT'})) { my $__cbu = $ENV{'HTTP_USER_AGENT'}; my $__cbv = SSIWebParseBrowser->new($__cbu); if (exists($__cbv->{"name"})) { $__cbt .= $__cbv->{"name"}; if (exists($__cbv->{"version"})) { $__cbt .= " " . $__cbv->{"version"}->{"v"}; } } } return $__cbt; } sub OPERATINGSYSTEM { return _aab(); } sub _aab { my $__cbw = ""; if (exists($ENV{'HTTP_USER_AGENT'})) { my $__cbx = $ENV{'HTTP_USER_AGENT'}; my $__cby = SSIWebParseBrowser->new($__cbx); if (exists($__cby->{"os"})) { $__cbw = $__cby->{"os"} . " " . $__cby->{"osvers"}; } } return $__cbw; } sub USERAGENT { return _aac(); } sub _aac { my $__cbz = ""; if (exists($ENV{'HTTP_USER_AGENT'})) { $__cbz = $ENV{'HTTP_USER_AGENT'}; } return $__cbz; } sub IPADDRESS { return _aad(); } sub _aad { my $__cca = ""; my @__ccb = qw(HTTP_X_FORWARDED_FOR HTTP_FORWARDED_FOR HTTP_CLIENT_IP HTTP_X_REAL_IP REMOTE_ADDR); foreach my $__ccc (@__ccb) { if (exists $ENV{$__ccc}) { $__cca = $ENV{$__ccc}; } if ($__cca) { last; } } my $__ccd = index($__cca, ","); if ($__ccd != -1) { $__cca = substr($__cca, 0, $__ccd); } return (defined $__cca) ? $__cca : ""; } sub STUDYNAME { my $__cce = $authlib9_15_4::_ako; if ($authlib9_15_4::_amo) { $__cce = ""; } return $__cce; } sub PAGENUMBER { return _aae(); } sub _aae { my $__ccf = ""; if ((exists $authlib9_15_4::_akv{"hid_pagenum"}) && (defined $authlib9_15_4::_akv{"hid_pagenum"})) { $__ccf = $authlib9_15_4::_akv{"hid_pagenum"}; } return $__ccf; } sub TOTALPAGES { my $__ccg = 0; $__ccg = @{$authlib9_15_4::_akw}; return $__ccg; } sub NUMCHECKED { my ($__cda) = @_; my ($__cdb, $__cdc, $__cdd) = _abu($__cda); if ($authlib9_15_4::_amo || !exists $authlib9_15_4::_ahv{$__cdb}) { return ""; } my $__cch = $authlib9_15_4::_ahv{$__cdb}; my $__cci = $__cch->{'_pj'}; my $__ccj = tell $authlib9_15_4::_ajs; my $__cck = $__cch->{'_iz'}; seek $authlib9_15_4::_ajs, $__cck, 0; my $__ccl = _zj(0); my $__ccm = 0; my $__ccn = 0; my $__cco = 0; my $__ccp = 0; my $__ccq = ""; if ($__cci == &authlib9_15_4::_ANO) { if ($__ccl->{'_pj'} eq "check") { my $__ccr = _ada($__ccl->{'_hj'}, $__cdd); if ($__ccr) { $__ccp = @{$__ccr}; for ($__ccm = 0; $__ccm < $__ccp; $__ccm++) { $__ccn = $__ccr->[$__ccm]->{'_pt'}; $__ccq = $__cdb . "_" . $__ccn . $__cdd; if (authlib9_15_4::_ws($__ccq) == 1) { $__cco++; } } } } } elsif ($__cci == &authlib9_15_4::_AOA) { my $__ccs = 0; my $__cct = 0; my $__ccu = 0; if ($__cdc =~ m/r(\d+)/i) { $__ccs = $1; $__ccu = authlib9_15_4::_ada($__ccl->{'_co'}, $__cdd); } elsif ($__cdc =~ m/c(\d+)/i) { $__cct = $1; $__ccu = authlib9_15_4::_ada($__ccl->{'_mw'}, $__cdd); } if ($__ccu) { $__ccp = @{$__ccu}; } for ($__ccm = 0; $__ccm < $__ccp; $__ccm++) { $__ccn = $__ccu->[$__ccm]->{'_pt'}; $__ccq = $__cdb . "_" . $__ccn; if ($__ccs > 0) { $__ccq = $__cdb . "_r" . $__ccs . "_c" . $__ccn; } elsif ($__cct > 0) { $__ccq = $__cdb . "_r" . $__ccn . "_c" . $__cct; } $__ccq .= $__cdd; if (authlib9_15_4::_ws($__ccq) == 1) { $__cco++; } } } elsif ($__cci == &authlib9_15_4::_ANZ) { my $__ccv = $__ccl->{'_pv'}; my $__ccw = 0; my $__ccx = ""; my $__ccy = 0; my $__ccz = 0; for ($__ccm = 0; $__ccm < @{$__ccv}; $__ccm++) { $__ccw = $__ccv->[$__ccm]; $__ccx = ref($__ccw); if ($__ccx eq "CheckVar") { if ($__ccw->{'_if'} eq $__cda) { $__ccz = $__ccw->{'_iy'}; for ($__ccy = 1; $__ccy <= $__ccz; $__ccy++) { $__ccq = $__cda . "_" . $__ccy . $__cdd; if (authlib9_15_4::_ws($__ccq) == 1) { $__cco++; } } last; } } } } seek $authlib9_15_4::_ajs, $__ccj, 0; return $__cco; } sub DISPLAYTOTAL { my ($__cdo, $__cdp, $__cdq) = @_; my $__cde = ""; my $__cdf = 0; my $__cdg = ""; my $__cdh = 1; my @__cdi = (); my %__cdj = (); my $__cdk = $authlib9_15_4::_akv{"hid_javascript"}; my $__cdl = 1; my $__cdm = 0; if ($__cdo =~ m/^(.*?)(_?)(\d+)$/) { $__cdg = $1 . $2; if ($2 eq "_") { $__cdl = 0; } $__cdh = $3; } if ($__cdp =~ m/^(.*?)(\d+)$/) { $__cdm = $2; } $__cdj{$__cdg . "*"} = 1; for ($__cdf = $__cdh; $__cdf <= $__cdm; $__cdf++) { push @__cdi, $__cdf; } my $__cdn = ""; if ($__cdl) { $__cdn = "_total_" . $authlib9_15_4::_ajd; } else { $__cdn = "total_" . $authlib9_15_4::_ajd; } $__cde .= ciwlib9_15_4::_sk($__cdg . $__cdn, $__cdq); if (!$authlib9_15_4::_amo) { $__cde .= ciwlib9_15_4::_si($__cdo . "_" . $authlib9_15_4::_ajd, \@__cdi, \%__cdj, $__cdn); } $authlib9_15_4::_ajd++; return $__cde; } sub QUESTIONNAME { return $authlib9_15_4::_ajq; } sub GRAPHICSPATH { return $authlib9_15_4::_aib{'_ur'}; } sub PROGRESSBAR { my $__cdr = $authlib9_15_4::_akx->{'_kr'}; return ciwlib9_15_4::_te($__cdr); } sub PROGRESSBAROFF { $authlib9_15_4::_alm = 1; return ""; } sub PROGRESSBARSET { my ($__cds) = @_; $authlib9_15_4::_aln = $__cds; return ""; } sub RANDNUM { my ($__cdz, $__cea, $__ceb) = @_; my $__cdt = @_; my $__cdu = 0; my $__cdv = ""; my $__cdw = ""; my $__cdx = ""; if ($__cdt == 1) { $__cdu = $__cdz; } elsif ($__cdt == 3) { $__cdu = $__cdz; $__cdv = $__cea; $__cdw = $__ceb; } if (exists($authlib9_15_4::_akv{"hid_respnum"}) && defined($authlib9_15_4::_akv{"hid_respnum"})) { $__cdu = $authlib9_15_4::_akv{"hid_respnum"} + int($__cdu); if ($__cdt == 1) { $__cdx = _acq($__cdu); } elsif ($__cdv < $__cdw) { my $__cdy = $__cdw - $__cdv; _acq($__cdu); $__cdx = (int rand($__cdy + 1)); $__cdx = $__cdx + $__cdv; } } return $__cdx; } sub SYSRAND { my ($__cei, $__cej) = @_; my $__cec = @_; $authlib9_15_4::_ajd++; my $__ced = time() + $authlib9_15_4::_ajd; my $__cee = ""; my $__cef = ""; my $__ceg = ""; if ($__cec == 2) { $__cee = $__cei; $__cef = $__cej; } if ($__cec == 0) { $__ceg = _acq($__ced); } elsif ($__cee < $__cef) { my $__ceh = $__cef - $__cee; _acq($__ced); $__ceg = (int rand($__ceh + 1)); $__ceg = $__ceg + $__cee; } return $__ceg; } sub RESPNUM { return $authlib9_15_4::_akv{"hid_respnum"}; } sub LINKBUTTON { my ($__cem) = @_; my $__cek = ""; if (exists $authlib9_15_4::_akx->{'_anb'}) { my $__cel = authlib9_15_4::_zx($authlib9_15_4::_akx->{'_anb'}, 0); $__cek = "<a href=\"" . $__cem . "\">" . $__cel . "</a>\n"; } else { $__cek = "<input id=\"ssi-link-button\" type=\"button\" value=\"" . authlib9_15_4::_zx($authlib9_15_4::_akx->{'_ik'}, 0) . ">\n"; $__cek .= jshelpers9_15_4::_bvk("ssi-link-button", "()=>{\n" . "window.location.href='" . $__cem . "'\n" . "}"); } return $__cek; } sub POPUP { my ($__ceo, $__cep, $__ceq, $__cer) = @_; my $__cen = ""; if ($__cep !~ m/https?:\/\//) { $__cep = $authlib9_15_4::_aib{'_ur'} . $__cep; } $__cen = "<a href=\"#\" id=\"ssi-popup-link\" class=\"popup_link\">" . $__ceo . "</a>\n"; $__cen .= authlib9_15_4::_xh( jshelpers9_15_4::_bvk("ssi-popup-link", "() => {\n" . "window.open('" . $__cep . "', '','resizable=yes,scrollbars=yes,width=" . $__ceq . ",height=" . $__cer . "'); return false;\n}") ); return $__cen; } sub TOOLTIP { my ($__cet, $__ceu, $__cev, $__cew) = @_; my $__ces = ""; $__ces .= "<span class=\"tool_tip_link\">" . $__cet . "</span>"; $__ces .= "<span class=\"tool_tip_text\""; if ($__cev || $__cew) { $__ces .= " style=\""; if ($__cev) { $__ces .= "max-width: none;"; $__ces .= "width:" . $__cev . "px;"; } if ($__cew) { $__ces .= "height:" . $__cew . "px;"; } $__ces .= "\""; } $__ces .= ">"; $__ces .= $__ceu; $__ces .= "</span>"; return $__ces; } sub DEBUG { my $__cex = ""; my $__cey = ciwlib9_15_4::_rj(); if ($__cey) { my $__cez = 0; my $__cfa = ""; my $__cfb = $authlib9_15_4::_aku->{"num_data_tables"}; my $__cfc = 0; my $__cfd = ""; my $__cfe = 0; my $__cff = 0; my $__cfg = ""; my $__cfh = ""; my $__cfi = 0; my $__cfj = ""; my %__cfk = (); my @__cfl = (); my $__cfm = 0; for ($__cfc = 1; $__cfc <= $__cfb; $__cfc++) { ($__cfd, $__cfe, $__cff, $__cfg, $__cfh) = authlib9_15_4::_wm($authlib9_15_4::_akq . "_data" . $__cfc); eval { $__cfm = $authlib9_15_4::_akl->selectall_arrayref(authlib9_15_4::_wn($__cfd, 0)); }; if ($@) { authlib9_15_4::_zr(212, "Database error.", "Database error. Cannot get table description.", $@); } $__cfd = "SELECT * FROM `" . $authlib9_15_4::_akq . "_data" . $__cfc . "` WHERE `sys_RespNum` = " . $__cey; $__cfi = 0; $__cfj = ""; eval { $__cfi = $authlib9_15_4::_akl->selectrow_arrayref(authlib9_15_4::_wn($__cfd, 0)); }; if ($@ || $__cfi == 0) { authlib9_15_4::_zr(268, "Database error.", "Database error. Cannot get data for DEBUG.", $@); } else { my $__cfn = 0; foreach my $__cfo (@{$__cfm}) { $__cfj = $__cfo->[$__cfe]; if ($__cfi->[$__cfn]) { $__cfk{$__cfj} = $__cfi->[$__cfn]; push @__cfl, $__cfj; } $__cfn++; } } } $__cex .= "<div class=\"debug_box\">"; $__cex .= "<table border=\"1\" cellpadding=\"5\" cellspacing=\"0\">"; $__cex .= "<tr class=\"debug_header\"><td align=\"center\" colspan=\"2\">"; $__cex .= "<h1>Lighthouse Studio DEBUGGER</h1>"; $__cex .= "</td></tr>"; $__cex .= "<tr class=\"debug_section\">"; $__cex .= "<td><b>Question Name</b></td>"; $__cex .= "<td><b>Value</b></td></tr>"; foreach $__cez (@__cfl) { if ($__cez =~ m/^sys_/i) { next; } $__cex .= "<tr><td align=\"right\"><b>" . $__cez . "</b></td><td align=\"left\">" . $__cfk{$__cez} . "</td></tr>"; } $__cex .= "<tr class=\"debug_section\">"; $__cex .= "<td><b>Constructed List</b></td>"; $__cex .= "<td><b>Value</b></td></tr>"; $__cfd = "SELECT * FROM `" . $authlib9_15_4::_akq . "_clists` WHERE `sys_RespNum` = " . $__cey; $__cfi = 0; $__cfj = ""; eval { $__cfi = $authlib9_15_4::_akl->selectall_arrayref(authlib9_15_4::_wn($__cfd, 0)); }; if ($@ || $__cfi == 0) { authlib9_15_4::_zr(268, "Database error.", "Database error. Cannot get data for DEBUG.", $@); } else { foreach my $__cfp (@{$__cfi}) { $__cex .= "<tr><td align=\"right\"><b>" . $__cfp->[1] . "</b></td><td align=\"left\">" . $__cfp->[2] . "</td></tr>"; } } $__cex .= "<tr class=\"debug_section\"><td colspan=\"2\" align=\"left\">"; $__cex .= "<b>Internal Page Variables</b>"; $__cex .= "</td></tr>"; foreach $__cez (sort keys %authlib9_15_4::_akv) { if ($__cez =~ m/hid_/) { $__cfa = _zp($authlib9_15_4::_akv{$__cez}); if ($__cez eq "hid_pagenum") { if (exists $authlib9_15_4::_akv{"hid_pagenum"}) { $__cfa = $authlib9_15_4::_akv{"hid_pagenum"}; } } if ($__cfa eq "") { $__cfa = "&nbsp;"; } $__cex .= "<tr><td align=\"right\"><b>" . $__cez . "</b></td><td align=\"left\">" . $__cfa . "</td></tr>"; } } $__cex .= "<tr class=\"debug_section\"><td colspan=\"2\" align=\"left\">"; $__cex .= "<b>Internal System Variables</b>"; $__cex .= "</td></tr>"; foreach $__cez (sort keys %__cfk) { if ($__cez =~ m/^sys_/i) { $__cex .= "<tr><td align=\"right\"><b>" . $__cez . "</b></td><td align=\"left\">" . $__cfk{$__cez} . "</td></tr>"; } } $__cex .= "</table></div>"; } return $__cex; } sub STRINGTONUMBER { my ($__cfq) = @_; $__cfq =~ s/^\s*0+(.+?)$/$1/; return $__cfq; } sub NUMBERTOSTRING { my ($__cfr) = @_; return $__cfr; } sub BOOLEANTONUMBER { my ($__cfs) = @_; return $__cfs; } sub NUMBERTOBOOLEAN { my ($__cft) = @_; return $__cft; } sub LISTLENGTH { my ($__cfu) = @_; return _aaf($__cfu); } sub _aaf { my ($__cfx) = @_; my $__cfv = _ada($__cfx); my $__cfw = 0; if ($__cfv) { $__cfw = @{$__cfv}; } return $__cfw; } sub LISTHASPARENTMEMBER { my ($__cgc, $__cgd) = @_; my $__cfy = _ada($__cgc); my $__cfz = 0; if ($__cfy) { $__cfz = @{$__cfy}; } my $__cga = 0; my $__cgb = 0; for ($__cga = 0 ; $__cga < $__cfz; $__cga++) { if ($__cfy->[$__cga]->{'_pt'} == $__cgd) { $__cgb = 1; last; } } return $__cgb; } sub LISTLABEL { my ($__cgg, $__cgh) = @_; my $__cge = ""; my $__cgf = _ada($__cgg); if (($__cgh > 0) && $__cgf && ($__cgh <= @{$__cgf})) { $__cge = $__cgf->[$__cgh - 1]->{'_op'}; $__cge = _zx($__cge, 0); } return $__cge; } sub LISTVALUE { my ($__cgk, $__cgl) = @_; my $__cgi = ""; my $__cgj = _ada($__cgk); if (($__cgl > 0) && $__cgj && ($__cgl <= @{$__cgj})) { $__cgi = $__cgj->[$__cgl - 1]->{'_pt'}; } return $__cgi; } sub LISTVALUESARRAY { my ($__cgo) = @_; my $__cgm = ""; my $__cgn = _ada($__cgo); if ($__cgn) { $__cgm = "[" . join(",", map{$_->{'_pt'}} @{$__cgn}) . "]"; } return $__cgm; } sub LISTLABELSARRAY { my ($__cgr) = @_; my $__cgp = ""; my $__cgq = _ada($__cgr); if ($__cgq) { $__cgp = "[" . join(",", map{"'" . _aag($_) . "'"} @{$__cgq}) . "]"; } return $__cgp; } sub _aag { my ($__cgt) = @_; my $__cgs = $__cgt->{'_op'}; $__cgs =~ s/\\/\\\\/sg; $__cgs =~ s/'/\\'/sg; $__cgs = _zx($__cgs, 0); return $__cgs; } sub FORMATLISTLABELS { my ($__cgy, $__cgz, $__cha) = @_; my $__cgu = 0; my $__cgv = ""; my $__cgw = ""; my $__cgx = _ada($__cgy); if ($__cgx) { foreach $__cgu (@{$__cgx}) { $__cgv = $__cgu->{'_op'}; $__cgw .= $__cgz . $__cgv . $__cha; } } return $__cgw; } sub DISPLAYLISTLABELS { my ($__chg, $__chh, $__chi) = @_; my $__chb = ""; my $__chc = ""; my $__chd = _ada($__chg); if ($__chd) { my $__che = @{$__chd}; my $__chf = 0; for ($__chf = 0; $__chf < $__che; $__chf++) { $__chb = $__chd->[$__chf]->{'_op'}; $__chc .= $__chb; if ($__che > 2 && $__chf < $__che - 1) { $__chc .= $__chh . " "; } if ($__che > 1) { if ($__chf == $__che - 2) { $__chc .= " " . $__chi . " "; } } } } return $__chc; } sub WRITELOG { my ($__chj, $__chk) = @_; if (!$__chk) { $__chk = &authlib9_15_4::_APC; } _aci($__chk, 0, $__chj); return ""; } sub ERRFIELD { return "[\0ERRFIELD()\0]"; } sub ERRQNAME { return "[\0ERRQNAME()\0]"; } sub ERRTEXT { return "[\0ERRTEXT()\0]"; } sub ERRMIN { return "[\0ERRMIN()\0]"; } sub ERRMAX { return "[\0ERRMAX()\0]"; } sub ERRTOTAL { return "[\0ERRTOTAL()\0]"; } sub ERRCURSUM { return "[\0ERRCURSUM()\0]"; } sub ACAATTRIBUTE { return "[\0ACAATTRIBUTE()\0]"; } sub ACABEST { return "[\0ACABEST()\0]"; } sub ACAWORST { return "[\0ACAWORST()\0]"; } sub ACAIMPORTANCE { my ($__chm, $__chn) = @_; my $__chl = _za($__chm, 1); return _aah($__chl, $__chn); } sub _aah { my ($__cho, $__chp) = @_; return acalib9_15_4::_aso($__cho, $__chp, 0); } sub ACASAVECUSTOMACAIMP { my ($__chr) = @_; if (!$authlib9_15_4::_amo) { my $__chq = _za($__chr, 1); acalib9_15_4::_ast($__chq, $__chr); } return ""; } sub ACAUTILITY { my ($__cht, $__chu, $__chv) = @_; my $__chs = _za($__cht, 1); return _aai($__chs, $__chu, $__chv); } sub _aai { my ($__chx, $__chy, $__chz) = @_; my $__chw = ""; eval { $__chw = acalib9_15_4::_aso($__chx, $__chy, $__chz); }; if ($@ || ($__chz <= 0)) { $__chw = ""; } return $__chw; } sub ACAPRIORSBESTLEVELLABEL { my ($__cid, $__cie) = @_; my $__cia = _za($__cid, 1); my $__cib = _aaj($__cia, $__cid, $__cie, 1); my $__cic = $__cia->{'_ae'}; return $__cic->[$__cie - 1]->{'_hf'}->[$__cib - 1]; } sub ACAPRIORSBESTLEVELVALUE { my ($__cih, $__cii) = @_; my $__cif = _za($__cih, 1); my $__cig = _aaj($__cif, $__cih, $__cii, 1); return $__cig; } sub ACAPRIORSWORSTLEVELLABEL { my ($__cim, $__cin) = @_; my $__cij = _za($__cim, 1); my $__cik = _aaj($__cij, $__cim, $__cin, 0); my $__cil = $__cij->{'_ae'}; return $__cil->[$__cin - 1]->{'_hf'}->[$__cik - 1]; } sub ACAPRIORSWORSTLEVELVALUE { my ($__ciq, $__cir) = @_; my $__cio = _za($__ciq, 1); my $__cip = _aaj($__cio, $__ciq, $__cir, 0); return $__cip; } sub _aaj { my ($__ciw, $__cix, $__ciy, $__ciz) = @_; my $__cis = $__ciw->{'_ae'}; if ($__ciy > @{$__cis} || $__ciy <= 0) { die("The attribute " . $__ciy . " being used in Sawtooth Script does not match the number of attributes defined in this study"); } my $__cit = 0; my $__ciu = 0; my $__civ = 0; ($__ciu, $__civ) = acalib9_15_4::_ass($__cix, $__cis, $__ciy); if ($__ciz) { $__cit = $__ciu; } else { $__cit = $__civ; } return $__cit; } sub ACACALMIN { return "[\0ACACALMIN()\0]"; } sub ACACALMAX { return "[\0ACACALMAX()\0]"; } sub ACAMOSTIMPATTLABEL { my ($__cjd, $__cje) = @_; my $__cja = _za($__cjd, 1); my $__cjb = _aak($__cja, 0, $__cje); my $__cjc = $__cja->{'_ae'}; return $__cjc->[$__cjb - 1]->{'_if'}; } sub ACAMOSTIMPATTVALUE { my ($__cjg, $__cjh) = @_; my $__cjf = _za($__cjg, 1); return _aak($__cjf, 0, $__cjh); } sub ACALEASTIMPATTLABEL { my ($__cjl, $__cjm) = @_; my $__cji = _za($__cjl, 1); my $__cjj = _aak($__cji, 1, $__cjm); my $__cjk = $__cji->{'_ae'}; return $__cjk->[$__cjj - 1]->{'_if'}; } sub ACALEASTIMPATTVALUE { my ($__cjo, $__cjp) = @_; my $__cjn = _za($__cjo, 1); return _aak($__cjn, 1, $__cjp); } sub _aak { my ($__cjt, $__cju, $__cjv) = @_; if (authlib9_15_4::_zp($__cjv) eq "") { $__cjv = 1; } my $__cjq = @{$__cjt->{'_ae'}}; my $__cjr = 0; my @__cjs = () x $__cjq; for ($__cjr = 1; $__cjr <= $__cjq; $__cjr++) { $__cjs[$__cjr - 1] = [$__cjr, _aah($__cjt, $__cjr)]; } @__cjs = sort{$b->[1] <=> $a->[1]} @__cjs; if ($__cju) { @__cjs = reverse(@__cjs); } return $__cjs[$__cjv - 1]->[0]; } sub ACABESTLEVELLABEL { my ($__cjz, $__cka, $__ckb) = @_; my $__cjw = _za($__cjz, 1); my $__cjx = _aal($__cjw, $__cka, $__ckb, 1); my $__cjy = $__cjw->{'_ae'}; return $__cjy->[$__cka - 1]->{'_hf'}->[$__cjx - 1]; } sub ACABESTLEVELVALUE { my ($__ckd, $__cke, $__ckf) = @_; my $__ckc = _za($__ckd, 1); return _aal($__ckc, $__cke, $__ckf, 1); } sub ACAWORSTLEVELLABEL { my ($__ckj, $__ckk, $__ckl) = @_; my $__ckg = _za($__ckj, 1); my $__ckh = _aal($__ckg, $__ckk, $__ckl, 0); my $__cki = $__ckg->{'_ae'}; return $__cki->[$__ckk - 1]->{'_hf'}->[$__ckh - 1]; } sub ACAWORSTLEVELVALUE { my ($__ckn, $__cko, $__ckp) = @_; my $__ckm = _za($__ckn, 1); return _aal($__ckm, $__cko, $__ckp, 0); } sub _aal { my ($__cku, $__ckv, $__ckw, $__ckx) = @_; if (authlib9_15_4::_zp($__ckw) eq "") { $__ckw = 1; } my $__ckq = $__cku->{'_ae'}; my $__ckr = @{$__ckq->[$__ckv - 1]->{'_hf'}}; my $__cks = 0; my @__ckt = () x $__ckr; for ($__cks = 1; $__cks <= $__ckr; $__cks++) { $__ckt[$__cks - 1] = [$__cks, _aai($__cku, $__ckv, $__cks)]; } if ($__ckx) { @__ckt = sort{$b->[1] <=> $a->[1]} @__ckt; } else { @__ckt = sort{$a->[1] <=> $b->[1]} @__ckt; } return $__ckt[$__ckw - 1]->[0]; } sub ACASTRICTIMPORTANCE { my ($__cle, $__clf) = @_; my $__cky = _za($__cle, 1); my $__ckz = 0; my $__cla = @{$__cky->{'_ae'}}; my $__clb = 0; my $__clc = 0; my $__cld = 0; for ($__ckz = 1; $__ckz <= $__cla; $__ckz++) { $__clc = _aam($__cky, $__cle, $__ckz); if ($__ckz == $__clf) { $__clb = $__clc; } $__cld += $__clc; } return ($__clb / ($__cld * 100)); } sub _aam { my ($__cls, $__clt, $__clu) = @_; my $__clg = 0; my $__clh = 0; my $__cli = $__cls->{'_ae'}; ($__clg, $__clh) = acalib9_15_4::_ass($__clt, $__cli, $__clu); my $__clj = $__cli->[$__clu - 1]->{'_pj'}; if ($__clj == 0) { my $__clk = @{$__cli->[$__clu - 1]->{'_hf'}}; my $__cll = 0; my $__clm = 0; my $__cln = ciwlib9_15_4::GetPreviousACAData($__clt . "_Rating" . $__clu . "_" . $__clg); my $__clo = ciwlib9_15_4::GetPreviousACAData($__clt . "_Rating" . $__clu . "_" . $__clh); for ($__cll = 1; $__cll <= $__clk; $__cll++) { $__clm = ciwlib9_15_4::GetPreviousACAData($__clt . "_Rating" . $__clu . "_" . $__cll); if ($__clm == $__cln) { if (_aai($__cls, $__clu, $__cll) > _aai($__cls, $__clu, $__clg)) { $__clg = $__cll; } } if ($__clm == $__clo) { if (_aai($__cls, $__clu, $__cll) < _aai($__cls, $__clu, $__clh)) { $__clh = $__cll; } } } } my $__clp = _aai($__cls, $__clu, $__clg); my $__clq = _aai($__cls, $__clu, $__clh); my $__clr = $__clp - $__clq; if ($__clr < 0) { $__clr = 0; } return $__clr; } sub CVAVERSION { return "[\0CVAVERSION()\0]"; } sub ACBCPRICELEVELTEXT { return "[\0ACBCPRICELEVELTEXT()\0]"; } sub ACBCMUSTHAVETEXT { return "[\0ACBCMUSTHAVETEXT()\0]"; } sub ACBCMUSTHAVERULES { return "[\0ACBCMUSTHAVERULES()\0]"; } sub ACBCUNACCEPTABLETEXT { return "[\0ACBCUNACCEPTABLETEXT()\0]"; } sub ACBCUNACCEPTABLERULES { return "[\0ACBCUNACCEPTABLERULES()\0]"; } sub ACBCNUMSCREENEDINCONCEPTS { my ($__clx) = @_; my $__clv = _aap($__clx); my $__clw = acbclib9_15_4::_bjf($__clv, $__clx); return @{$__clw}; } sub ACBCNUMSCREENERS { my ($__cma) = @_; if ($__cma) { my $__cly = 0; my $__clz = _aap($__cma); if (exists $__clz->{'_iv'}) { $__cly = $__clz->{'_iv'}; } return $__cly; } else { return "[\0ACBCNUMSCREENERS()\0]"; } } sub ACBCCURRENTSCREENER { my $__cmb = $authlib9_15_4::_ajq; my $__cmc = 0; if ($__cmb =~ m/_Screener(\d+)/i) { $__cmc = $1; } return $__cmc; } sub ACBCNUMCHOICETASKS { my ($__cmd) = @_; if ($__cmd) { return _aan($__cmd); } else { return "[\0ACBCNUMCHOICETASKS()\0]"; } } sub _aan { my ($__cmj) = @_; my $__cme = 0; my $__cmf = 0; my $__cmg = _aap($__cmj); my $__cmh = acbclib9_15_4::_bjf($__cmg, $__cmj); $__cmf = @{$__cmh}; if (exists $__cmg->{'_fx'}) { $__cmf++; } if (exists $__cmg->{'_hr'}) { my $__cmi = $__cmg->{'_hr'}; if ($__cmf > $__cmi) { $__cmf = $__cmi; } if ($__cmf) { $__cme = acbclib9_15_4::_bih($__cmf, $__cmg); } } return $__cme; } sub ACBCCURRENTCHOICETASK { my $__cmk = $authlib9_15_4::_ajq; my $__cml = 0; if ($__cmk =~ m/_ChoiceTask(\d+)/i) { $__cml = $1; } return $__cml; } sub ACBCNUMCALIBRATIONS { my ($__cmo) = @_; if ($__cmo) { my $__cmm = _aap($__cmo); my $__cmn = acbclib9_15_4::_bjg($__cmm, $__cmo); my ($__cmp, $__cmq, $__cmr) = acbclib9_15_4::_bjc($__cmm, $__cmo); return acbclib9_15_4::_big($__cmp, $__cmn, $__cmq, $__cmr, $__cmm); } else { return "[\0ACBCNUMCALIBRATIONS()\0]"; } } sub ACBCCURRENTCALIBRATION { my $__cms = $authlib9_15_4::_ajq; my $__cmt = 0; if ($__cms =~ m/_Calibration(\d+)/i) { $__cmt = $1; } return $__cmt; } sub ACBCCALIBRATIONTEXT { return "[\0ACBCCALIBRATIONTEXT()\0]"; } sub ACBCISMUSTHAVE { my ($__cnc, $__cnd, $__cne) = @_; my $__cmu = 0; my ($__cnf, $__cng) = _aao($__cnc, $__cnd); if (exists $__cnf->{$__cnd}) { my $__cmv = $__cnf->{$__cnd}; if (exists $__cmv->{'_anc'}) { my $__cmw = $__cmv->{'_anc'}; my $__cmx = $__cmv->{'_kb'}; my $__cmy = @{$__cmw}; my $__cmz = 0; if ($__cmw->[$__cne - 1] == 1) { $__cmu = 0; } else { my $__cna = 0; if ($__cmx == 1) { for ($__cmz = 0; $__cmz < $__cmy; $__cmz++) { if ($__cmz == 0 && $__cmw->[$__cmz] == 0) { last; } else { if ($__cmw->[$__cmz] == 0) { $__cna = $__cmz + 1; last; } } } } elsif ($__cmx == 2) { for ($__cmz = $__cmy - 1; $__cmz >= 0; $__cmz--) { if ($__cmz == ($__cmy - 1) && $__cmw->[$__cmz] == 0) { last; } else { if ($__cmw->[$__cmz] == 0) { $__cna = $__cmz + 1; last; } } } } else { my $__cnb = 0; for ($__cmz = 0; $__cmz < $__cmy; $__cmz++) { if ($__cmw->[$__cmz] == 0) { $__cnb++; } } if ($__cnb == 1) { $__cna = $__cne; } } if ($__cna == $__cne) { $__cmu = 1; } } } } return $__cmu; } sub ACBCISUNACCEPTABLE { my ($__cnk, $__cnl, $__cnm) = @_; my $__cnh = 0; my ($__cnn, $__cno) = _aao($__cnk, $__cnl); if (exists $__cnn->{$__cnl}) { my $__cni = $__cnn->{$__cnl}; if (exists $__cni->{'_anc'}) { my $__cnj = $__cni->{'_anc'}; if ($__cnj->[$__cnm - 1] == 1) { $__cnh = 1; } } } else { if ($__cno) { if ($__cnm > $__cno) { $__cnh = 1; } } } return $__cnh; } sub _aao { my ($__cny, $__cnz) = @_; my $__cnp = _aap($__cny); my $__cnq = acbclib9_15_4::_bkl($__cnp, $__cnz); my $__cnr = {}; my $__cns = {}; my ($__coa, $__cob) = acbclib9_15_4::_bip($__cny, 0, $__cnp); acbclib9_15_4::_bil($__coa, $__cnq, $__cnr, $__cns); my ($__coc, $__cnr) = acbclib9_15_4::_biq($__cny, 0, $__cnp, $__cnr, $__cns); my $__cnt = 0; my $__cnu = 0; my $__cnv = 0; my $__cnw = 0; my $__cnx = 0; foreach $__cnt (@{$__coa}) { $__cnu = $__cnt->[0]; $__cnv = $__cnt->[1]; $__cnw = $__cnt->[2]; if ($__cnz == $__cnu) { acbclib9_15_4::_bkm(24, $__cnq, $__cnu, $__cnv, $__cnw); } } foreach $__cnt (@{$__coc}) { $__cnu = $__cnt->[0]; $__cnv = $__cnt->[1]; $__cnw = $__cnt->[2]; if ($__cnz == $__cnu) { if (exists $__cnq->{$__cnz}) { acbclib9_15_4::_bkm(25, $__cnq, $__cnu, $__cnv, $__cnw); } else { $__cnx = $__cnv; } } } return ($__cnq, $__cnx); } sub _aap { my ($__cof) = @_; my $__cod = $__cof; if ($__cod =~ m/(.*?)_/i) { $__cod = $1; } authlib9_15_4::_yh("acbclib9_15_4.pl"); acbclib9_15_4::_bht($__cod); my $__coe = $acbclib9_15_4::_blg->{$__cod}; return $__coe; } sub _aaq { my ($__col, $__com) = @_; my @__cog = (); my $__coh = 0; my $__coi = 0; my $__coj = 0; my $__cok = 0; foreach $__coh (@{$__com}) { $__cok = 0; foreach $__coi (@{$__coh}) { foreach $__coj (@{$__col}) { if ($__coi->[0] == $__coj) { $__cok = 1; last; } } if ($__cok) { last; } } if (!$__cok) { push @__cog, $__coh; } } return \@__cog; } sub BYOCONDTEXT { my ($__cou, $__cov, $__cow, $__cox) = @_; my $__con = _aap($__cou); my $__coo = ""; if (exists $__con->{'_dd'}) { my $__cop = $__con->{'_dd'}->{'_md'}; my $__coq = @{$__cop}; if ($__cov <= $__coq) { my $__cor = $__cop->[$__cov - 1]; if (exists $__cor->{'_bn'}) { my $__cos = $__cor->{'_bn'}; my $__cot = ""; if ($__cow || $__cox) { $__cot .= " position:fixed;"; if ($__cow) { $__cot .= " left: " . $__cow . "px;"; } if ($__cox) { $__cot .= " top: " . $__cox . "px;"; } } $__coo = acbclib9_15_4::_bhw($__cou . "_BYO", $__cos, $__cov, $__cot, 1); } } } return $__coo; } sub ACBCBYOLABEL { my ($__coz, $__cpa) = @_; my $__coy = _aar($__coz, $__cpa); my ($__cpb, $__cpc) = _aat($__coz, $__cpa, $__coy, 0); if ($__cpc) { $__cpc = _zx($__cpc, 0); } return $__cpc; } sub ACBCBYOVALUE { my ($__cpd, $__cpe) = @_; return _aar($__cpd, $__cpe); } sub _aar { my ($__cph, $__cpi) = @_; my $__cpf = $__cph . "_BYO_" . $__cpi; my $__cpg = ""; $__cpg = _zp(authlib9_15_4::_ws($__cpf)); return $__cpg; } sub ACBCWINNERLABEL { my ($__cpk, $__cpl) = @_; my $__cpj = _aas($__cpk, $__cpl); if ($__cpj eq "" || $__cpj == 0) { return ""; } my ($__cpm, $__cpn) = _aat($__cpk, $__cpl, $__cpj, 0); if ($__cpn) { $__cpn = _zx($__cpn, 0); } return $__cpn; } sub ACBCWINNERVALUE { my ($__cpo, $__cpp) = @_; return _aas($__cpo, $__cpp); } sub _aas { my ($__cpx, $__cpy) = @_; my $__cpq = 0; my $__cpr = authlib9_15_4::_aap($__cpx); my ($__cpz, $__cqa, $__cqb) = acbclib9_15_4::_bjc($__cpr, $__cpx); if ($__cpz == -1) { return ""; } my $__cps = acbclib9_15_4::_biu([$__cpz], $__cpx, $__cpr); my $__cpt = acbclib9_15_4::_bit($__cpx, $__cpr); my $__cpu = 0; my $__cpv = @{$__cpt}; my $__cpw = 0; for ($__cpu = 0; $__cpu < $__cpv; $__cpu++) { if ($__cpy == $__cpt->[$__cpu]) { $__cpw = $__cpu + 1; last; } } if ($__cpw) { $__cpq = $__cps->[0]->[$__cpw]; } return $__cpq; } sub _aat { my ($__cqj, $__cqk, $__cql, $__cqm) = @_; my $__cqc = authlib9_15_4::_aap($__cqj); my $__cqd = 0; my $__cqe = ""; my $__cqf = ""; my $__cqg = ""; my $__cqh = 0; my $__cqi = 0; if (exists $__cqc->{'_kf'}) { $__cqd = $__cqc->{'_kf'}->{'_kg'}; } if ($__cqk > 0) { if ($__cqk == $__cqd) { if (!$__cqm) { $__cqf = $__cql; $__cqf = acbclib9_15_4::_bie($__cqf, $__cqc); } } else { $__cqh = authlib9_15_4::_ade($__cqc->{'_ac'}); $__cqe = _abw($__cqh->[$__cqk - 1], "", $__cqm); if (exists $__cqc->{'_ad'}->{$__cqk}) { $__cqg = $__cqc->{'_ad'}->{$__cqk}->{'_he'}; $__cqi = authlib9_15_4::_ade($__cqg); if ($__cql) { $__cqf = _abw($__cqi->[$__cql - 1], "", $__cqm); } } } } return ($__cqe, $__cqf); } sub CBCNONE { return "[\0CBCNONE()\0]"; } sub CBCVERSION { return "[\0CBCVERSION()\0]"; } sub CBCDESIGNLEVELVALUE { my ($__cqr, $__cqs, $__cqt) = @_; my $__cqn = 0; my $__cqo = 0; my $__cqp = $__cqs - 1; my $__cqq = $__cqt - 1; $__cqn = _aau($__cqr); if (($__cqn != 0) && ($__cqs > 0) && ($__cqt > 0)) { $__cqo = $__cqn->_bcz($__cqp, $__cqq) + 1; } return $__cqo; } sub CBCATTRIBUTEVALUE { my ($__cqy, $__cqz, $__cra) = @_; my $__cqu = 0; my $__cqv = 0; my $__cqw = $__cqz - 1; my $__cqx = $__cra - 1; $__cqu = _aau($__cqy); if (($__cqu != 0) && ($__cqz > 0) && ($__cra > 0)) { $__cqv = $__cqu->_bda($__cqw, $__cqx) + 1; } return $__cqv; } sub CBCDESIGNLEVELTEXT { my ($__crf, $__crg, $__crh) = @_; my $__crb = 0; my $__crc = ""; my $__crd = $__crh - 1; my $__cre = $__crg - 1; $__crb = _aau($__crf); if (($__crb != 0) && ($__crg > 0) && ($__crh > 0)) { $__crc = $__crb->_avh($__cre, $__crd) } return _zx($__crc, 1); } sub CBCATTRIBUTELABEL { my ($__crl, $__crm) = @_; my $__cri = ""; my $__crj = $__crm -1; if ($__crl && $__crm) { my $__crk = 0; $__crk = _aau($__crl); if (($__crk != 0) && ($__crm > 0)) { $__cri = $__crk->_bcl($__crj); } } else { $__cri = "[\0CBCATTRIBUTELABEL()\0]"; } return _zx($__cri, 1); } sub CBCDESIGNCONCEPTVALUE { my ($__crq, $__crr) = @_; my $__crn = 0; my $__cro = 0; my $__crp = $__crr - 1; $__crn = _aau($__crq); if (($__crn != 0) && ($__crr > 0)) { $__cro = $__crn->_bdo($__crp); } return $__cro; } sub CBCCOLUMNWIDTHCSS { my ($__crv) = @_; my $__crs = 0; my $__crt = ""; $__crs = _aau($__crv); if ($__crs->_auw()) { _zr(343, "CBCColumnWidthCSS not supported in Shelf Facing Display.", "CBCColumnWidthCSS is not supported in shelf facing CBC excercises. Either remove the function call or uncheck the box to use shelf facing display.", $@); } if ($__crs) { my $__cru = "#" . $__crv . "_div"; $__crt = $__crs->_axg(); $__crt =~ s/$__cru//g; } return _zx($__crt, 1); } sub _aau { my ($__csb) = @_; my $__crw = 0; my $__crx = $authlib9_15_4::_akv{"hid_respnum"}; authlib9_15_4::_yh("cbclib9_15_4.pl"); if (exists($authlib9_15_4::_aim{$__csb})) { $__crw = $authlib9_15_4::_aim{$__csb}; } else { my $__cry = {}; my $__crz = 0; my $__csa = tell $authlib9_15_4::_ajs; if (exists($authlib9_15_4::_ahv{$__csb})) { $__crz = $authlib9_15_4::_ahv{$__csb}->{'_iz'}; } else { return 0; } $__cry->{'_if'} = $__csb; $__cry->{'_iz'} = $__crz; $__cry = cbclib9_15_4::new($__cry); $authlib9_15_4::_alp = 1; $__cry->_ve(); $authlib9_15_4::_alp = 0; $__crw = cbcviewgenerator9_15_4::_bch($__cry->_awy(1)); $authlib9_15_4::_aim{$__csb} = $__crw; if ($__csa > 0) { seek $authlib9_15_4::_ajs, $__csa, 0; } } return $__crw; } sub CBCTOTALTASKS { return "[\0CBCTOTALTASKS()\0]"; } sub CBCCURRENTTASK { return "[\0CBCCURRENTTASK()\0]"; } sub MAXDIFFTOTALSETS { return "[\0MAXDIFFTOTALSETS()\0]"; } sub MAXDIFFCURRENTSET { return "[\0MAXDIFFCURRENTSET()\0]"; } sub MAXDIFFSCORE { my ($__csh, $__csi) = @_; my $__csc = _aax($__csh); my $__csd = ""; if (defined $__csc) { my $__cse = _aaz($__csh . "_1"); my $__csf = _abb($__cse); if (exists $__csf->{$__csi}) { my $__csg = $__csf->{$__csi}; $__csd = $__csc->[$__csg]; } } return $__csd; } sub MAXDIFFRANKATTVALUE { my ($__csm, $__csn) = @_; my $__csj = ""; my $__csk = _aav($__csm, $__csn); if ($__csk) { my $__csl = _aaz($__csm . "_1"); $__csj = LISTVALUE($__csl->{'_hj'}, $__csk); } return $__csj; } sub MAXDIFFRANKATTLABEL { my ($__csr, $__css) = @_; my $__cso = ""; my $__csp = _aav($__csr, $__css); if ($__csp) { my $__csq = _aaz($__csr . "_1"); $__cso = LISTLABEL($__csq->{'_hj'}, $__csp); } return $__cso; } sub MAXDIFFVERSION { return "[\0MAXDIFFVERSION()\0]"; } sub MAXDIFFRLH { my ($__cst) = @_; if (!exists $authlib9_15_4::_akv{"sys_MaxDiff_RLH_". $__cst}) { _aax($__cst); } return $authlib9_15_4::_akv{"sys_MaxDiff_RLH_". $__cst}; } sub MAXDIFFRSQ { my ($__csu) = @_; if (!exists $authlib9_15_4::_akv{"sys_MaxDiff_RSQ_". $__csu}) { _aax($__csu); } return $authlib9_15_4::_akv{"sys_MaxDiff_RSQ_". $__csu}; } sub BANDITMAXDIFF { my ($__cto, $__ctp, $__ctq) = @_; my $__csv = @_; if ($__csv == 2) { $__ctq = int($__ctp * 5 / 6 + 0.5); } elsif ($__csv == 3) { if ($__ctq < 0 || $__ctq > $__ctp) { authlib9_15_4::_zr(357, "", "Bandit MaxDiff list building error. The NumThompsonItems parameter is out of range."); } } _yh("maxdifflib9_15_4.pl"); my $__csw = _aaz($__cto . "_1"); if (!$__csw) { authlib9_15_4::_zr(356, "", "Bandit MaxDiff list building error."); } my $__csx = _acz($__csw->{'_hj'}); my $__csy = $__csw->{'_hj'}; if ($__csx && exists $__csx->{'_jq'}) { $__csy = $__csx->{'_jq'}; $__csx = _acz($__csx->{'_jq'}); } if ($__ctp < 3 || $__ctp > @{$__csx->{'_gk'}}) { authlib9_15_4::_zr(355, "", "Bandit MaxDiff list building error. The Items parameter is out of range."); } my $__csz = 0; eval { my $__cta = "SELECT * FROM `" . $authlib9_15_4::_akq . "_maxdiff_banditdata` WHERE `exercise_name`=? ORDER BY `parent_list_value`"; my $__ctb = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__cta, 0)); $__ctb->execute($__cto); $__csz = $__ctb->fetchall_arrayref({}); }; if ($@) { authlib9_15_4::_zr(354, "", "Bandit MaxDiff list building error. Error reading the maxdiff_banditdata table."); } _acq($authlib9_15_4::_akv{"hid_respnum"} * 310727); my $__ctc = 8 * atan2(1, 1); my $__ctd = $__csw->{'_pd'}; foreach my $__cte (@{$__csz}) { my $__ctf = $__cte->{"inferred_pair_best"}; my $__ctg = $__cte->{"inferred_pair_total"}; my $__cth = $__ctf / $__ctg; my $__cti = ($__cte->{"occurrences"} + $__cte->{"times_included"}) / 2; if ($__cti == 0) { $__cti = 1; } my $__ctj = sqrt(-2 * log(rand() * .99999 + .00001)) * cos($__ctc * rand()); $__ctj *= sqrt($__cth * (1 - $__cth) / $__cti); $__ctj += $__cth; $__cte->{"win_percent_draw"} = $__ctj; my $__ctk = $__cte->{"times_included"}; my $__ctl = $__ctk + int(rand(6)); $__cte->{"perturbed_times_included"} = $__ctl; } my @__ctm = sort { $b->{"win_percent_draw"} <=> $a->{"win_percent_draw"} } @{$__csz}; for (my $__ctn = 0; $__ctn < $__ctq; $__ctn++) { ADD($__csy, $__ctm[0]->{"parent_list_value"}); shift(@__ctm); } @__ctm = sort { $a->{"perturbed_times_included"} <=> $b->{"perturbed_times_included"} } @__ctm; for (my $__ctn = 0; $__ctn < $__ctp - $__ctq; $__ctn++) { ADD($__csy, $__ctm[$__ctn]->{"parent_list_value"}); } } sub _aav { my ($__ctu, $__ctv) = @_; my $__ctr = ""; my $__cts = _aax($__ctu); if (defined $__cts) { my $__ctt = _aaw($__ctu, $__cts); $__ctr = $__ctt->[$__ctv - 1]->{'_and'}; } return $__ctr; } sub _aaw { my ($__cuc, $__cud) = @_; my $__ctw = $authlib9_15_4::_akv{"hid_respnum"}; my $__ctx = _aaz($__cuc . "_1"); my $__cty = @{$__cud}; my $__ctz = 0; my @__cua = (); for ($__ctz = 0; $__ctz < $__cty; $__ctz++) { push @__cua, {'_and' => ($__ctz + 1), '_anf' => LISTVALUE($__ctx->{'_hj'}, $__ctz + 1), '_ane' => $__cud->[$__ctz]}; } my @__cub = sort { if ($a->{'_ane'} == $b->{'_ane'}) { if ($__ctw % 2 == 0) { return $a->{'_anf'} <=> $b->{'_anf'}; } else { return $b->{'_anf'} <=> $a->{'_anf'}; } } else { return $b->{'_ane'} <=> $a->{'_ane'}; } } @__cua; return \@__cub; } sub _aax { my ($__cui) = @_; my $__cue = undef; my $__cuf = undef; my $__cug = undef; if (exists $authlib9_15_4::_akv{"sys_MaxDiff_Utilities_" . $__cui}) { $__cue = $authlib9_15_4::_akv{"sys_MaxDiff_Utilities_" . $__cui}; } else { _yh("maxdifflib9_15_4.pl"); my $__cuh = _aaz($__cui . "_1"); if ($__cuh) { ($__cue, $__cuf, $__cug) = maxdifflib9_15_4::_bhg($__cuh, $__cui); $authlib9_15_4::_akv{"sys_MaxDiff_Utilities_" . $__cui} = $__cue; $authlib9_15_4::_akv{"sys_MaxDiff_RLH_". $__cui} = $__cuf; $authlib9_15_4::_akv{"sys_MaxDiff_RSQ_". $__cui} = $__cug; } } return $__cue; } sub MAXDIFFDESIGNLABEL { my ($__cul, $__cum) = @_; my $__cuj = 0; my $__cuk = ""; $__cuj = _aay($__cul, $__cum); if ($__cuj != 0) { $__cuk .= $__cuj->{'_op'}; } return $__cuk; } sub MAXDIFFDESIGNVALUE { my ($__cup, $__cuq) = @_; my $__cun = 0; my $__cuo = ""; $__cun = _aay($__cup, $__cuq); if ($__cun != 0) { $__cuo .= $__cun->{'_pt'}; } return $__cuo; } sub _aay { my ($__cva, $__cvb) = @_; my $__cur = 0; my $__cus = 0; my $__cut = ""; if (exists($authlib9_15_4::_ail{$__cva})) { $__cus = $authlib9_15_4::_ail{$__cva}; } else { my $__cuu = _aaz($__cva); if ($__cuu) { my $__cuv = 0; my $__cuw = _aba($__cuu); my $__cux = 0; _yh("maxdifflib9_15_4.pl"); ($__cuv, $__cux) = maxdifflib9_15_4::_bha($__cuu, $__cva, 1); my $__cuy = 0; my @__cuz = (); foreach $__cuy (@{$__cuv}) { push @__cuz, $__cuw->[$__cuy]; } $__cus = \@__cuz; $authlib9_15_4::_ail{$__cva} = $__cus; } } if ($__cus != 0) { $__cur = $__cus->[$__cvb - 1]; } return $__cur; } sub _aaz { my ($__cvf) = @_; my $__cvc = 0; if (exists($authlib9_15_4::_ahv{$__cvf})) { my $__cvd = tell $authlib9_15_4::_ajs; my $__cve = $authlib9_15_4::_ahv{$__cvf}->{'_iz'}; seek $authlib9_15_4::_ajs, $__cve, 0; $__cvc = authlib9_15_4::_zj(0); if ($__cvd > 0) { seek $authlib9_15_4::_ajs, $__cvd, 0; } } return $__cvc; } sub _aba { my ($__cvi) = @_; my $__cvg = $__cvi->{'_hj'}; my $__cvh = _ada($__cvg); return $__cvh; } sub _abb { my ($__cvn) = @_; my $__cvj = _aba($__cvn); my $__cvk = 0; my %__cvl = (); my $__cvm = 0; foreach $__cvk (@{$__cvj}) { $__cvl{$__cvk->{'_pt'}} = $__cvm; $__cvm++; } return \%__cvl; } sub QUOTACELLNAME { my ($__cvo) = @_; return _abc($__cvo); } sub QUOTAGROUPNAME { my ($__cvp) = @_; return _abc($__cvp); } sub _abc { my ($__cvs) = @_; my $__cvq = ""; my $__cvr = _zp(authlib9_15_4::_ws($__cvs)); if ($__cvr) { $__cvq = _yx($__cvs, $__cvr); } return $__cvq; } sub ISQUOTACELLOPEN { my ($__cvt, $__cvu) = @_; return _abd($__cvt, $__cvu); } sub ISQUOTAGROUPOPEN { my ($__cvv, $__cvw) = @_; return _abd($__cvv, $__cvw); } sub _abd { my ($__cvz, $__cwa) = @_; my $__cvx = 0; my $__cvy = _yy($__cvz); if ($__cvy) { $__cvx = _yt($__cvy, $__cwa) } return $__cvx; } sub QUOTACELLREMAINING { my ($__cwb, $__cwc) = @_; return _abe($__cwb, $__cwc); } sub QUOTAGROUPREMAINING { my ($__cwd, $__cwe) = @_; return _abe($__cwd, $__cwe); } sub _abe { my ($__cwj, $__cwk) = @_; my $__cwf = 0; my $__cwg = _yv($__cwj, 0); if ($__cwg) { my $__cwh = $__cwg->{$__cwk}->{'_amw'}; my $__cwi = $__cwg->{$__cwk}->{'_hi'}; $__cwf = $__cwi - $__cwh; if ($__cwf < 0) { $__cwf = 0; } } return $__cwf; } sub QUOTACELLLIMIT { my ($__cwl, $__cwm) = @_; return _abf($__cwl, $__cwm); } sub QUOTAGROUPLIMIT { my ($__cwn, $__cwo) = @_; return _abf($__cwn, $__cwo); } sub _abf { my ($__cwr, $__cws) = @_; my $__cwp = 0; my $__cwq = _yv($__cwr, 0); if ($__cwq) { $__cwp = $__cwq->{$__cws}->{'_hi'}; } return $__cwp; } sub QUOTACELLCOMPLETES { my ($__cwt, $__cwu) = @_; return _abg($__cwt, $__cwu); } sub QUOTAGROUPCOMPLETES { my ($__cwv, $__cww) = @_; return _abg($__cwv, $__cww); } sub _abg { my ($__cwz, $__cxa) = @_; my $__cwx = 0; my $__cwy = _yv($__cwz, 0); if ($__cwy) { $__cwx = $__cwy->{$__cxa}->{'_amw'}; } return $__cwx; } sub AREALLQUOTACELLSCLOSED { my ($__cxb) = @_; return _abh($__cxb); } sub AREALLQUOTAGROUPSCLOSED { my ($__cxc) = @_; return _abh($__cxc); } sub _abh { my ($__cxi) = @_; my $__cxd = 0; my $__cxe = _yy($__cxi); if ($__cxe) { my $__cxf = $__cxe->{'_uf'}->{'_lf'}; my $__cxg = 0; my $__cxh = 0; foreach $__cxg (@{$__cxf}) { if (_yt($__cxe, $__cxg->{'_pt'})) { $__cxh = 1; last; } } if (!$__cxh) { $__cxd = 1; } } return $__cxd; } sub AREALLQUOTASCLOSED { my $__cxj = 0; if ($authlib9_15_4::_ajg) { _ys(); if ($authlib9_15_4::_ali) { my $__cxk = $authlib9_15_4::_ali->{'_lg'}; my $__cxl = ""; my $__cxm = 0; foreach $__cxl (@{$__cxk}) { if (_abh($__cxl) == 0) { $__cxm = 1; last; } } if (!$__cxm) { $__cxj = 1; } } } return $__cxj; } sub AREANYQUOTASCLOSED { my $__cxn = 0; if ($authlib9_15_4::_ajg) { _ys(); if ($authlib9_15_4::_ali) { my $__cxo = $authlib9_15_4::_ali->{'_lg'}; my $__cxp = ""; foreach $__cxp (@{$__cxo}) { if (_abh($__cxp)) { $__cxn = 1; last; } } } } return $__cxn; } sub FLOOR { my ($__cxq) = @_; return _abi($__cxq); } sub _abi { my ($__cxs) = @_; my $__cxr = int($__cxs); if ($__cxs < 0 && $__cxs != $__cxr) { return $__cxr - 1; } return $__cxr; } sub CEILING { my ($__cxt) = @_; return _abj($__cxt); } sub _abj { my ($__cxu) = @_; if ($__cxu > int($__cxu)) { $__cxu = int($__cxu + 1); } elsif ($__cxu < 0) { $__cxu = int($__cxu); } return $__cxu; } sub ROUND { my ($__cxv, $__cxw) = @_; return _abk($__cxv, $__cxw); } sub _abk { my ($__cye, $__cyf) = @_; my $__cxx = @_; my $__cxy = 0; my $__cxz = ""; if ($__cye =~ m/^(-)(.*?)$/) { $__cxz = $1; $__cye = $2; } if ($__cxx == 1 || $__cyf < 0) { $__cyf = 0; } if ($__cye =~ m/\.(\d*?)$/) { my $__cya = $1; my $__cyb = substr $__cya, $__cyf, 1; if ($__cyb == 5) { my $__cyc = 1 / (10 ** ($__cyf + 5)); $__cye += $__cyc; } } $__cye = sprintf("%." . $__cyf . "f", $__cye); if ($__cyf > 0) { if ($__cye !~ m/\./) { $__cye .= "."; } my $__cyd = 0; if ($__cye =~ m/^(.*?)\.(.*?)$/) { $__cyd = length($2); } while($__cyd < $__cyf) { $__cye .= "0"; $__cyd++; } } if ($__cye != 0) { $__cye = $__cxz . $__cye; } return $__cye; } sub ROUNDTONUMBER { my ($__cyg, $__cyh, $__cyi) = @_; return _abl($__cyg, $__cyh, $__cyi); } sub _abl { my ($__cyr, $__cys, $__cyt) = @_; my $__cyj = 0; if ($__cys > 0) { my $__cyk = 0; my $__cyl = 0; my $__cym = 0; my $__cyn = ""; if ($__cyr =~ m/^(-)(.*?)$/) { $__cyn = $1; $__cyr = $2; } if ($__cyr =~ m/\.(\d+)/) { $__cyl = length($1); } elsif ($__cyr =~ m/[Ee][-+]0*(\d+)/) { $__cyl = $1; } if ($__cys =~ m/\.(\d+)/) { $__cym = length($1); } elsif ($__cys =~ m/[Ee][-+]0*(\d+)/) { $__cym = $1; } if ($__cym > $__cyl) { $__cyk = $__cym; } else { $__cyk = $__cyl; } if ($__cyk) { $__cys *= 10 ** $__cyk; $__cys = sprintf("%.0f", $__cys); $__cyr *= 10 ** $__cyk; $__cyr = sprintf("%.0f", $__cyr); } my $__cyo = ($__cyr % $__cys); my $__cyp = $__cys / 2; if ($__cyo >= $__cyp) { my $__cyq = int($__cyr / $__cys); $__cyq++; $__cyj = $__cyq * $__cys; } else { $__cyj = $__cyr - $__cyo; } if ($__cyk > 0) { $__cyj /= 10 ** $__cyk; $__cyj = sprintf("%." . $__cyk . "f", $__cyj); } $__cyj = $__cyn . $__cyj; } else { $__cyj = $__cyr; } if ($__cyt > -1) { $__cyj = _abk($__cyj, $__cyt); } return $__cyj; } sub FORMATNUMBER { my ($__cyu, $__cyv, $__cyw, $__cyx) = @_; return _abm($__cyu, $__cyv, $__cyw, $__cyx); } sub _abm { my ($__cze, $__czf, $__czg, $__czh) = @_; my $__cyy = ""; $__cze = _zp($__cze); if ($__cze =~ m/^(-)(.*?)$/) { $__cyy = $1; $__cze = $2; } $__czh = int($__czh); if ($__czh < 0) { $__czh = 0; } $__cze = _abk($__cze, $__czh); my $__cyz = ""; my $__cza = $__cze; if ($__cze =~ m/(\d*?)\.(.*?)$/) { $__cza = $1; $__cyz = $2; if ($__czg eq "") { $__czg = "."; } $__cyz = $__czg . $__cyz; } if ($__czf) { my $__czb = length($__cza); my $__czc = ""; while ($__czb > 3) { $__czc = $__czf . substr($__cza, $__czb - 3 , 3) . $__czc; $__czb -= 3; } $__cza = substr($__cza, 0, $__czb) . $__czc; } my $__czd = $__cza . $__cyz; if ($__czd != 0) { $__czd = $__cyy . $__czd; } return $__czd; } sub _abn { my ($__czi) = @_; $__czi = authlib9_15_4::_abp($__czi); if ($__czi =~ m/^(0+)(.*)$/) { if (length($1) == length($__czi)) { $__czi = 0; } else { $__czi = $2; if ($__czi =~ m/^0*\.0*$/) { $__czi = 0; } } } $__czi = _abo($__czi); return $__czi; } sub _abo { my ($__czk) = @_; if ($__czk) { if ($__czk =~ m/^-?\d*\.(\d+)$/o) { my $__czj = $1; if (length($__czj) > 15) { $__czk = sprintf("%.15f", $__czk); } $__czk = _abq($__czk); } } return $__czk; } sub _abp { my ($__czl) = @_; $__czl =~ s/,/./; return $__czl; } sub _abq { my ($__czo) = @_; if ($__czo =~ m/^(-?\d*)\.(\d+)$/o) { my $__czm = $1; my $__czn = $2; $__czn =~ s/0+$//; if (length($__czn)) { $__czm .= "." . $__czn; } $__czo = $__czm; if (length($__czo) == 0) { $__czo = 0; } } return $__czo; } sub POWER { my ($__czp, $__czq) = @_; return $__czp ** $__czq; } sub MID { my ($__czr, $__czs, $__czt) = @_; if ($__czs < 1) { $__czs = 1; } return substr($__czr, $__czs - 1, $__czt); } sub TEXTEXISTS { my ($__czw, $__czx) = @_; my $__czu = 0; my $__czv = index(uc($__czw), uc($__czx)); if ($__czv > -1) { $__czu = 1; } return $__czu; } sub ENCODEFORURL { my ($__czy) = @_; return _abr($__czy); } sub _abr { my ($__dae) = @_; my @__czz = split("", $__dae); my $__daa = ""; my @__dab = (); my $__dac = ""; my $__dad = 0; foreach $__daa (@__czz) { $__dad = ord($__daa); if (($__daa =~ m/\w/) || $__dad < 32 || $__dad > 126) { $__dac = $__daa; } else { $__dac = "%" . uc(sprintf "%lx", $__dad); } push @__dab, $__dac; } return join("", @__dab); } sub ISNUMBER { my ($__daf) = @_; return _abs($__daf); } sub _abs { my ($__dag) = @_; $__dag = _zp($__dag); $__dag =~ s/^-//; if (exists $authlib9_15_4::_akx->{'_dq'}) { if ($__dag =~ m/\./) { $__dag =~ s/\.//; } else { $__dag =~ s/,//; } } else { $__dag =~ s/\.//; } if ($__dag =~ m/^(\d+)$/) { return 1; } else { return 0; } } sub SHOWN { my ($__dao) = @_; my $__dah = $authlib9_15_4::_akv{"hid_respnum"}; my ($__dap, $__daq, $__dar) = authlib9_15_4::_abu($__dao); my @__dai = @{authlib9_15_4::_xy($__dah, {"limbo" => 0})}; @__dai = grep { $_->{"quest_name"} =~ m/^$__dap\b/ } @__dai; for (my $__daj = 0; $__daj < @__dai; $__daj++) { if ($__dao eq $__dai[$__daj]->{"quest_name"} || exists $__dai[$__daj]->{"data"}->{$__dao}) { return 1; } } if ($__dar eq "") { if (exists $authlib9_15_4::_akv{"hid_loops"}) { authlib9_15_4::_adt(); my $__dak = 0; if (exists $authlib9_15_4::_ahv{$__dap}) { my $__dal = $authlib9_15_4::_ahv{$__dap}; $__dak = $__dal->{'_ji'}; } else { $__dak = _aae(); } my $__dam = $authlib9_15_4::_akw->[$__dak - 1]; my $__dan = ciwlib9_15_4::_qz($authlib9_15_4::_akv{"hid_loops"}); my ($__das, $__dat) = ciwlib9_15_4::_rb($__dam, $__dan); if ($__das) { $__dao .= $__das; for (my $__daj = 0; $__daj < @__dai; $__daj++) { if ($__dao eq $__dai[$__daj]->{"quest_name"} || exists $__dai[$__daj]->{"data"}->{$__dao}) { return 1; } } } } } return 0; } sub ANSWERED { my ($__dav) = @_; my $__dau = 0; if (_zp(authlib9_15_4::_ws($__dav)) ne "") { $__dau = 1; } return $__dau; } sub LOG10 { my ($__daw) = @_; return (log($__daw) / log(10)); } sub LOOPVALUE { my ($__dax) = @_; my ($__day, $__daz, $__dba) = _abt($__dax); return $__daz; } sub LOOPLABEL { my ($__dbb) = @_; my ($__dbc, $__dbd, $__dbe) = _abt($__dbb); return $__dbe; } sub LOOPITERATION { my ($__dbf) = @_; my ($__dbg, $__dbh, $__dbi) = _abt($__dbf); return $__dbg; } sub _abt { my ($__dbr) = @_; my $__dbj = ""; my $__dbk = ""; my $__dbl = ""; authlib9_15_4::_adt(); my $__dbm = ciwlib9_15_4::_qz($authlib9_15_4::_akv{"hid_loops"}); my $__dbn = _aae(); if ($__dbn < 2 && exists $authlib9_15_4::_akv{"hid_loops_restart_page"}) { $__dbn = $authlib9_15_4::_akv{"hid_loops_restart_page"}; } my $__dbo = $authlib9_15_4::_akw->[$__dbn - 1]; if (exists $__dbo->{'_hm'}) { if ($__dbr eq "") { $__dbr = $__dbo->{'_hm'}->[0]; } if (exists $__dbm->{$__dbr}) { $__dbj = $__dbm->{$__dbr}; my $__dbp = $authlib9_15_4::_amm->{$__dbr}->{'_hj'}; my $__dbq = authlib9_15_4::_ada($__dbp); if ($__dbq) { $__dbk = $__dbq->[$__dbj - 1]->{'_pt'}; $__dbl = $__dbq->[$__dbj - 1]->{'_op'}; } } } return ($__dbj, $__dbk, $__dbl); } sub SETVALUE { my ($__dbw, $__dbx) = @_; if ($authlib9_15_4::_ajx || $authlib9_15_4::_amo) { return ""; } my $__dbs = ciwlib9_15_4::_rj(); if ($__dbs) { authlib9_15_4::_wt($__dbw, $__dbx); my ($__dby, $__dbz) = _xk($__dbw); eval { my $__dbt = "UPDATE `" . $authlib9_15_4::_akq . "_data" . $__dby . "` SET `" . $__dbw . "` = ? WHERE `sys_RespNum` = " . $__dbs; my $__dbu = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__dbt, 0)); $__dbu->execute(_wh($__dbx)); }; if ($@) { my $__dbv = "Database error. Error in \"SetValue\" function. Cannot update data row."; if ($__dby == 0) { $__dbv .= " Cannot find \"" . $__dbw . "\" in database."; } authlib9_15_4::_zr(269, "Database error.", $__dbv, $@); } $authlib9_15_4::_akl->commit(); } return ""; } sub GETVALUE { my ($__dca) = @_; return _ws($__dca); } sub SCREENWIDTH { return _aet(); } sub _abu { my ($__dce) = @_; my $__dcb = ""; if ($__dce =~ m/(.*?)(\..*?)$/) { $__dce = $1; $__dcb = $2; } my $__dcc = $__dce; my $__dcd = ""; if ($__dce =~ m/^sys_/i) { if ($__dce =~ m/^(sys_.*?)_(.*?)$/i) { $__dcc = $1; $__dcd = $2; } } elsif ($__dce =~ m/_/) { if ($__dce =~ m/^(.*?_(\d+|\*))_(b|w|anchor)$/i) { $__dcc = $1; $__dcd = $3; $__dcc =~ s/_\*$/_1/; } elsif ($__dce =~ m/^(.*?)_(.*?)$/i) { $__dcc = $1; $__dcd = $2; } if (!exists $authlib9_15_4::_ahv{$__dcc}) { if ($__dce =~ m/^(.*?_.*?)_(.*?)$/i) { $__dcc = $1; $__dcd = $2; } if (!exists $authlib9_15_4::_ahv{$__dcc}) { $__dcc = $__dce; $__dcd = ""; } } } return ($__dcc, $__dcd, $__dcb); } sub _abv { my ($__ddt, $__ddu, $__ddv, $__ddw) = @_; my $__dcf = 0; my $__dcg = 0; my $__dch = ""; my $__dci = 0; my $__dcj = 0; my $__dck = ""; my $__dcl = ""; my $__dcm = 0; my $__dcn = 0; my $__dco = 0; my $__dcp = ""; my $__dcq = 0; ($__ddt, $__dck, $__dcl) = authlib9_15_4::_abu($__ddt); $__dck = lc($__dck); $__dcf = $authlib9_15_4::_ahv{$__ddt}; $__dcg = $__dcf->{'_pj'}; if ($__dcg == &authlib9_15_4::_ANO) { $__dcj = tell $authlib9_15_4::_ajs; $__dci = $__dcf->{'_iz'}; seek $authlib9_15_4::_ajs, ($__dci), 0; my $__dcr = _zj(0); if ($__dcr->{'_pj'} eq "check") { if ($__ddw) { $__dcm = _ade($__dcr->{'_hj'}); } else { $__dcm = _ada($__dcr->{'_hj'}, $__dcl); } if ($__ddu && $__dcm) { $__dcn = @{$__dcm}; for ($__dco = 0; $__dco < $__dcn; $__dco++) { if ($__dcm->[$__dco]->{'_pt'} == $__dck) { $__dch = _abw($__dcm->[$__dco], "", $__ddw); last; } } } elsif ($__dck eq "") { my $__dcs = ""; my @__dct = (); my $__dcu = ""; if ($__dcm) { $__dcn = @{$__dcm}; for ($__dco = 0; $__dco < $__dcn; $__dco++) { $__dcq = $__dcm->[$__dco]->{'_pt'}; $__dcs = $__ddt . "_" . $__dcq . $__dcl; $__dcu = authlib9_15_4::_ws($__dcs); if ($__dcu ne "") { push @__dct, {'_pt'=>$__dcq, '_anh'=>_zp($__dcu)}; } } } $__dch = \@__dct; } } else { if ($__ddu) { if ($__ddv ne "") { $__dcm = _ade($__dcr->{'_hj'}); $__dcp = $__ddt . "_" . $__ddv . "_other" . $__dcl; $__dch = _abw($__dcm->[$__ddv - 1], $__dcp, $__ddw); } } else { $__dcm = _ada($__dcr->{'_hj'}, $__dcl); $__dch = _aca($__dcm, $__ddt . $__dcl); } } seek $authlib9_15_4::_ajs, $__dcj, 0; } elsif ($__dcg == &authlib9_15_4::_AOA) { my $__dcv = 0; my $__dcw = 0; my $__dcx = ""; my $__dcy = 0; my $__dcz = 0; my $__dda = 0; my $__ddb = 0; my $__ddc = 0; my $__ddd = 0; my $__dde = ""; my $__ddf = 0; my $__ddg = $__ddt . "_" . $__dck; $__dcj = tell $authlib9_15_4::_ajs; $__dci = $__dcf->{'_iz'}; seek $authlib9_15_4::_ajs, ($__dci), 0; $__dcv = _zj(0); $__dcx = $__ddg; if ($__dcx =~ m/(.*?)_r(\d+)/) { $__ddc = $2; } if ($__dcx =~ m/(.*?)_c(\d+)/) { $__ddd = $2; } if ($__dcv->{'_pu'} eq "cols") { $__dcx =~ s/_r\d+//; $__dcy = $__ddd; $__ddf = $__ddc; } else { $__dcx =~ s/_c\d+//; $__dcy = $__ddc; $__ddf = $__ddd; } $__dcz = $__dcv->{'_pv'}->[$__dcy - 1]; if ($__dcv->{'_pu'} eq "cols") { $__dde = $__dcv->{'_mw'}; } else { $__dde = $__dcv->{'_co'}; } if ($__dcz->{'_if'} eq $__dcx) { $__dda = ref($__dcz); } if ($__dda eq "RadioVar") { if ($__ddu) { if ($__ddv ne "") { $__dcm = _ade($__dde); $__dcp = $__ddg . "_other"; if ($__dcp =~ m/_r\d+/) { $__dcp =~ s/_r\d+/_c$__ddv/; } elsif ($__dcp =~ m/_c\d+/) { $__dcp =~ s/_c\d+/_r$__ddv/; } $__dch = _abw($__dcm->[$__ddv - 1], $__dcp, $__ddw); } } else { $__dch = _aca(_ada($__dde, $__dcl), $__ddg . $__dcl); } } else { if (!$__ddu && $__dck !~ m/_/) { $__dch = _aby($__dcx, $__dcv, _ada($__dde, $__dcl), $__dcl); } else { if (($__dda eq "ComboVar") || (($__dda eq "RankVar") && ($__dcz->{'_pj'} eq "combo"))) { $__dcm = _ade($__dcz->{'_hj'}); if ($__ddu) { if ($__ddv ne "") { $__dcp = $__ddg . "_" . $__ddv . "_other"; $__dch = _abw($__dcm->[$__ddv - 1], $__dcp, $__ddw); } } else { $__dch = _aca(_ada($__dcz->{'_hj'}, $__dcl), $__ddg . $__dcl); } } elsif (!$__ddu) { $__dch = $__ddv; } } } seek $authlib9_15_4::_ajs, $__dcj, 0; } elsif ($__dcg == &authlib9_15_4::_AOB || $__dcg == &authlib9_15_4::_AOC) { $__dcj = tell $authlib9_15_4::_ajs; $__dci = $__dcf->{'_iz'}; seek $authlib9_15_4::_ajs, ($__dci), 0; my $__ddh = _zj(0); if ($__ddu) { if ($__ddw) { $__dcm = _ade($__ddh->{'_hj'}); } else { $__dcm = _ada($__ddh->{'_hj'}, $__dcl); } if ($__dcm) { $__dcn = @{$__dcm}; for ($__dco = 0; $__dco < $__dcn; $__dco++) { if ($__dcm->[$__dco]->{'_pt'} == $__dck) { $__dch = _abw($__dcm->[$__dco], "", $__ddw); last; } } } } elsif ($__dck eq "") { my $__dcs = ""; my @__dct = (); my $__dcu = ""; $__dcm = _ada($__ddh->{'_hj'}, $__dcl); if ($__dcm) { $__dcn = @{$__dcm}; for ($__dco = 0; $__dco < $__dcn; $__dco++) { $__dcq = $__dcm->[$__dco]->{'_pt'}; $__dcs = $__ddt . "_" . $__dcq; $__dcu = authlib9_15_4::_ws($__dcs); if ($__dcu ne "") { push @__dct, {'_pt'=>$__dcq, '_anh'=>_zp($__dcu)}; } } } $__dch = \@__dct; } seek $authlib9_15_4::_ajs, $__dcj, 0; } elsif ($__dcg == &authlib9_15_4::_AOE) { $__dcj = tell $authlib9_15_4::_ajs; $__dci = $__dcf->{'_iz'}; seek $authlib9_15_4::_ajs, ($__dci), 0; my $__ddi = _zj(0); if ($__ddu) { if (exists $__ddi->{'_eg'} && $__dck eq "anchor") { if ($__ddv ne "") { my $__ddj = $__ddi->{'_eg'}->{'_mo'}; my $__ddk = 0; foreach $__ddk(@{$__ddj}) { if ($__ddk->{'_pt'} == $__ddv) { $__dch = $__ddk->{'_op'}; last; } } } } elsif ($__ddv ne "") { $__dcm = _ade($__ddi->{'_hj'}); $__dch = _abw($__dcm->[$__ddv - 1], "", $__ddw); } } else { $__dcm = _ada($__ddi->{'_hj'}, $__dcl); if ($__dcm) { my $__ddl = 0; my $__ddm = 0; my $__ddn = 0; _yh("maxdifflib9_15_4.pl"); ($__ddl, $__ddn) = maxdifflib9_15_4::_bha($__ddi, $__ddt, 1); my $__ddo = 0; my @__ddp = (); foreach $__ddo (@{$__ddl}) { push @__ddp, $__dcm->[$__ddo]; } $__dch = _aca(\@__ddp, $__ddt . "_" . $__dck); } } seek $authlib9_15_4::_ajs, $__dcj, 0; } elsif ($__dcg == &authlib9_15_4::_AOG) { if ($__ddu) { my ($__ddx, $__ddy) = authlib9_15_4::_aat($__ddt, $__dck, $__ddv, $__ddw); $__dch = $__ddy; } else { my $__ddq = authlib9_15_4::_aap($__ddt); my $__ddr = $__dck; if (exists $__ddq->{'_ad'}->{$__ddr}) { my $__dds = $__ddq->{'_ad'}->{$__ddr}->{'_he'}; $__dcm = _ada($__dds, $__dcl); $__dch = _aca($__dcm, $__ddt . "_" . $__ddr); } } } return ($__dch, $__dcf); } sub _abw { my ($__deb, $__dec, $__ded) = @_; my $__ddz = ""; if ($__ded) { $__ddz = _abx($__deb); } else { my $__dea = _zp(authlib9_15_4::_ws($__dec)); if ($__dec && exists($__deb->{'_jg'}) && $__dea) { $__ddz = $__dea; } else { $__ddz = $__deb->{'_op'}; } } return $__ddz; } sub _abx { my ($__def) = @_; my $__dee = ""; if (exists $__def->{'_k'}) { $__dee = $__def->{'_k'}; } else { $__dee = $__def->{'_op'}; } $__dee = _zp($__dee); return $__dee; } sub _aby { my ($__dem, $__den, $__deo, $__dep) = @_; my $__deg = 0; my $__deh = 0; my $__dei = ""; my @__dej = (); my $__dek = 0; my $__del = ""; if ($__deo) { $__deh = @{$__deo}; } for ($__deg = 0; $__deg < $__deh; $__deg++) { $__dei = $__dem; $__dek = $__deo->[$__deg]->{'_pt'}; if ($__den->{'_pu'} eq "cols") { $__dei =~ s/(_c\d+)/_r$__dek$1/; } else { $__dei .= "_c" . $__dek; } $__dei .= $__dep; $__del = _zp(authlib9_15_4::_ws($__dei)); if ($__del ne "" || _aen($__dei)) { push @__dej, {'_pt'=>$__dek, '_anh'=>$__del}; } } return \@__dej; } sub _abz { my ($__deu, $__dev, $__dew, $__dex) = @_; my $__deq = ""; my $__der = 0; if ($__dev != 0) { my $__des = @{$__dev}; $__der = 1; if ($__dew eq "") { if ($__dex =~ m/^values$/i) { $__deq = "[" . join(",", map{$_->{'_pt'}} @{$__dev}) . "]"; } elsif ($__dex =~ m/^labels$/i) { $__deq = "[" . join(",", map{"'" . $_->{'_op'} . "'"} @{$__dev}) . "]"; } elsif ($__dex =~ m/^length$/i) { $__deq = $__des; } } else { if ($__dex =~ m/^value$/i) { if (($__dew > 0) && ($__dew <= $__des)) { $__deq = $__dev->[$__dew - 1]->{'_pt'}; } } elsif ($__dex =~ m/^label$/i) { if (($__dew > 0) && ($__dew <= $__des)) { $__deq = $__dev->[$__dew - 1]->{'_op'}; } } elsif ($__dex =~ m/^hasParentItem$/i) { my $__det = 0; $__deq = 0; for ($__det = 0 ; $__det < $__des; $__det++) { if ($__dev->[$__det]->{'_pt'} == $__dew) { $__deq = 1; last; } } } } } return($__der, $__deq); } sub _aca { my ($__dfe, $__dff) = @_; my @__dey = (); my $__dez = authlib9_15_4::_ws($__dff); if ($__dfe && ($__dez ne "" || _aen($__dff))) { my $__dfa = 0; my $__dfb = @{$__dfe}; my $__dfc = 0; my $__dfd = 0; for ($__dfa = 0; $__dfa < $__dfb; $__dfa++) { $__dfc = $__dfe->[$__dfa]->{'_pt'}; $__dfd = 0; if ($__dez == $__dfc) { $__dfd = 1; } push @__dey, {'_pt'=>$__dfc, '_anh'=>$__dfd}; } } return \@__dey; } sub _acb { my @__dfg = ( { "name" => "time_stamp", "sql_info" => "INT NOT NULL" }, { "name" => "type", "sql_info" => "INT NOT NULL" }, { "name" => "error_number", "sql_info" => "INT" }, { "name" => "message", "sql_info" => "TEXT" }, { "name" => "system_error", "sql_info" => "TEXT" }, { "name" => "form_input", "sql_info" => "TEXT" }, { "name" => "ssi_version", "sql_info" => "TEXT NOT NULL" }, { "name" => "ip_address", "sql_info" => "TEXT" }, { "name" => "user_agent", "sql_info" => "TEXT" } ); return \@__dfg; } sub _acc { my $__dfh = _acb(); my $__dfi = 0; my @__dfj = (); foreach $__dfi(@{$__dfh}) { push(@__dfj, "`" . $__dfi->{"name"} . "` " . $__dfi->{"sql_info"}); } return join(",", @__dfj); } sub _acd { my $__dfk = _acb(); my $__dfl = 0; my @__dfm = (); my @__dfn = (); foreach $__dfl(@{$__dfk}) { push(@__dfm, "`" . $__dfl->{"name"} . "`"); push(@__dfn, "?"); } return (join(",", @__dfm), join(",", @__dfn)); } sub _ace { my $__dfo = _acb(); my $__dfp = 0; my @__dfq = (); foreach $__dfp(@{$__dfo}) { push(@__dfq, "\"" . $__dfp->{"name"} . "\""); } return join(",", @__dfq); } sub _acf { my ($__dfv) = @_; my $__dfr = _acb(); my $__dfs = 0; my @__dft = (); my $__dfu = ""; foreach $__dfs(@{$__dfr}) { $__dfu = ""; if (exists $__dfv->{$__dfs->{"name"}}) { $__dfu = _acl($__dfv->{$__dfs->{"name"}}); $__dfu =~ s/\n//g; } push(@__dft, $__dfu); } return join(",", @__dft); } sub _acg { my ($__dgb) = @_; my $__dfw = _acb(); my $__dfx = 0; my @__dfy = (); my $__dfz = ""; my $__dga = 10000; foreach $__dfx(@{$__dfw}) { $__dfz = undef; if (exists $__dgb->{$__dfx->{"name"}}) { $__dfz = authlib9_15_4::_wh($__dgb->{$__dfx->{"name"}}); $__dfz = authlib9_15_4::_ach($__dfz,$__dga); } push(@__dfy, $__dfz); } return \@__dfy; } sub _ach { my ($__dgc,$__dgd) = @_; if(length($__dgc) > $__dgd){ $__dgc = sprintf("%.". $__dgd . "s", $__dgc); } return $__dgc; } sub _aci { my ($__dgl, $__dgm, $__dgn, $__dgo, $__dgp) = @_; my $__dge = ""; my $__dgf = $authlib9_15_4::_aig; my $__dgg = ""; my %__dgh = (); $__dgh{"time_stamp"} = time(); $__dgh{"type"} = $__dgl; $__dgh{"error_number"} = $__dgm; $__dgh{"message"} = substr($__dgn, 0, 10000); $__dgh{"system_error"} = substr($__dgo, 0, 10000); $__dgh{"ip_address"} = _aad(); $__dgf =~ s/_/./g; $__dgh{"ssi_version"} = $__dgf; if (exists($ENV{"HTTP_USER_AGENT"})) { $__dgg = $ENV{"HTTP_USER_AGENT"}; } $__dgh{"user_agent"} = substr($__dgg, 0, 10000); my $__dgi = ""; my @__dgj = (); foreach $__dgi (sort keys(%authlib9_15_4::_akv)) { push(@__dgj, $__dgi . "=>" . $authlib9_15_4::_akv{$__dgi}); } $__dgh{"form_input"} = join(" | ", @__dgj); my $__dgk = 0; if (!$__dgp && $authlib9_15_4::_akl && !$__dgk) { $__dgk = _acj(\%__dgh, 0); } else { _ack(\%__dgh); } } sub _acj { my ($__dgy, $__dgz) = @_; my ($__dha, $__dhb) = _acd(); my $__dgq = _acg($__dgy); my $__dgr = 0; eval { my $__dgs = "INSERT INTO `" . $authlib9_15_4::_akq . "_survey_log` (" . $__dha . ") VALUES (" . $__dhb . ")"; my $__dgt = $authlib9_15_4::_akl->prepare(authlib9_15_4::_wn($__dgs, 0)); $__dgt->execute(@{$__dgq}); $__dgt->finish; }; if ($@) { $__dgr = 1; my $__dgu = 332; my $__dgv = "Cannot insert into survey_log table."; my $__dgw = _zp($@); my $__dgx = _acx($__dgy); $__dgx->{"error_number"} = $__dgu; $__dgx->{"message"} = $__dgv; $__dgx->{"system_error"} = $__dgw; _ack($__dgx); } elsif ($authlib9_15_4::_akl) { $authlib9_15_4::_akl->commit(); } return $__dgr; } sub _ack { my ($__dhe) = @_; my $__dhc = $authlib9_15_4::_aib{'_amt'}; if ($__dhc eq "") { $__dhc = "../admin/"; } my $__dhd = $__dhc . "error_log.cgi"; my ($__dhf, $__dhg) = authlib9_15_4::_yg($__dhd, "append", 0, 0); if (!$__dhg) { authlib9_15_4::_ze($__dhf, 1); print $__dhf _acf($__dhe) . "\n"; close $__dhf; } } sub _acl { my ($__dhh) = @_; $__dhh =~ s/"/""/g; return "\"" . $__dhh . "\""; } sub _acm { my ($__dic, $__did, $__die, $__dif) = @_; my $__dhi = 0; my $__dhj = 0; my $__dhk = $__dic->{'_pu'}; my $__dhl = @{$__die}; my $__dhm = @{$__dif}; my $__dhn = $__dic->{'_pv'}; my @__dho = (); my $__dhp = 0; my $__dhq = ""; my $__dhr = ""; my $__dhs = 0; my $__dht = ""; my $__dhu = 0; my $__dhv = 0; my $__dhw = 0; my $__dhx = 0; my $__dhy = 0; my $__dhz = 0; my $__dia = ""; my $__dib = 0; if ($__dhk eq "rows") { foreach $__dhw (@{$__die}) { $__dhy = $__dhw - 1; $__dhp = _acx($__dhn->[$__dhy]); $__dhq = $__dhp->{'_if'}; $__dht = ref($__dhp); if ($__dht eq "CheckVar") { $__dhp->{'_if'} = $__dhq . "_c*"; $__dhp->{'_iy'} = $__dhm; $__dhp->{'_uh'} = $__dif; push @__dho, $__dhp; } elsif ($__dht eq "RadioVar") { push @__dho, $__dhp; } elsif (($__did == 0) && ($__dht eq "RankVar" || $__dht eq "ConsumVar")) { $__dhp->{'_uz'} = $__dhq . "_c*"; $__dhp->{'_ang'} = $__dhm; $__dhp->{'_uh'} = $__dif; push @__dho, $__dhp; } else { $__dib = 0; if (($__dht eq "ConsumVar") && $__did) { foreach $__dhx (@{$__dif}) { $__dhz = $__dhx; $__dhr = $__dhq . "_c" . ($__dhz); if (exists $authlib9_15_4::_akv{$__dhr}) { $__dia = _zp($authlib9_15_4::_akv{$__dhr}); if ($__dia ne "") { $__dib = 1; last; } } } } foreach $__dhx (@{$__dif}) { $__dhz = $__dhx; $__dhp->{'_if'} = $__dhq . "_c" . ($__dhz); if ($__dib) { $__dhp->{'_ui'} = 1; } push @__dho, _acx($__dhp); } } } } else { foreach $__dhx (@{$__dif}) { $__dhz = $__dhx - 1; $__dhp = _acx($__dhn->[$__dhz]); $__dhq = $__dhp->{'_if'}; $__dht = ref($__dhp); if ($__dht eq "CheckVar") { $__dhr = $__dhq; $__dhr =~ s/(_c.*)$/_r\*$1/; $__dhp->{'_if'} = $__dhr; $__dhp->{'_iy'} = $__dhl; $__dhp->{'_uh'} = $__die; push @__dho, $__dhp; } elsif ($__dht eq "RadioVar") { push @__dho, $__dhp; } elsif (($__did == 0) && ($__dht eq "RankVar" || $__dht eq "ConsumVar")) { $__dhr = $__dhq; $__dhr =~ s/(_c.*)$/_r\*$1/; $__dhp->{'_uz'} = $__dhr; $__dhp->{'_ang'} = $__dhl; $__dhp->{'_uh'} = $__die; push @__dho, $__dhp; } else { $__dib = 0; if (($__dht eq "ConsumVar") && $__did) { foreach $__dhw (@{$__die}) { $__dhy = $__dhw; $__dhr = $__dhq; $__dhr =~ s/(_c.*)$/_r$__dhy$1/; if (exists $authlib9_15_4::_akv{$__dhr}) { $__dia = _zp($authlib9_15_4::_akv{$__dhr}); if ($__dia ne "") { $__dib = 1; last; } } } } foreach $__dhw (@{$__die}) { $__dhy = $__dhw; $__dhr = $__dhq; $__dhr =~ s/(_c.*)$/_r$__dhy$1/; $__dhp->{'_if'} = $__dhr; if ($__dib) { $__dhp->{'_ui'} = 1; } push @__dho, _acx($__dhp); } } } } return \@__dho; } sub _acn { my ($__dii) = @_; my $__dig = @{$__dii}; my $__dih = 0; for ($__dih = $__dig - 1; $__dih >= 0; $__dih--) { if (!exists($__dii->[$__dih]->{'_jg'}) && !exists($__dii->[$__dih]->{'_in'})) { last; } } return ($__dih + 1); } sub _aco { my ($__diq, $__dir, $__dis, $__dit, $__diu) = @_; my $__dij = 0; my $__dik = 0; my $__dil = 0; my $__dim = 0; my $__din = 0; my @__dio = () x $__dir; my $__dip = 0; if ($__dir < $__diu) { $__diu = $__dir; } $__dit = $__dit - 1; $__diu = $__diu - 1; if ($__dit < $__diu) { $__dip = 1; $__dim = _acp($__diq, ($__diu - $__dit) + 1, $__dis); } if ($__dip && ($__dit == 0) && ($__diu == ($__dir - 1))) { $__din = $__dim; } else { for ($__dij = 0; $__dij < $__dir; $__dij++) { if ($__dip && ($__dij >= $__dit) && ($__dij <= $__diu)) { $__dil = ($__dim->[$__dik]) + $__dit; $__dio[$__dij] = $__dil; $__dik++; } else { $__dio[$__dij] = $__dij; } } $__din = \@__dio; } return $__din; } sub _acp { my ($__dix, $__diy, $__diz) = @_; _acq($__dix + $__diz); my @__div = map{ rand() } (0..($__diy-1)); my @__diw = sort { $__div[$a] <=> $__div[$b] } (0..($__diy-1)); return \@__diw; } sub _acq { my ($__djc) = @_; my $__dja = 0; my $__djb = 0; $__dja = $__djc % 10000; $__djb = (((($__dja * 3141 + int($__djc / 10000) * 5821) % 10000) * 10000 + $__dja * 5821) % 100000000 + 1) % 100000000; srand($__djb); $__dja = $__djb % 5 + 1; while ($__dja--){ rand; } $_ = rand; return $_; } sub _acr { my ($__djd,$__dje,$__djf) = @_; if (!$__dje) { if ($__djd =~ m/^-?\d+$/) { return(0); } } elsif (exists $authlib9_15_4::_akx->{'_dq'}) { if ($__djd =~ m/^-?(?:\d+(?:(\.|,)\d*)?|(\.|,)\d+)$/) { return(0); } } else { if ($__djd =~ m/^-?(?:\d+(?:\.\d*)?|\.\d+)$/) { return(0); } } return(1); } sub _acs { my ($__djg) = @_; $__djg =~ s/\[\0/\[%/g; $__djg =~ s/\0\]/%\]/g; return $__djg; } sub _act { my ($__djk) = @_; my $__djh = ""; my $__dji = ""; if (exists $authlib9_15_4::_akv{"hid_backup"}) { $__djh = $authlib9_15_4::_akv{"hid_backup"}; my @__djj = split(",", $__djh); if ($__djk eq "hid_studyname") { $authlib9_15_4::_akv{"hid_studyname"} = $__djj[0]; $__dji = $authlib9_15_4::_akv{"hid_studyname"}; } elsif ($__djk eq "hid_respnum") { if ($__djj[1] && $__djj[2]) { $authlib9_15_4::_akv{"hid_respnum"} = $__djj[1] . "," . $__djj[2]; } $__dji = $authlib9_15_4::_akv{"hid_respnum"}; } elsif ($__djk eq "hid_pagenum") { $authlib9_15_4::_akv{"hid_pagenum"} = $__djj[3]; $__dji = $authlib9_15_4::_akv{"hid_pagenum"}; } elsif ($__djk eq "hid_javascript") { $authlib9_15_4::_akv{"hid_javascript"} = $__djj[4]; $__dji = $authlib9_15_4::_akv{"hid_javascript"}; } } return $__dji; } sub _acu { my ($__djp) = @_; my $__djl = 0; my $__djm = 0; my $__djn = 0; my $__djo = ""; $__djn = length($__djp); for ($__djm = 0; $__djm < $__djn; $__djm++) { $__djo = chop $__djp; $__djl += ord(uc $__djo) * ($__djm + 1); } return ($__djl); } sub _acv { if ($authlib9_15_4::_ajs) { close $authlib9_15_4::_ajs; } if ($authlib9_15_4::_akl) { _we(); } exit(); } sub _acw { my ($__djr, $__djs) = @_; my $__djq = pack "H*", $__djr; for (0..length($__djq)-1) { for (vec($__djq, $_, 8)) { $_ -= $__djs if $_ >= $__djs; } } return unpack "H*", $__djq; } sub _acx { my ($__dju) = @_; my $__djt = ref $__dju; if (not $__djt) { $__dju; } elsif ($__djt eq "ARRAY") { [map _acx($_), @$__dju]; } elsif ($__dju =~ m/=ARRAY\(/) { bless([map _acx($_), @$__dju], $__djt); } elsif ($__djt eq "HASH") { +{map { $_ => _acx($__dju->{$_}) } keys %$__dju}; } elsif ($__dju =~ m/=HASH\(/) { bless(+{map { $_ => _acx($__dju->{$_}) } keys %$__dju}, $__djt); } else { die "what type is $_?"; } } sub _acy { if ($authlib9_15_4::_als == 0) { my $__djv = tell $authlib9_15_4::_ajs; if ($authlib9_15_4::_aiq) { seek $authlib9_15_4::_ajs, ($authlib9_15_4::_aiq), 0; $authlib9_15_4::_als = _zj(0); seek $authlib9_15_4::_ajs, $__djv, 0; } else { return 0; } } } sub _acz { my ($__djw) = @_; if ($authlib9_15_4::_als == 0) { if ($authlib9_15_4::_aiq) { unless (_acy()) { return 0; } } else { return 0; } } if (exists($authlib9_15_4::_als->{$__djw})) { return _acx($authlib9_15_4::_als->{$__djw}); } else { return 0; } } sub _ada { my ($__dle, $__dlf) = @_; my $__djx = 0; my $__djy = 0; my $__djz = 0; my $__dka = 0; my $__dkb = ""; if ($__dle =~ m/(.*?)(\..*?)$/) { $__dle = $1; $__dkb = $2; } if ($authlib9_15_4::_amb eq $__dle && $authlib9_15_4::_aml) { $__djy = _add(); } else { $__dka = _acz($__dle); } if ($authlib9_15_4::_amo && $__dka) { if (exists($__dka->{'_jq'})) { $__dka = _acz($__dka->{'_jq'}); } if ($__dka && exists($__dka->{'_gk'})) { if (@{$__dka->{'_gk'}} == 0) { push @{$__dka->{'_gk'}}, {'_op'=>"", '_pt'=>"1"}; } } } if ($__dka) { if (exists($__dka->{'_jq'})) { my $__dkc = $__dka->{'_hk'}; my $__dkd = _acz($__dka->{'_jq'}); my $__dke = 0; my @__dkf = (); my $__dkg = $authlib9_15_4::_aml; my $__dkh = $authlib9_15_4::_alz; my $__dki = $authlib9_15_4::_ama; my @__dkj = (); my $__dkk = ""; my $__dkl = 0; $authlib9_15_4::_aml = \@__dkj; $authlib9_15_4::_alz = $__dkd; $authlib9_15_4::_ama = $__dka->{'_jq'}; if (!exists($authlib9_15_4::_aiy{$authlib9_15_4::_ama})) { $__dke = @{$__dkd->{'_gk'}}; my @__dkm = ("") x ($__dke + 1); $__dkm[0] = 0; $authlib9_15_4::_aiy{$authlib9_15_4::_ama} = \@__dkm; } $authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[0]++; if ($authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[0] > 1000) { _aci(&authlib9_15_4::_APB, 0, "Circular reference found in list building causing an infinite loop. List name: " . $__dle); return 0; } $__dkk = $authlib9_15_4::_amb; $authlib9_15_4::_amb = $__dle; my $__dkn = authlib9_15_4::_ws($__dle . $__dkb, 0, $__dle); if ($__dkn eq "" && exists($authlib9_15_4::_akv{$__dle})) { $__dkn = $authlib9_15_4::_akv{$__dle}; } if ($__dkn eq "" && (exists $authlib9_15_4::_akv{"hid_loops"} || exists $authlib9_15_4::_akv{"hid_loops_restart_dot_notation"}) && $__dkb eq "") { my $__dko = ""; if (exists $authlib9_15_4::_akv{"hid_loops_restart_dot_notation"}) { $__dko = $authlib9_15_4::_akv{"hid_loops_restart_dot_notation"}; } else { my $__dkp = ciwlib9_15_4::_qz($authlib9_15_4::_akv{"hid_loops"}); my $__dkq = $authlib9_15_4::_akw->[_aae() - 1]; my $__dkr = 0; ($__dko, $__dkr) = ciwlib9_15_4::_rb($__dkq, $__dkp, $__dle); } if ($__dko) { my $__dks = $__dle . $__dko; my $__dkt = authlib9_15_4::_ws($__dks); if ($__dkt ne "") { authlib9_15_4::_wt($__dle, $__dkt); $__dkn = $__dkt; } } } if ($__dkn) { if ($ciwlib9_15_4::_tz && exists($authlib9_15_4::_akv{$__dle})) { $authlib9_15_4::_aiz{$__dle} = $__dkn; authlib9_15_4::_wt($__dle, $__dkn); } if ($__dkn =~ m/[\d,\s]+/) { $authlib9_15_4::_aml = eval("[" . $__dkn . "]"); if ($@) { authlib9_15_4::_zr(133, "", "Reading saved list error.", $@); } my $__dku = authlib9_15_4::_ws($__dle . "_others" . $__dkb); if ($__dku ne "" || exists($authlib9_15_4::_akv{$__dle . "_others"})) { if ($__dku eq "" && exists($authlib9_15_4::_akv{$__dle . "_others"})) { $__dku = $authlib9_15_4::_akv{$__dle . "_others"}; } $__dku =~ s/\\,/\0/g; my @__dkv = split(",", $__dku); my $__dkw = @__dkv; if ($ciwlib9_15_4::_tz && exists($authlib9_15_4::_akv{$__dle . "_others"})) { $authlib9_15_4::_aiz{$__dle . "_others"} = $__dku; authlib9_15_4::_wt($__dle . "_others", $__dku); } $__dku = ""; for ($__djz = 0; $__djz < $__dkw; $__djz++) { $__dkl = $authlib9_15_4::_aml->[$__djz]; $__djx = $__dkd->{'_gk'}->[$__dkl - 1]; if (exists($__djx->{'_jg'})) { $__dku = $__dkv[$__djz]; if ($__dku ne "") { $__dku =~ s/"/&quot;/g; $__dku =~ s/\0/,/g; $__djx->{'_op'} = $__dku; $__djx->{'_jg'}->{'_op'} = $__dku; $authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[$__dkl] = $__dku; } } } } } } elsif ($__dlf || $__dkb || (exists $authlib9_15_4::_akn->{$__dle} && $authlib9_15_4::_akn->{$__dle} eq "")) { $__djy = 0; } else { _zy($__dkc, "list building"); $__dkn = _adc($authlib9_15_4::_aml); my $__dkx = $__dle; $authlib9_15_4::_aiz{$__dkx} = $__dkn; authlib9_15_4::_wt($__dle, $__dkn); } $__dke = @{$authlib9_15_4::_aml}; if ($__dke > @{$__dkd->{'_gk'}}) { authlib9_15_4::_zr(134, "List building error.", "List building error: The number of items in the parent list (" . $__dka->{'_jq'} . ") is less than the number of items in the constructed list (" . $__dle . ").", ""); } my $__dky = 0; my $__dkz = ""; my @__dla = (); for ($__djz = 0; $__djz < $__dke; $__djz++) { $__dkl = $authlib9_15_4::_aml->[$__djz]; $__djx = $__dkd->{'_gk'}->[$__dkl - 1]; push @__dkf, $__djx; $__dky = $__dkf[$__djz]->{'_pt'}; if (exists $__djx->{'_jg'} && $authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[$__dky] ne "") { $__dkz = $authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[$__dky]; $__dkf[$__djz]->{'_op'} = $__dkz; $__dkz =~ s/"/&quot;/g; $__dkf[$__djz]->{'_jg'}->{'_op'} = $__dkz; $__dkz =~ s/,/\\,/g; push @__dla, $__dkz; } else { push @__dla, ""; } } $__dkz = join(",", @__dla); my $__dlb = $__dle . "_others"; my $__dlc = $__dkz; $__dlc =~ s/,//g; if ($__dlc ne "") { my $__dld = authlib9_15_4::_ws($__dlb); if ($__dld eq "" && !exists($authlib9_15_4::_akv{$__dlb})) { $authlib9_15_4::_aiz{$__dlb} = $__dkz; authlib9_15_4::_wt($__dlb, $__dkz); } } $authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[0]--; if ($authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[0] == 0) { delete $authlib9_15_4::_aiy{$authlib9_15_4::_ama}; } $authlib9_15_4::_aml = $__dkg; $authlib9_15_4::_alz = $__dkh; $authlib9_15_4::_ama = $__dki; $authlib9_15_4::_amb = $__dkk; $__djy = \@__dkf; } else { $__djy = $__dka->{'_gk'}; } if ($__djy && !$authlib9_15_4::_akd) { if (exists $authlib9_15_4::_ait->{$__dle . $__dkb}) { $__djy = $authlib9_15_4::_ait->{$__dle . $__dkb}; } else { _adb($__djy); $authlib9_15_4::_ait->{$__dle . $__dkb} = $__djy; } } } if ($__dlf && $__dkb eq "" && ($__djy == 0 || @{$__djy} == 0)) { $__djy = _ada($__dle . $__dlf); } if ($__djy) { if (@{$__djy} == 0) { $__djy = 0; } } return $__djy; } sub _adb { my ($__dlk) = @_; my $__dlg = @{$__dlk}; my $__dlh = 0; my $__dli = 0; my $__dlj = 0; for ($__dlh = 0; $__dlh < $__dlg; $__dlh++) { $__dli = $__dlk->[$__dlh]; $__dli->{'_op'} = _zx($__dli->{'_op'}, 0); if (exists $__dli->{'_jg'}) { $__dlj = $__dli->{'_jg'}; if (exists $__dlj->{'_ek'}) { $__dlj->{'_ek'} = _zx($__dlj->{'_ek'}, 0); } } } } sub _adc { my ($__dlm) = @_; my $__dll = join(",", @{$__dlm}); return $__dll; } sub _add { my $__dln = 0; my $__dlo = ""; my $__dlp = 0; my @__dlq = (); if ($authlib9_15_4::_aml) { my $__dlr = @{$authlib9_15_4::_aml}; for ($__dlp = 0; $__dlp < $__dlr; $__dlp++) { push @__dlq, $authlib9_15_4::_alz->{'_gk'}->[$authlib9_15_4::_aml->[$__dlp] - 1]; } } return \@__dlq; } sub _ade { my ($__dlu) = @_; my $__dls = []; my $__dlt = _acz($__dlu); if ($__dlt) { if (exists($__dlt->{'_jq'})) { $__dlt = _acz($__dlt->{'_jq'}); } if ($__dlt) { $__dls = $__dlt->{'_gk'}; } } return $__dls; } sub _adf { my ($__dlx) = @_; my $__dlv = ""; my $__dlw = _acz($__dlx); if ($__dlw && exists($__dlw->{'_jq'})) { $__dlv = $__dlw->{'_jq'}; } else { $__dlv = $__dlx; } return $__dlv; } sub _adg { my ($__dmi, $__dmj, $__dmk) = @_; my $__dly = 0; my $__dlz = 0; my $__dma = @{$__dmi}; my $__dmb = 0; my $__dmc = @{$authlib9_15_4::_aml}; my $__dmd = 0; if ($__dmj <= 0) { $__dmd = 1; } for ($__dly = 0; $__dly < $__dma; $__dly++) { $__dmb = $__dmi->[$__dly]; if ($__dmk && $authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[0] == 1) { $authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[$__dmb] = ""; } for ($__dlz = 0; $__dlz < $__dmc; $__dlz++) { if ($__dmb == $authlib9_15_4::_aml->[$__dlz]) { if ($__dmd) { $__dmi->[$__dly] = ""; } else { $authlib9_15_4::_aml->[$__dlz] = ""; } } } } my @__dme = (); for ($__dly = 0; $__dly < $__dmc; $__dly++) { if ($authlib9_15_4::_aml->[$__dly] ne "") { push @__dme, $authlib9_15_4::_aml->[$__dly]; } } $__dmc = @__dme; my @__dmf = (); for ($__dly = 0; $__dly < $__dma; $__dly++) { if ($__dmi->[$__dly] ne "") { push @__dmf, $__dmi->[$__dly]; } } $__dma = @__dmf; if ($__dmj > $__dmc) { $__dmj = -1; } if ($__dmj <= 0) { push @__dme, @__dmf; $authlib9_15_4::_aml = \@__dme; } else { my @__dmg = (); my @__dmh = (); if ($__dmj > 1) { @__dmg = @__dme[0 .. ($__dmj - 2)]; } if ($__dmc > 0) { @__dmh = @__dme[($__dmj - 1) .. ($__dmc - 1)]; } push @__dmf, @__dmh; push @__dmg, @__dmf; $authlib9_15_4::_aml = \@__dmg; } } sub _adh { my ($__dmo) = @_; my @__dml = (); if ($__dmo && (ref($__dmo) eq "ARRAY")) { my $__dmm = @{$__dmo}; my $__dmn = 0; for ($__dmn = 0; $__dmn < $__dmm; $__dmn++) { push @__dml, ($__dmo->[$__dmn]->{'_pt'}); } } return \@__dml; } sub AIC { my ($__dmq, $__dmr, $__dms) = @_; my $__dmp = @_; _adn($__dmq, ">", 0, 0, $__dmr, $__dms, $__dmp); } sub RIC { my ($__dmw, $__dmx, $__dmy) = @_; my $__dmt = @_; my $__dmu = _acx($authlib9_15_4::_aml); $authlib9_15_4::_aml = []; _adn($__dmw, ">", 0, 0, $__dmx, $__dmy, $__dmt); my $__dmv = _acx($authlib9_15_4::_aml); $authlib9_15_4::_aml = $__dmu; _adk($__dmv); } sub ANC { my ($__dna, $__dnb, $__dnc) = @_; my $__dmz = @_; _adn($__dna, "==", 0, 0, $__dnb, $__dnc, $__dmz); } sub AIE { my ($__dnd, $__dne) = @_; _adn($__dnd, "==", $__dne, _adm($__dnd), 0, 0, 0); } sub AIELOOPLIST { my ($__dnf, $__dng, $__dnh) = @_; _adp($__dng, "==", $__dnh, $__dnf); } sub ANE { my ($__dni, $__dnj) = @_; _adn($__dni, "!=", $__dnj, _adm($__dni), 0, 0, 0); } sub ANELOOPLIST { my ($__dnk, $__dnl, $__dnm) = @_; _adp($__dnl, "!=", $__dnm, $__dnk); } sub AIL { my ($__dnn, $__dno) = @_; _adn($__dnn, "<", $__dno, _adm($__dnn), 0, 0, 0); } sub AILLOOPLIST { my ($__dnp, $__dnq, $__dnr) = @_; _adp($__dnq, "<", $__dnr, $__dnp); } sub AIG { my ($__dns, $__dnt) = @_; _adn($__dns, ">", $__dnt, _adm($__dns), 0, 0, 0); } sub AIGLOOPLIST { my ($__dnu, $__dnv, $__dnw) = @_; _adp($__dnv, ">", $__dnw, $__dnu); } sub ADD { my ($__dny, $__dnz, $__doa) = @_; my $__dnx = @_; if ($__dnx == 1) { INSERT(-1, $__dny); } elsif ($__dnx == 2 && $__dnz > 0) { INSERT(-1, $__dny, $__dnz); } elsif ($__dnx == 3 && $__dnz > 0 && $__doa >= $__dnz) { INSERT(-1, $__dny, $__dnz, $__doa); } } sub ADDSORTED { my ($__doj, $__dok) = @_; my $__dob = 0; my $__doc = ""; my $__dod = _adm($__doj); my @__doe = (); my @__dof = (); my $__dog = 0; if ($__dod) { ($__dob, $__doc) = _adl($__doj); } else { ($__dob, $__dog) = _abv($__doj, 0, "", 0); } if ($__dob) { @__doe = @{$__dob}; @__dof = grep { $_->{'_anh'} } @__doe; my $__doh = -1; if ($__dok) { @__dof = sort { if ($a->{'_anh'} eq $b->{'_anh'}) { $__doh++; if (RANDNUM($__doh) >= 0.5) { return -1; } else { return 1; } } else { return $a->{'_anh'} <=> $b->{'_anh'}; } } @__dof; } else { @__dof = sort { if ($a->{'_anh'} eq $b->{'_anh'}) { $__doh++; if (RANDNUM($__doh) >= 0.5) { return 1; } else { return -1; } } else { return $b->{'_anh'} <=> $a->{'_anh'}; } } @__dof; } @__dof = map { $_->{'_pt'} } @__dof; foreach my $__doi (@__dof) { _ado($__doj, $__doi, $__dod, $__doc); } } _adg(\@__dof, -1, 0); } sub MIRROR { my ($__dos, $__dot) = @_; my $__dol = @_; if ($__dol == 1) { $__dot = 0; } my @__dom = @{_adh(_ada($__dos))}; my $__don = _acz($__dos); my $__doo = 1; if ($__don && exists($__don->{'_jq'})) { $__doo = 0; } my @__dop = map { $_ + $__dot } @__dom; my @__doq = @{_adh(_ada($authlib9_15_4::_ama))}; my %__dor = map { $_ => 1 } @__doq; @__dop = grep { exists $__dor{$_} } @__dop; _adg(\@__dop, -1, $__doo); } sub INSERT { my ($__dpe, $__dpf, $__dpg, $__dph) = @_; my $__dou = @_; my $__dov = ""; my $__dow = ""; my @__dox = (); my $__doy = _adh(_ada($__dpf)); my $__doz = _acz($__dpf); my $__dpa = 1; if ($__doz && exists($__doz->{'_jq'})) { $__dpa = 0; } if ($__dou == 2) { _adg($__doy, $__dpe, $__dpa); } elsif ($__dou == 3) { my $__dpb = $__dpg; if ($__dpb > 0) { push @__dox, $__doy->[$__dpb - 1]; _adg(\@__dox, $__dpe, $__dpa); } } elsif ($__dou == 4) { $__dov = $__dpg; $__dow = $__dph; if (($__dov > 0) && ($__dow >= $__dov)) { my $__dpc = 0; my $__dpd = @{$__doy}; if ($__dow > $__dpd) { $__dow = $__dpd; } $__dov--; $__dow--; for ($__dpc = $__dov; $__dpc <= $__dow; $__dpc++) { push @__dox, $__doy->[$__dpc]; } _adg(\@__dox, $__dpe, $__dpa); } } } sub REMOVE { my ($__dpm, $__dpn, $__dpo) = @_; my $__dpi = @_; my $__dpj = _adh(_ada($__dpm)); if ($__dpi == 1) { _adk($__dpj); } else { if ($__dpi == 2) { $__dpo = $__dpn; } if ($__dpn > 0 && $__dpo >= $__dpn) { my $__dpk = 0; my @__dpl = (); for ($__dpk = $__dpn; $__dpk <= $__dpo; $__dpk++) { push @__dpl, $__dpj->[$__dpk - 1]; } _adk(\@__dpl); } } } sub PARENTLISTNAME { return $authlib9_15_4::_ama; } sub RANDOMIZE { my ($__dpz, $__dqa, $__dqb) = @_; my $__dpp = @_; my $__dpq = 0; my $__dpr = @{$authlib9_15_4::_aml}; my $__dps = 1; my $__dpt = 0; my $__dpu = 0; if ($__dpp == 0) { $__dpt = $__dpr; } elsif ($__dpp == 1) { $__dpt = $__dpr; $__dpu = $__dpz; } elsif ($__dpp == 2) { $__dps = $__dpz; $__dpt = $__dqa; } elsif ($__dpp == 3) { $__dpu = $__dpz; $__dps = $__dqa; $__dpt = $__dqb; } if (exists($authlib9_15_4::_akv{"hid_respnum"}) && defined($authlib9_15_4::_akv{"hid_respnum"})) { $__dpq = $authlib9_15_4::_akv{"hid_respnum"}; } if ($__dpt > $__dpr) { $__dpt = $__dpr; } if ($__dps < 1) { $__dps = 1; } if ($__dpu == 0) { my $__dpv = $authlib9_15_4::_amb; if (exists $authlib9_15_4::_akv{"hid_loops"}) { $__dpv .= $authlib9_15_4::_akv{"hid_loops"}; } $__dpu = _acu($__dpv) + $authlib9_15_4::_ajd * 53; $authlib9_15_4::_ajd++; } my $__dpw = _aco($__dpq, $__dpr, $__dpu, $__dps, $__dpt); my @__dpx = (); my $__dpy = 0; for ($__dpy = 0; $__dpy < $__dpr; $__dpy++) { push @__dpx, $authlib9_15_4::_aml->[$__dpw->[$__dpy]]; } $authlib9_15_4::_aml = \@__dpx; } sub LISTMIN { my ($__dqn) = @_; my $__dqc = @{$authlib9_15_4::_aml}; my $__dqd = 0; if ($__dqc < $__dqn) { $__dqd = $__dqn - $__dqc; my $__dqe = 0; my $__dqf = $authlib9_15_4::_alz->{'_gk'}; my $__dqg = @{$__dqf}; if (exists($authlib9_15_4::_akv{"hid_respnum"}) && defined($authlib9_15_4::_akv{"hid_respnum"})) { $__dqe = $authlib9_15_4::_akv{"hid_respnum"}; } my $__dqh = _acu($authlib9_15_4::_amb); my $__dqi = _aco($__dqe, $__dqg, $__dqh, 1, $__dqg); my $__dqj = 0; my @__dqk = (); my $__dql = 0; my $__dqm = 0; for ($__dqj = 0; $__dqj < $__dqg; $__dqj++) { if ($__dqd == 0) { last; } $__dqm = 1; $__dql = $__dqi->[$__dqj]; if (exists $__dqf->[$__dql]->{'_in'}) { $__dqm = 0; } elsif (exists $__dqf->[$__dql]->{'_jg'}) { $__dqm = 0; } if ($__dqm) { $__dqk[0] = $__dql + 1; _adg(\@__dqk, -1, 0); if (@{$authlib9_15_4::_aml} > $__dqc) { $__dqc = @{$authlib9_15_4::_aml}; $__dqd--; } } } } } sub LISTMAX { my ($__dqr) = @_; my $__dqo = @{$authlib9_15_4::_aml}; if ($__dqo > $__dqr) { my @__dqp = (); my $__dqq = 0; for ($__dqq = 0; $__dqq < $__dqr; $__dqq++) { push @__dqp, $authlib9_15_4::_aml->[$__dqq]; } $authlib9_15_4::_aml = \@__dqp; } } sub ISCAPI { return _ws("sys_DataSource") == &authlib9_15_4::_AOR ? 1 : 0; } sub CAPIDEVICEID { return _adi(); } sub _adi { return _ws("sys_CAPIDeviceID"); } sub SETLISTLENGTH { my ($__dqs) = @_; LISTMAX($__dqs); LISTMIN($__dqs); } sub REVERSE { my @__dqt = reverse(@{$authlib9_15_4::_aml}); $authlib9_15_4::_aml = \@__dqt; } sub SORTBYVALUE { my @__dqu = sort {$a <=> $b} @{$authlib9_15_4::_aml}; $authlib9_15_4::_aml = \@__dqu; } sub SORTBYLABEL { my $__dqv = @{$authlib9_15_4::_aml}; my $__dqw = 0; my $__dqx = 0; my $__dqy = 0; my @__dqz = (); my $__dra = 0; for ($__dqw = 0; $__dqw < $__dqv; $__dqw++) { $__dqx = $authlib9_15_4::_aml->[$__dqw]; $__dqy = _acx($authlib9_15_4::_alz->{'_gk'}->[$__dqx - 1]); $__dqy->{'_op'} = _zx($__dqy->{'_op'}, 0); push @__dqz, $__dqy; $__dra = $__dqz[$__dqw]->{'_pt'}; if ($authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[$__dra] ne "") { $__dqz[$__dqw]->{'_op'} = _zx($authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[$__dra], 0); } } my @__drb = sort {_adj($a, $b)} @__dqz; my @__drc = map {$_->{'_pt'}} @__drb; $authlib9_15_4::_aml = \@__drc; } sub _adj { my $__drd = shift->{'_op'}; my $__dre = shift->{'_op'}; Sort::Naturally::ncmp($__drd,$__dre); } sub _adk { my ($__drl) = @_; my $__drf = 0; my $__drg = 0; my $__drh = @{$__drl}; my $__dri = 0; my $__drj = @{$authlib9_15_4::_aml}; for ($__drf = 0; $__drf < $__drh; $__drf++) { $__dri = $__drl->[$__drf]; for ($__drg = 0; $__drg < $__drj; $__drg++) { if ($__dri == $authlib9_15_4::_aml->[$__drg]) { $authlib9_15_4::_aml->[$__drg] = ""; } } } my @__drk = (); for ($__drf = 0; $__drf < $__drj; $__drf++) { if ($authlib9_15_4::_aml->[$__drf] ne "") { push @__drk, $authlib9_15_4::_aml->[$__drf]; } } $authlib9_15_4::_aml = \@__drk; } sub _adl { my ($__drz) = @_; my $__drm = $authlib9_15_4::_ahv{$__drz}; my $__drn = $__drm->{'_pj'}; my @__dro = (); my $__drp = 0; if ($__drn == &authlib9_15_4::_AOA) { my $__drq = tell $authlib9_15_4::_ajs; my $__drr = $__drm->{'_iz'}; my $__drs = ""; my $__drt = ""; seek $authlib9_15_4::_ajs, ($__drr), 0; $__drp = _zj(0); if ($__drp->{'_pu'} eq "cols") { $__drs = $__drp->{'_co'}; } else { $__drs = $__drp->{'_mw'}; } my $__dru = _ada($__drs); my $__drv = 0; if ($__dru) { $__drv = @{$__dru}; } my $__drw = 0; my $__drx = ""; my $__dry = 0; for ($__drw = 0; $__drw < $__drv; $__drw++) { $__dry = $__dru->[$__drw]->{'_pt'}; if ($__drp->{'_pu'} eq "cols") { $__drx = $__drz . "_c" . $__dry; } else { $__drx = $__drz . "_r" . $__dry; } $__drt = _zp(authlib9_15_4::_ws($__drx)); if ($__drt ne "" || _aen($__drx)) { push @__dro, {'_pt'=>$__dry, '_anh'=>$__drt}; } } seek $authlib9_15_4::_ajs, $__drq, 0; } return (\@__dro, $__drp->{'_pu'}); } sub _adm { my ($__dsb) = @_; my $__dsa = 0; if (exists($authlib9_15_4::_ahv{$__dsb})) { if ($authlib9_15_4::_ahv{$__dsb}->{'_pj'} == 16) { $__dsa = 1; } } return $__dsa; } sub _adn { my ($__dso, $__dsp, $__dsq, $__dsr, $__dss, $__dst, $__dsu) = @_; my $__dsc = 0; my $__dsd = ""; my @__dse = (); my $__dsf = ""; my $__dsg = 0; if ($__dsq eq "") { return ""; } if ($__dsu > 0) { if ($__dsu == 1) { $__dss = 0; $__dst = 0; } else { if ($__dsu == 2) { $__dst = $__dss; } if (!($__dss > 0 && $__dst >= $__dss)) { return ""; } } } else { $__dss = 0; $__dst = 0; } if ($__dsr) { ($__dsc, $__dsd) = _adl($__dso); } else { ($__dsc, $__dsg) = _abv($__dso, 0, "", 0); } if ($__dsc != 0) { my $__dsh = @{$__dsc}; my $__dsi = 0; my $__dsj = 0; my $__dsk = 0; my $__dsl = ""; my $__dsm = 0; my $__dsn = 0; for ($__dsi = 0; $__dsi < $__dsh; $__dsi++) { $__dsm = $__dsc->[$__dsi]->{'_pt'}; $__dsn = $__dsc->[$__dsi]->{'_anh'}; if ($__dss > 0 && ($__dsm < $__dss)) { next; } elsif ($__dst > 0 && ($__dsm > $__dst)) { next; } if ($__dsn eq "") { $__dsn = "0"; } $__dsf = $__dsn . " " . $__dsp . " " . $__dsq; $__dsk = eval($__dsf); if ($@) { authlib9_15_4::_zr(135, "", "List building error.", $@); } if ($__dsk) { push @__dse, $__dsm; _ado($__dso, $__dsm, $__dsr, $__dsd); } } } _adg(\@__dse, -1, 0); } sub _ado { my ($__dsy, $__dsz, $__dta, $__dtb) = @_; my $__dsv = ""; my $__dsw = ""; my $__dsx = ""; if ($__dsy =~ m/(.*?)(\..*?)$/) { $__dsy = $1; $__dsx = $2; } if ($__dta) { $__dsv = $__dsy . "_"; if ($__dtb eq "rows") { $__dsv .= "r" . $__dsz . "_other"; } else { $__dsv .= "c" . $__dsz . "_other"; } } elsif ($__dsy =~ m/_/) { $__dsv = $__dsy . "_other"; if ($__dsv =~ m/_r\d+/) { $__dsv =~ s/_r\d+/_c$__dsz/; } elsif ($__dsv =~ m/_c\d+/) { $__dsv =~ s/_c\d+/_r$__dsz/; } } else { $__dsv = $__dsy . "_" . $__dsz . "_other"; } if ($__dsx) { $__dsv .= $__dsx; } $__dsw = authlib9_15_4::_ws($__dsv); if ($__dsw ne "") { $authlib9_15_4::_aiy{$authlib9_15_4::_ama}->[$__dsz] = $__dsw; } } sub _adp { my ($__dtp, $__dtq, $__dtr, $__dts) = @_; my @__dtc = (); my %__dtd = (); authlib9_15_4::_adt(); if (exists $authlib9_15_4::_amm->{$__dts}) { my $__dte = _aef($__dtp); my $__dtf = $authlib9_15_4::_akw->[$__dte->{'_ji'} - 1]; my @__dtg = (); my $__dth = ""; my $__dti = 0; if (exists $__dtf->{'_hm'}) { my @__dtj = reverse @{$__dtf->{'_hm'}}; my $__dtk = 0; for ($__dtk = 0; $__dtk < @__dtj; $__dtk++) { if (uc($__dtj[$__dtk]) eq uc($__dts)) { $__dti = $__dtk; } } _adr($__dtp, \@__dtj, \@__dtg, ""); } my $__dtl = 0; my $__dtm = ""; my $__dtn = 0; my $__dto = 0; foreach $__dth (@__dtg) { $__dtl = authlib9_15_4::_ws($__dth); if ($__dtl eq "") { if (_aen($__dth)) { $__dtl = 0; } else { next; } } $__dtm = $__dtl . " " . $__dtq . " " . $__dtr; $__dtn = eval($__dtm); if ($@) { authlib9_15_4::_zr(259, "", "List building error.", $@); } if ($__dtn) { $__dto = _adq($__dth, $__dti); if (!exists $__dtd{$__dto}) { $__dtd{$__dto} = 1; push @__dtc, $__dto; } } } } _adg(\@__dtc, -1, 0); } sub _adq { my ($__dtw, $__dtx) = @_; my $__dtt = 0; if ($__dtw =~ m/(.*?)\.(.*?)$/) { my @__dtu = (); my $__dtv = $2; if ($__dtv =~ m/\./) { @__dtu = split(/\./, $__dtv); } else { push @__dtu, $__dtv; } if ($__dtx < @__dtu) { $__dtt = $__dtu[$__dtx]; } } return $__dtt; } sub _adr { my ($__dud, $__due, $__duf, $__dug) = @_; my $__dty = _acx($__due); my $__dtz = shift @{$__dty}; if (exists $authlib9_15_4::_amm->{$__dtz}) { my $__dua = $authlib9_15_4::_amm->{$__dtz}->{'_hj'}; my $__dub = authlib9_15_4::_ada($__dua); if ($__dub) { foreach my $__duc (@{$__dub}) { if (@{$__dty}) { _adr($__dud, $__dty, $__duf, $__dug . "." . $__duc->{'_pt'}); } else { push @{$__duf}, $__dud . $__dug . "." . $__duc->{'_pt'}; } } } } } sub _ads { my ($__dul) = @_; my $__duh = "SELECT * FROM `" . $authlib9_15_4::_akq . "_clists` WHERE `sys_RespNum` = " . $__dul; my $__dui = 0; eval { $__dui = $authlib9_15_4::_akl->selectall_hashref(authlib9_15_4::_wn($__duh, 0), "list_name"); }; if ($@) { authlib9_15_4::_zr(255, "Database error.", "Database error. Cannot read clist table.", $@); } my $__duj = ""; my $__duk = ""; foreach $__duj (keys %{$__dui}) { $__duk = authlib9_15_4::_wi($__dui->{$__duj}->{"value"}); authlib9_15_4::_wt($__duj, $__duk); } return $__dui; } sub _adt { if (!$authlib9_15_4::_amm) { if ($authlib9_15_4::_air) { seek $authlib9_15_4::_ajs, $authlib9_15_4::_air, 0; $authlib9_15_4::_amm = authlib9_15_4::_zj(0); } } } sub _adu { my $__dum = 1; my $__dun = authlib9_15_4::_ws("sys_CheckSum"); my $__duo = $authlib9_15_4::_akv{"hid_checksum"}; if ($__duo && $__duo == $__dun) { $__dum = 0; } if ($__dum) { authlib9_15_4::_zr(138, "Access Denied.", "Access Denied. Inconsistency in security check." . $__duo . " != " . $__dun . ". ", ""); } } sub _adv { my ($__dur) = @_; if (exists $__dur->{'_hx'}) { my $__dup = _zp($__dur->{'_hx'}); if ($__dup eq "") { $__dur->{'_hx'} = 0; } } if (exists $__dur->{'_ho'}) { my $__duq = _zp($__dur->{'_ho'}); if ($__duq eq "") { $__dur->{'_ho'} = 0; } } } sub _adw { my ($__duv) = @_; my $__dus = 1; my $__dut = $__duv; if ($__duv =~ m/^(\d*)\.(\d*)$/) { $__dut = $1; } if ($__dut =~ m/^0+(\d+)$/) { $__dus = 0; } my $__duu = $__duv; $__duu =~ s/\.//; if ($__duu !~ m/^\d+$/) { $__dus = 0; } return $__dus; } sub _adx { my ($__duy) = @_; my $__duw = 1; $__duy = _zp($__duy); my $__dux = $__duy; $__dux =~ s/\.//; $__dux =~ s/^-//; if ($__dux !~ m/^\d+$/) { $__duw = 0; } return $__duw; } sub _ady { my ($__dvb) = @_; my @__duz = (); my $__dva = 0; for ($__dva = 1; $__dva <= $__dvb; $__dva++) { push @__duz, $__dva; } return \@__duz; } sub _adz { my $__dvc = "<script type=\"text/javascript\" src=\"" . $authlib9_15_4::_aib{'_ur'} . "system/ssi_base9_15_4.js\"></script>\n"; return $__dvc; } sub _aea { my $__dvd = "<script type=\"text/javascript\" src=\"" . $authlib9_15_4::_aib{'_ur'} . "system/jquery-3.6.3.min.js\"></script>\n"; return $__dvd; } sub _aeb { my $__dve = "<script type=\"text/javascript\" src=\"" . $authlib9_15_4::_aib{'_ur'} . "system/jquery-ui-1.13.2.min.js\"></script>\n"; $__dve .= "<script type=\"text/javascript\" src=\"" . $authlib9_15_4::_aib{'_ur'} . "system/jquery.ui.touch-punch.min.js\"></script>\n"; $__dve .= "<script type=\"text/javascript\" src=\"" . $authlib9_15_4::_aib{'_ur'} . "system/jquery.dialogOptions.js\"></script>\n"; return $__dve; } sub _aec { my $__dvf .= "<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $authlib9_15_4::_aib{'_ur'} . "system/smoothness/jquery-ui-1.13.2.min.css\">\n"; return $__dvf; } sub _aed { my $__dvg = "<script type=\"text/javascript\" src=\"" . $authlib9_15_4::_aib{'_ur'} . "system/modernizr-3.12.0.js\"></script>\n"; return $__dvg; } sub _aee { my $__dvh = ""; $__dvh .= "<script type=\"text/javascript\" src=\"" . $authlib9_15_4::_aib{'_ur'} . "system/chart.umd.min.js\"></script>\n"; return $__dvh; } sub _aef { my ($__dvj) = @_; if ($__dvj =~ m/(.*?)\./) { $__dvj = $1; } my $__dvi = 0; my ($__dvk, $__dvl, $__dvm) = authlib9_15_4::_abu($__dvj); if (exists($authlib9_15_4::_ahv{$__dvj})) { $__dvi = $authlib9_15_4::_ahv{$__dvj}; } elsif (exists($authlib9_15_4::_ahv{$__dvk})) { $__dvi = $authlib9_15_4::_ahv{$__dvk}; } else { if ($__dvj =~ m/(.*?)_(\d+)$/i) { $__dvk = $1; if (exists($authlib9_15_4::_ahv{$__dvk})) { $__dvi = $authlib9_15_4::_ahv{$__dvk}; } } } return $__dvi; } sub _aeg { my ($__dyb, $__dyc, $__dyd, $__dye, $__dyf, $__dyg, $__dyh) = @_; my $__dvn = ""; my $__dvo = @{$authlib9_15_4::_akw}; my $__dvp = 0; my $__dvq = 0; my $__dvr = 0; my $__dvs = 0; my $__dvt = 0; my $__dvu = 0; my $__dvv = 0; my $__dvw = 0; my $__dvx = 0; my $__dvy = 0; my $__dvz = ""; my $__dwa = 0; my $__dwb = 0; my $__dwc = 0; my %__dwd = (); my $__dwe = ""; my $__dwf = 0; my @__dwg = (); if (!$__dyc && !$__dyd) { if (!$__dyb && !$authlib9_15_4::_alc) { push @__dwg, ["sys_RespNum", "* Respondent Number"]; } push @__dwg, ["sys_DispositionCode", "[Disposition Code]"]; push @__dwg, ["sys_ScreenWidth", "[Screen Width]"]; authlib9_15_4::_yo(); if ($authlib9_15_4::_alg) { if (exists $authlib9_15_4::_alg->{'_ju'}) { my $__dwh = $authlib9_15_4::_alg->{'_ju'}; if (exists $__dwh->{'_jt'}) { my @__dwi = @{$__dwh->{'_jt'}}; my $__dwh = 0; foreach $__dwh (@__dwi) { if ($__dwh->{'_pj'} eq "numeric" || !$__dyb) { push @__dwg, [$__dwh->{'_if'}, ""]; } } } if (exists $__dwh->{'_w'}) { my @__dwj = @{$__dwh->{'_w'}}; my $__dwk = 0; foreach $__dwk (@__dwj) { if ($__dwk->{'_pj'} eq "numeric" || !$__dyb) { push @__dwg, [$__dwk->{'_if'}, ""]; } } } } if (exists $authlib9_15_4::_alg->{'_jr'}) { my $__dwl = $authlib9_15_4::_alg->{'_jr'}; my $__dwm = 0; foreach $__dwm (@{$__dwl}) { if ($__dwm->{'_pj'} eq "numeric" || !$__dyb) { push @__dwg, [$__dwm->{'_if'}, ""]; } } } } } my $__dwn = 1; my $__dwo = 0; my %__dwp = (); my $__dwq = ""; while ($__dwn <= $__dvo) { $__dwq = ""; $__dvq = $authlib9_15_4::_akw->[$__dwn - 1]; if (exists $__dvq->{'_hm'}) { authlib9_15_4::_adt(); my @__dwr = (); foreach my $__dws (@{$__dvq->{'_hm'}}) { if (not exists $__dwp{$__dws}) { my %__dwt = (); $__dwt{'_fz'} = 1; $__dwt{'_ho'} = @{authlib9_15_4::_ade($authlib9_15_4::_amm->{$__dws}->{'_hj'})}; $__dwt{'_v'} = $authlib9_15_4::_amm->{$__dws}->{'_v'}; $__dwp{$__dws} = \%__dwt; } unshift @__dwr, $__dwp{$__dws}->{'_fz'}; } $__dwq = "." . join(".", @__dwr); } $__dvp = $__dvq->{'_ld'}; $__dvs = @{$__dvp}; for ($__dvu = 0; $__dvu < $__dvs; $__dvu++) { $__dvr = $__dvp->[$__dvu]; $__dvw = $__dvr->{'_iz'}; $__dvz = $__dvr->{'_if'}; $__dwa = $__dvr->{'_pj'}; if ($__dyc || $__dyd) { if ($__dyd || ($__dyc && $__dwa != &authlib9_15_4::_ANR)) { _aeh(\@__dwg, $__dvz, $__dwq); } } else { if (!$__dyb && $__dwa == &authlib9_15_4::_ANO) { seek $authlib9_15_4::_ajs, ($__dvw), 0; my $__dwu = authlib9_15_4::_zj(0); if ($__dwu->{'_pj'} eq "check") { $__dvx = authlib9_15_4::_acz($__dwu->{'_hj'}); if ($__dvx && exists($__dvx->{'_jq'})) { $__dvx = authlib9_15_4::_acz($__dvx->{'_jq'}); } if ($__dvx && exists($__dvx->{'_gk'})) { $__dwb = @{$__dvx->{'_gk'}}; } for ($__dvv = 0; $__dvv < $__dwb; $__dvv++) { _aeh(\@__dwg, $__dvz . "_" . $__dvx->{'_gk'}->[$__dvv]->{'_pt'}, $__dwq); } } else { _aeh(\@__dwg, $__dvz, $__dwq); } } elsif ($__dwa == &authlib9_15_4::_ANT) { my $__dwv = 1; my $__dww = 0; my $__dwx = 0; if ($__dvz =~ m/_Rating(\d+)/i) { $__dwv = $1; } my $__dwy = authlib9_15_4::_za($__dvz, 1); my $__dwz = $__dwy->{'_ae'}; $__dww = @{$__dwz->[$__dwv - 1]->{'_hf'}}; for ($__dwx = 1; $__dwx <= $__dww; $__dwx++) { _aeh(\@__dwg, $__dvz . "_" . $__dwx, $__dwq); } } elsif ($__dwa == &authlib9_15_4::_ANY) { seek $authlib9_15_4::_ajs, ($__dvw), 0; my $__dxa = authlib9_15_4::_zj(0); if (exists $__dxa->{'_df'}) { my $__dxb = $__dxa->{'_cv'}; if (exists($__dxa->{'_ph'})) { $__dxb++; } for ($__dvv = 1; $__dvv <= $__dxb; $__dvv++) { _aeh(\@__dwg, $__dvz . "_" . $__dvv, $__dwq); } } elsif (exists $__dxa->{'_aw'}) { _aeh(\@__dwg, $__dvz . "_b", $__dwq); _aeh(\@__dwg, $__dvz . "_w", $__dwq); } else { _aeh(\@__dwg, $__dvz, $__dwq); } if (exists $__dxa->{'_eh'}) { _aeh(\@__dwg, $__dvz . "_none", $__dwq); } } elsif ($__dwa == &authlib9_15_4::_ANZ) { seek $authlib9_15_4::_ajs, ($__dvw), 0; my $__dxc = authlib9_15_4::_zj(0); my $__dxd = $__dxc->{'_pv'}; my $__dxe = @{$__dxd}; my $__dxf = 0; for ($__dvv = 0; $__dvv < $__dxe; $__dvv++) { $__dxf = $__dxd->[$__dvv]; if (ref($__dxf) eq "OpenEndVar" && $__dyb) { } else { if (ref($__dxf) eq "CheckVar") { my $__dxg = $__dxf->{'_iy'}; for ($__dwc = 1; $__dwc <= $__dxg; $__dwc++) { _aeh(\@__dwg, $__dxf->{'_if'} . "_" . $__dwc, $__dwq); } } else { _aeh(\@__dwg, $__dxf->{'_if'}, $__dwq); } } } } elsif ($__dwa == &authlib9_15_4::_AOA) { seek $authlib9_15_4::_ajs, ($__dvw), 0; my $__dxh = authlib9_15_4::_zj(0); my $__dxi = 0; my $__dxj = $__dxh->{'_pv'}; my $__dxk = @{$__dxj}; my $__dxf = 0; my $__dxl = ""; my $__dxm = $__dxh->{'_pu'}; for ($__dvv = 0; $__dvv < $__dxk; $__dvv++) { $__dxf = $__dxj->[$__dvv]; if (ref($__dxf) eq "RadioVar") { _aeh(\@__dwg, $__dxf->{'_if'}, $__dwq); } elsif (ref($__dxf) eq "CheckVar" && $__dyb) { $__dxl = $__dxf->{'_if'}; if ($__dxm eq "rows") { $__dxl .= "_c*"; } else { $__dxl =~ s/(_c\d+)/_r\*$1/; } _aeh(\@__dwg, $__dxl, $__dwq); } elsif (ref($__dxf) eq "OpenEndVar" && $__dyb) { } else { if ($__dxm eq "rows") { $__dvx = authlib9_15_4::_acz($__dxh->{'_co'}); } else { $__dvx = authlib9_15_4::_acz($__dxh->{'_mw'}); } if ($__dvx && exists($__dvx->{'_jq'})) { $__dvx = authlib9_15_4::_acz($__dvx->{'_jq'}); } if ($__dvx && exists($__dvx->{'_gk'})) { $__dwb = @{$__dvx->{'_gk'}}; } for ($__dwc = 1; $__dwc <= $__dwb; $__dwc++) { $__dxl = $__dxf->{'_if'}; if ($__dxm eq "rows") { $__dxl .= "_c" . $__dwc; } else { $__dxl =~ s/(_c\d+)/_r$__dwc$1/; } _aeh(\@__dwg, $__dxl, $__dwq); } } } } elsif ($__dwa == &authlib9_15_4::_AOB || $__dwa == &authlib9_15_4::_AOC) { seek $authlib9_15_4::_ajs, ($__dvw), 0; my $__dxn = authlib9_15_4::_zj(0); $__dvx = authlib9_15_4::_acz($__dxn->{'_hj'}); if ($__dvx && exists($__dvx->{'_jq'})) { $__dvx = authlib9_15_4::_acz($__dvx->{'_jq'}); } if ($__dvx && exists $__dvx->{'_gk'}) { $__dwb = @{$__dvx->{'_gk'}}; } for ($__dwc = 1; $__dwc <= $__dwb; $__dwc++) { _aeh(\@__dwg, $__dvz . "_" . $__dwc, $__dwq); } } elsif ($__dwa == &authlib9_15_4::_AOE) { $__dwe = $__dvz; if ($__dyb) { $__dwe =~ s/_\d+//; if (!exists $__dwd{$__dwe}) { $__dwd{$__dwe} = $__dwe; } } else { seek $authlib9_15_4::_ajs, $__dvw, 0; my $__dxo = authlib9_15_4::_zj(0); push @__dwg, [$__dwe . "_b", ""]; if (!exists $__dxo->{'_au'}) { _aeh(\@__dwg, $__dwe . "_w", $__dwq); } } } elsif ($__dwa == &authlib9_15_4::_AOG) { my $__dxp = authlib9_15_4::_aap($__dvz); my $__dxq = authlib9_15_4::_ade($__dxp->{'_ac'}); my $__dxr = @{$__dxq}; my $__dwv = 0; for ($__dvv = 0; $__dvv < $__dxr; $__dvv++) { $__dwv = $__dxq->[$__dvv]->{'_pt'}; if (exists $__dxp->{'_ad'}->{$__dwv} && exists $__dxp->{'_ad'}->{$__dwv}->{'_me'}) { next; } else { _aeh(\@__dwg, $__dvz . "_" . $__dwv, $__dwq); } } } elsif ($__dwa == &authlib9_15_4::_AOH) { if ($__dyb) { if ($__dvz =~ m/(.*?_Screener)1$/i) { } } } elsif (!$__dyb && $__dwa == &authlib9_15_4::_AOI) { } elsif (!$__dyb && $__dwa == &authlib9_15_4::_AOJ) { } elsif ($__dwa == &authlib9_15_4::_AOK) { if ($__dyb) { if ($__dvz =~ m/(.*?_ChoiceTask)1$/i) { } } } elsif ($__dwa == &authlib9_15_4::_AOL) { _aeh(\@__dwg, $__dvz, $__dwq); } elsif ($__dwa == &authlib9_15_4::_AOM) { seek $authlib9_15_4::_ajs, ($__dvw), 0; my $__dxs = authlib9_15_4::_zj(0); $__dvx = authlib9_15_4::_acz($__dxs->{'_hj'}); if ($__dvx && exists($__dvx->{'_jq'})) { $__dvx = authlib9_15_4::_acz($__dvx->{'_jq'}); } if ($__dvx && exists($__dvx->{'_gk'})) { $__dwb = @{$__dvx->{'_gk'}}; } for ($__dwc = 1; $__dwc <= $__dwb; $__dwc++) { _aeh(\@__dwg, $__dvz . "_" . $__dwc, $__dwq); } } else { if (($__dwa == &authlib9_15_4::_ANR || $__dwa == &authlib9_15_4::_ANS || $__dwa == &authlib9_15_4::_AOD) || ($__dyb && ($__dwa == &authlib9_15_4::_ANQ || $__dwa == &authlib9_15_4::_ANX || $__dwa == &authlib9_15_4::_AOI || $__dwa == &authlib9_15_4::_AOJ || $__dwa == &authlib9_15_4::_ANU || $__dwa == &authlib9_15_4::_ANV || $__dwa == &authlib9_15_4::_ANW ))) { } else { _aeh(\@__dwg, $__dvz, $__dwq); } } } } $__dwn++; $__dwo = 0; if ($__dwn <= $__dvo) { $__dwo = $authlib9_15_4::_akw->[$__dwn - 1]; } if (exists $__dvq->{'_hm'}) { my $__dxt = $__dvq->{'_hm'}; my %__dxu = (); my $__dxv = 0; if ($__dwo) { if (exists $__dwo->{'_hm'}) { %__dxu = map { $_ => 1 } @{$__dwo->{'_hm'}}; } } foreach my $__dws (@{$__dxt}) { if (not exists $__dxu{$__dws}) { if (exists $__dwp{$__dws}) { $__dxv = $__dwp{$__dws}->{'_fz'}; $__dxv++; if ($__dxv <= $__dwp{$__dws}->{'_ho'}) { $__dwn = $__dwp{$__dws}->{'_v'}->[0]; $__dwp{$__dws}->{'_fz'} = $__dxv; last; } else { delete $__dwp{$__dws}; } } } } } } my @__dxw = (); if (!$__dyd) { my $__dxx = 0; my $__dxy = ""; my $__dxz = ""; my $__dya = 0; foreach $__dxx (@__dwg) { $__dya = 0; $__dxy = $__dxx->[0]; $__dxz = $__dxx->[1]; if ($__dye) { $__dvn .= _aei($__dxy, $__dxz, "", $__dya); } else { $__dvn .= _ael($__dxy, $__dxz, $__dyg, $__dyh); } } } return ($__dvn, \@__dwg, \@__dxw); } sub _aeh { my ($__dyi, $__dyj, $__dyk) = @_; push @{$__dyi}, [$__dyj . $__dyk, ""]; } sub _aei { my ($__dyn, $__dyo, $__dyp, $__dyq) = @_; if ($__dyo eq "") { $__dyo = $__dyn; } my $__dyl = ""; if ($__dyq) { $__dyl = " checked "; } my $__dym = ""; $__dym .= "<div class=\"row checkbox_control\" data-name=\"" . _aek($__dyn) . "\" data-value=\""; if ($__dyq) { $__dym .= "checked"; } $__dym .= "\"><div class=\"col graphical_select checkbox_unselected\"></div>"; $__dym .= "<div class=\"col label_cell\"><label>" . $__dyo . "</label></div></div>"; return $__dym; } sub _aej { my ($__dys, $__dyt) = @_; my $__dyr = ""; $__dyr .= "<div class=\"checkbox_group\">\n"; $__dyr .= "<input class=\"checkbox_input\" type=\"hidden\" name=\"" . $__dyt . "\" id=\"" . $__dyt . "\" value=\""; if (exists $authlib9_15_4::_akv{$__dyt}) { $__dyr .= $authlib9_15_4::_akv{$__dyt}; } $__dyr .= "\">"; $__dyr .= "<div class=\"row checkbox_control check_all\" data-value=\"\">\n"; $__dyr .= "<div class=\"col graphical_select checkbox_unselected\"></div>\n"; $__dyr .= "<div class=\"col label_cell\"><label>Select All</label></div>\n"; $__dyr .= "</div>\n"; $__dyr .= $__dys; $__dyr .= "</div>"; return $__dyr; } sub _aek { my ($__dyu) = @_; $__dyu =~ s/"/\\"/g; return $__dyu; } sub _ael { my ($__dyx, $__dyy, $__dyz, $__dza) = @_; if ($__dyy eq "") { $__dyy = $__dyx; } my $__dyv = _aem($__dyx); if ($__dyz) { $__dyv = "test_" . $__dyv; } my $__dyw = "<option id=\"" . $__dyv . "\" value=\"" . $__dyx . "\""; if ($__dza && $__dza eq $__dyx) { $__dyw .= " selected "; } $__dyw .= ">" . $__dyy . "</option>\n"; return $__dyw; } sub _aem { my ($__dzb) = @_; $__dzb =~ s/\*/XSTARX/g; $__dzb =~ s/\./XDOTX/g; return $__dzb; } sub _aen { my ($__dze) = @_; my $__dzc = $authlib9_15_4::_akv{"hid_respnum"}; my ($__dzf, $__dzg, $__dzh) = authlib9_15_4::_abu($__dze); my @__dzd = @{authlib9_15_4::_xy($__dzc, {"quest_name" => $__dzf . $__dzh, "limbo" => 0})}; if (@__dzd) { return 1; } else { return 0; } } sub _aeo { return "test_" . $authlib9_15_4::_ako; } sub _aep { my $__dzi = 0; if ($authlib9_15_4::_akq eq _aeo()) { $__dzi = 1; } return $__dzi; } sub _aeq { my ($__dzm) = @_; my $__dzj = ""; if ($__dzm) { my @__dzk = gmtime($__dzm - (5*60*60)); my $__dzl = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec")[$__dzk[4]]; $__dzj = sprintf("%d %s %d - %d:%02d:%02d", $__dzk[3],$__dzl,($__dzk[5]+1900),$__dzk[2],$__dzk[1],$__dzk[0]); $__dzj .= " EST"; } return $__dzj; } sub _aer { my ($__dzp, $__dzq) = @_; my $__dzn = ""; eval { require "DateTime.pm"; if ($__dzp && $__dzq) { my $__dzo = DateTime->from_epoch( epoch => ($__dzp), time_zone => $__dzq ); $__dzn = $__dzo->strftime("%d %b %Y - %T %Z"); } elsif ($__dzp) { $__dzn = _aeq($__dzp); } }; if ($@) { $__dzn = _aeq($__dzp); } return $__dzn; } sub _aes { my ($__dzy) = @_; my $__dzr = 0; my $__dzs = ""; my $__dzt = 0; my $__dzu = ""; my $__dzv = 0; my $__dzw = ""; my $__dzx = 0; $__dzr = int($__dzy / 3600); $__dzx = $__dzy - ($__dzr*3600); $__dzt = int($__dzx / 60); $__dzx = $__dzx - ($__dzt*60); $__dzv = int($__dzx); $__dzs = sprintf("%01d", $__dzr); $__dzu = sprintf("%01d", $__dzt); $__dzw = sprintf("%01d", $__dzv); return $__dzs . "h " . $__dzu . "m " . $__dzw . "s"; } sub _aet { my $__dzz = 0; if (exists $authlib9_15_4::_akv{"hid_screenwidth"}) { my $__eaa = $authlib9_15_4::_akv{"hid_screenwidth"}; if ($__eaa =~ m/^(\d+)$/) { $__dzz = $1; } } elsif ($authlib9_15_4::_amo == &authlib9_15_4::_APG || $authlib9_15_4::_amo == &authlib9_15_4::_APH) { $__dzz = 2000; } else { $__dzz = authlib9_15_4::_ws("sys_ScreenWidth"); } return $__dzz; } sub _aeu { my $__eab = _aet(); my $__eac = 0; if ($__eab && $__eab <= 800) { $__eac = 1; } return $__eac; } sub _aev { my $__ead = 0; if (($authlib9_15_4::_amo != &authlib9_15_4::_APG) && ($authlib9_15_4::_amo != &authlib9_15_4::_APH)) { $__ead = 1; } return $__ead; } sub _aew { my ($__eag, $__eah, $__eai) = @_; my $__eae = "$authlib9_15_4::_akq\_data1"; $__eai->{$__eae} = 1; $__eag .= join(", ", map { "`$_`" } sort keys %{$__eai}); if (@{$__eah}) { foreach my $__eaf (sort keys %{$__eai}) { if ($__eae ne $__eaf) { push @{$__eah}, "`$__eae`.`sys_RespNum` = `$__eaf`.`sys_RespNum`"; } } $__eag .= " WHERE " . join(" AND ", @{$__eah}); } return $__eag; } sub _aex { my ($__eal, $__eam) = @_; my ($__ean, $__eao) = authlib9_15_4::_xk("sys_RespRemoved"); my $__eaj = "$authlib9_15_4::_akq\_data$__ean"; $__eal->{$__eaj} = 1; my $__eak = "((`$__eaj`.`sys_RespRemoved` IS NULL) OR (`$__eaj`.`sys_RespRemoved` = 0))"; if (!$__eam) { $__eak = "(`$__eaj`.`sys_RespRemoved` = 1)"; } return $__eak; } return 1; 
package SSIWebParseBrowser;

my %lang =
(
    'en' => 'English',
    'de' => 'German',
    'fr' => 'French',
    'es' => 'Spanish',
    'it' => 'Italian',
    'da' => 'Danish',
    'ja' => 'Japanese',
    'ru' => 'Russian',
);
my $langRE = join('|', keys %lang);

my %name_map =
(
    'Mozilla'   => 'Netscape',
    'Gecko'     => 'Mozilla',
    'Netscape6' => 'Netscape',
    'MSIE'      => 'Internet Explorer',
);

sub new {
    my $class   = shift;
    my $browser = {};
    bless $browser, ref $class || $class;
    $browser->Parse(shift);
    return $browser;
}

sub Parse {
    my $browser   = shift;
    my $ua_string = shift;
    my $useragent = $ua_string;
    my $version;
    delete $browser->{$_} for keys %{$browser};
    return undef unless $useragent;
    return undef if $useragent eq '-';
    $browser->{user_agent} = $useragent;
    $useragent =~ s/Opera (?=\d)/Opera\//i;

    while ($useragent =~ s/\[(\w+)\]//) {
        push @{$browser->{languages}}, $lang{$1} || $1;
        push @{$browser->{langs}}, $1;
    }

    while ($useragent =~ /\((.*?)\)/) {
        $browser->{detail} .= '; ' if defined($browser->{detail});
        $browser->{detail} .= $1;
        $useragent =~ s/\((.*?)\)//;
    }
    if (defined($browser->{detail})) {
        $browser->{properties} = [split /;\s+/, $browser->{detail}];
    }

    $browser->{useragents} = [grep /\//, split /\s+/, $useragent];

    if ($ua_string =~ /(iPhone|iPad|iPod).*?OS\s+(\d_\d(_\d)?)/) {
        $browser->{name} = 'Safari';
        $browser->{os} = $browser->{ostype} = 'iOS';
        ($browser->{osvers} = $2) =~ s/_/./g;
        if ($useragent =~ m!(Version|CriOS)/((\d+)(\.(\d+)[\.0-9]*)?)!) {
            if ($1 eq 'CriOS') {
                $browser->{name} = 'Chrome';
            }
            $browser->{version}->{v}     = $2;
            $browser->{version}->{major} = $3;
            $browser->{version}->{minor} = $5 if defined($5) && $5 ne '';
        }
    }
    elsif ($ua_string =~ m!\((BlackBerry|BB10).*Version/([0-9\.]+)!) {
        my $version_string = $2;
        $browser->{name} = $browser->{ostype} = 'BlackBerry';
        $browser->{version}->{v} = $version_string;
        if ($version_string =~ m!^([0-9]+)(\.([0-9]+).*)?!) {
            $browser->{version}->{major} = $browser->{osvers} = $1;
            $browser->{os}               = "BlackBerry $1";
            $browser->{version}->{minor} = $3 if defined($3) && $3 ne '';
        }
    }
    elsif ($ua_string =~ m!Mozilla/5.0 \(.*?Windows.*?; rv:((\d+)\.(\d+))\) like Gecko!) {
        $browser->{name} = 'MSIE';
        $browser->{version}->{v} = $1;
        $browser->{version}->{major} = $2;
        $browser->{version}->{minor} = $3;
    } elsif ($useragent =~ m!OPR/((\d+)\.(\d+)\.\d+\.\d+)!) {
        $browser->{name}             = 'Opera';
        $browser->{version}->{v}     = $1;
        $browser->{version}->{major} = $2;
        $browser->{version}->{minor} = $3;
    } elsif ($useragent =~ m!\bVersion/((\d+)\.(\d+)\S*) Safari/!) {
        $browser->{name}             = 'Safari';
        $browser->{version}->{v}     = $1;
        $browser->{version}->{major} = $2;
        $browser->{version}->{minor} = $3;
    } elsif ($useragent =~ m!Opera/.*Version/((\d+)\.(\d+)\S*)$!) {
        $browser->{name}             = 'Opera';
        $browser->{version}->{v}     = $1;
        $browser->{version}->{major} = $2;
        $browser->{version}->{minor} = $3;
    } else {
        my $seenchrome = 0;
        for (@{$browser->{useragents}}) {
            my ($br, $ver) = split /\//;
            $br = 'Chrome' if $br eq 'CriOS';
            if ($br ne 'Safari' || not $seenchrome) {
                $browser->{name} = $br;
                $browser->{version}->{v} = $ver;
                if ($ver =~ m!^v?(\d+)\.(\d+)!) {
                    ($browser->{version}->{major}, $browser->{version}->{minor}) = ($1, $2);
                }
            }
            $seenchrome = 1 if lc($br) eq 'chrome';
            last if lc($br) eq 'iron';
            last if lc($br) eq 'lynx';

            last if lc($br) eq 'opera';
        }
    }

    for (@{$browser->{properties}}) {
        /compatible/i and next;

        unless (defined($browser->{name}) && (lc($browser->{name}) eq 'webtv' || lc($browser->{name}) eq 'opera')) {
            /^MSIE (.*)$/ and do {
                $browser->{name} = 'MSIE';
                $browser->{version}->{v} = $1;
                ($browser->{version}->{major},
                $browser->{version}->{minor}) = split /\./, $1, 2;
            };
        }

        m!^Edge/(([0-9]+)\.([0-9]+))! and do {
            $browser->{name} = 'Edge';
            $browser->{version}->{v} = $1;
            $browser->{version}->{major} = $2;
            $browser->{version}->{minor} = $3;
        };

        if (m!^AOL ([0-9].*)!) {
            $browser->{name} = 'AOL';
            $browser->{version}->{v} = $1;
            ($browser->{version}->{major}, $browser->{version}->{minor}) = split /\./, $browser->{version}->{v};
        }

        /^Konqueror\/([-0-9.a-z]+)/ and do {
            $browser->{name} = 'Konqueror';
            $browser->{version}->{v} = $1;
            ($browser->{version}->{major}, $browser->{version}->{minor}) = split /\./, $browser->{version}->{v};
        };

        /\bCamino\/([0-9.]+)/ and do {
            $browser->{name} = 'Camino';
            $browser->{version}->{v} = $1;
            ($browser->{version}->{major}, $browser->{version}->{minor}) = split /\./, $browser->{version}->{v}, 2;
        } and last;

        if (m!^Opera Mini/([0-9.]+)!) {
            $browser->{name} = 'Opera Mini';
            $browser->{version}->{v} = $1;
            ($browser->{version}->{major}, $browser->{version}->{minor}) = split /\./, $browser->{version}->{v};
        }

        if (/^Win/) {
            $browser->{os} = $_;
            $browser->{ostype} = 'Windows';
            if (/Windows NT\s*((\d+)(\.\d+)?)/ || /^WinNT((\d+)(\.\d+)?)/) {
                $browser->{ostype} = 'Windows NT';
                $version = $1;
                if ($version >= 10) {
                    $browser->{osvers} = '10';
                }
                elsif ($version >= 6.3 && $version < 7) {
                    $browser->{osvers} = '8.1';
                } elsif ($version >= 6.2) {
                    $browser->{osvers} = '8';
                } elsif ($version >= 6.1) {
                    $browser->{osvers} = '7';
                } elsif ($version >= 6.06) {
                    $browser->{osvers} = 'Server 2008';
                } elsif ($version >= 6.0) {
                    $browser->{osvers} = 'Vista';
                } elsif ($version >= 5.1) {
                    $browser->{osvers} = 'XP';
                } elsif ($version >= 5.0) {
                    $browser->{osvers} = '2000';
                } else {
                    $browser->{osvers} = $version;
                }
            }
            elsif (/Windows (\d+(\.\d+)?)/) {
                $browser->{osvers} = $1;
            } elsif (/Win(\w\w)/i) {
                $browser->{osvers} = $1;
            }
        }

        if (/^Mac/) {
            $browser->{os} = $_;
            $browser->{ostype} = 'Macintosh';
            (undef, $browser->{osvers}) = split /[ _]/, $_, 2;
        }

        if (/^PPC$/) {
            $browser->{osarc} = 'PPC';
        }

        if (/Android\s([\.0-9]+)/) {
            $browser->{os}     = 'Android';
            $browser->{ostype} = 'Linux';
            $browser->{osvers} = $1;
        } elsif (/^Linux/) {
            my $lstr = $_;
            $browser->{os}     = 'Linux';
            $browser->{ostype} = 'Linux';
            if ($lstr =~ s/(i386|mips|amd64|sparc64|ppc|i686|i586|armv51|x86|x86-64|x86_64|ppc64|x64|x64_64)\b//) {
                $browser->{osarc} = $1;
            }
            if ($lstr =~ / (\d+\.\S+)/) {
                $browser->{osvers} = $1;
            }
        }

        if (/^(SunOS|Solaris)/i) {
            $browser->{os} = $_;
            $browser->{ostype} = 'Solaris';
            if (/(sun4[a-z]|i86pc)/) {
                $browser->{osarc} = $1;
            }
            if (/^SunOS\s*([0-9\.]+)/) {
                $browser->{osvers} = $1;
            }
        }

        if (/^($langRE)-/ || /^($langRE)$/) {
            my $langCode = $1;
            push(@{$browser->{languages}}, $lang{$langCode});
            push(@{$browser->{langs}}, $langCode);
        }
    }

    if (defined($browser->{name}) && exists $name_map{ $browser->{name} }) {
        $browser->{name} = $name_map{ $browser->{name} };
    }

    $browser->{name} ||= $useragent;

    if ($browser->{name} eq 'Konqueror') {
        $browser->{ostype} ||= 'Linux';
    }

    my %langs_in;

    for (@{$browser->{langs}}) {
        $langs_in{$_}++;
    }

    if (int(keys %langs_in) > 0) {
        ($browser->{lang}) = sort {$langs_in{$a} <=> $langs_in{$b}} keys %langs_in;
        $browser->{language} = $lang{$browser->{lang}} || $browser->{lang};

    }

    my $strOriginalUserAgent = $browser->{user_agent};

    if (exists $browser->{os})
    {
        my $strOS = $browser->{os};

        if ($strOriginalUserAgent =~ m/(Windows Phone)\s+([^);]*)/i)
        {
            $strOS = $1;
            $browser->{osvers} = $2;
        }
        else
        {
            if ($strOS =~ m/Win(?>NT-(?>EV|A|PA)|TSI|dows-Media-Player|64)/i)
            {
                if ($strOriginalUserAgent =~ m/(Windows\s+NT\s+\d+\.\d+)/i)
                {
                    $strOS = $1;
                    $strOS =~ s/NT 5\.1/XP/i;
                    $strOS =~ s/NT 5\.2/XP/i;
                    $strOS =~ s/NT 6\.0/Vista/i;
                    $strOS =~ s/NT 6\.1/7/i;
                    $strOS =~ s/NT 6\.2/8/i;
                    $strOS =~ s/NT 6\.3/8.1/i;
                    $strOS =~ s/NT 10/10/i;

                    $browser->{osvers} = "";
                }
            }
            if ($strOS =~ m/NT/)
            {
                $strOS =~ s/NT 5\.0/2000/i;
                $strOS =~ s/NT 5\.1/XP/i;
                $strOS =~ s/NT 5\.2/XP/i;
                $strOS =~ s/NT 6\.0/Vista/i;
                $strOS =~ s/NT 6\.1/7/i;
                $strOS =~ s/NT 6\.2/8/i;
                $strOS =~ s/NT 6\.3/8.1/i;
                $strOS =~ s/NT 10/10/i;

                $browser->{osvers} = "";
            }
            elsif ($strOS =~ m/9x\s+[\d.]+/i)
            {
                $strOS = "Windows ME";

                $browser->{osvers} = "";
            }
            elsif ($strOS =~ m/Macintosh/i)
            {
                if ($strOriginalUserAgent =~ m/(Mac\s+[^);]*)/i)
                {
                    $strOS = $1;
                    $strOS =~ s/_/\./g;
                }
            }

            elsif ($strOS =~ m/Mac/i)
            {
                if ($strOriginalUserAgent =~ m/(Mac\s+.*?);/i)
                {
                    $strOS = $1;
                    $strOS =~ s/_/\./g;
                }
            }
            elsif ($strOS =~ m/Linux/i)
            {
                if ($strOriginalUserAgent =~ m/(Ubuntu(?:\/\d+(?:\.\d+)*))/i)
                {
                    $strOS = $1;
                }
            }
        }

        $browser->{os} = $strOS;
    }
    else
    {
        if ($strOriginalUserAgent =~ m/CrOS/i)
        {
            $browser->{os} = 'Chrome OS';
        }
    }

    return $browser;
}

1;




























package lite;
require 5.002;











$lite::VERSION = '2.0';




sub new
{
    my $self;

    $self = {
            multipart_dir    =>    undef,
            default_dir      =>    '/tmp',
            file_type        =>    'name',
            platform         =>    'Unix',
            buffer_size      =>    1024,
            timestamp        =>    1,
        filter           =>    undef,
            web_data         =>    {},
        ordered_keys     =>    [],
        all_handles      =>    [],
            error_status     =>    0,
            error_message    =>    undef,
        file_size_limit     =>    2097152,
        };

    $self->{convert} = {
                       'text/html'    => 1,
                       'text/plain'   => 1
                   };

    $self->{file} = { Unix => '/',    Mac => ':',    PC => '\\'       };
    $self->{eol}  = { Unix => "\012", Mac => "\015", PC => "\015\012" };

    bless $self;
    return $self;
}

sub Version
{
    return $lite::VERSION;
}

sub set_directory
{
    my ($self, $directory) = @_;

    stat ($directory);

    if ( (-d _) && (-e _) && (-r _) && (-w _) ) {
    $self->{multipart_dir} = $directory;
    return (1);

    } else {
    return (0);
    }
}

sub add_mime_type
{
    my ($self, $mime_type) = @_;

    $self->{convert}->{$mime_type} = 1 if ($mime_type);
}

sub remove_mime_type
{
    my ($self, $mime_type) = @_;

    if ($self->{convert}->{$mime_type}) {
    delete $self->{convert}->{$mime_type};
    return (1);

    } else {
    return (0);
    }
}

sub get_mime_types
{
    my $self = shift;

    return (sort keys %{ $self->{convert} });
}

sub set_platform
{
    my ($self, $platform) = @_;

    if ($platform =~ /(?:PC|NT|Windows(?:95)?|DOS)/i) {
        $self->{platform} = 'PC';

    } elsif ($platform =~ /Mac(?:intosh)?/i) {


        $self->{platform} = 'Mac';

    } else {
    $self->{platform} = 'Unix';
    }
}

sub set_file_type
{
    my ($self, $type) = @_;

    if ($type =~ /^handle$/i) {
    $self->{file_type} = 'handle';
    } else {
    $self->{file_type} = 'name';
    }
}

sub add_timestamp
{
    my ($self, $value) = @_;

    if ( ($value < 0) || ($value > 2) ) {
    $self->{timestamp} = 1;
    } else {
    $self->{timestamp} = $value;
    }
}

sub filter_filename
{
    my ($self, $subroutine) = @_;

    $self->{filter} = $subroutine;
}

sub set_buffer_size
{
    my ($self, $buffer_size) = @_;
    my $content_length;

    $content_length = $ENV{CONTENT_LENGTH} || return (0);

    if ($buffer_size < 256) {
    $self->{buffer_size} = 256;
    } elsif ($buffer_size > $content_length) {
    $self->{buffer_size} = $content_length;
    } else {
    $self->{buffer_size} = $buffer_size;
    }

    return ($self->{buffer_size});
}

sub parse_new_form_data


{
    my ($self, @param) = @_;

    $self->close_all_files();

    $self->{web_data}    = {};
    $self->{ordered_keys}     = [];
    $self->{all_handles}     = [];
    $self->{error_status}     = 0;
    $self->{error_message}     = undef;

    $self->parse_form_data(@param);
}

sub parse_form_data
{
    my ($self, $user_request) = @_;
    my ($request_method, $content_length, $content_type, $query_string,
    $boundary, $post_data, @query_input);

    $request_method = $user_request || $ENV{REQUEST_METHOD} || '';
    $content_length = $ENV{CONTENT_LENGTH};
    $content_type   = $ENV{CONTENT_TYPE};

    if ($request_method =~ /^(get|head)$/i) {

    $query_string = $ENV{QUERY_STRING};
    $self->_decode_url_encoded_data (\$query_string, 'form');

    return wantarray ?
        %{ $self->{web_data} } : $self->{web_data};

    } elsif ($request_method =~ /^post$/i) {

    if (!$content_type ||
        ($content_type eq 'application/x-www-form-urlencoded') ||
         $content_type eq 'application/x-www-form-urlencoded; charset=UTF-8') {

        local $^W = 0;

        read (STDIN, $post_data, $content_length);
        $self->_decode_url_encoded_data (\$post_data, 'form');

        return wantarray ?
        %{ $self->{web_data} } : $self->{web_data};

    } elsif ($content_type =~ /multipart\/form-data/) {
        ($boundary) = $content_type =~ /boundary=(\S+)$/;
        $self->_parse_multipart_data ($content_length, $boundary);

        return wantarray ?
        %{ $self->{web_data} } : $self->{web_data};

    } else {
        $self->_error ('Invalid content type!');
    }

    } else {





    print "[ Reading query from standard input. Press ^D to stop! ]\n";

    @query_input = <>;
    chomp (@query_input);

    $query_string = join ('&', @query_input);
    $query_string =~ s/\\(.)/sprintf ('%%%x', ord ($1))/eg;

    $self->_decode_url_encoded_data (\$query_string, 'form');

    return wantarray ?
        %{ $self->{web_data} } : $self->{web_data};
    }
}

sub parse_cookies
{
    my $self = shift;
    my $cookies;

    $cookies = $ENV{HTTP_COOKIE} || return;

    $self->_decode_url_encoded_data (\$cookies, 'cookies');

    return wantarray ?
        %{ $self->{web_data} } : $self->{web_data};
}

sub get_ordered_keys
{
    my $self = shift;

    return wantarray ?
    @{ $self->{ordered_keys} } : $self->{ordered_keys};
}

sub print_data
{
    my $self = shift;
    my ($key, $value, $eol);

    $eol = $self->{eol}->{$self->{platform}};

    foreach $key (@{ $self->{ordered_keys} }) {
    $value = $self->{web_data}->{$key};

    if (ref $value) {
        print "$key = @$value$eol";
    } else {
        print "$key = $value$eol";
    }
    }
}

sub print_mime_type
{
    my ($self, $field) = @_;

    return($self->{'mime_types'}->{$field});
}

*print_form_data = *print_cookie_data = \&print_data;

sub wrap_textarea
{
    my ($self, $string, $length) = @_;
    my ($new_string, $platform, $eol);

    $length     = 70 unless ($length);
    $platform   = $self->{platform};
    $eol        = $self->{eol}->{$platform};
    $new_string = $string || return;

    $new_string =~ s/[\0\r]\n?/ /sg;
    $new_string =~ s/(.{0,$length})\s/$1$eol/sg;

    return $new_string;
}

sub get_multiple_values
{
    my ($self, $array) = @_;

    return (ref $array) ? (@$array) : $array;
}

sub create_variables
{
    my ($self, $hash) = @_;
    my ($package, $key, $value);

    $package = $self->_determine_package;

    while (($key, $value) = each %$hash) {
    ${"$package\:\:$key"} = $value;
    }
}

sub is_error
{
    my $self = shift;

    if ($self->{error_status}) {
    return (1);
    } else {
    return (0);
    }
}

sub get_error_message
{
    my $self = shift;

    return $self->{error_message} if ($self->{error_message});
}

sub return_error
{
    my ($self, @messages) = @_;

    print "@messages\n";

    exit (1);
}




sub browser_escape
{
    my $string = shift;

    $string =~ s/([<&"#%>])/sprintf ('&#%d;', ord ($1))/ge;

    return $string;
}

sub url_encode
{
    my $string = shift;

    $string =~ s/([\x00-\x20"#%;<>?{}|\\\\^~`\[\]\x7F-\xFF])/
                 sprintf ('%%%x', ord ($1))/eg;

    return $string;
}




sub url_decode
{
    my $string = shift;

    $string =~ s/%([\da-fA-F]{2})/chr (hex ($1))/eg;

    return $string;
}

sub is_dangerous
{
    my $string = shift;

    if ($string =~ /[;<>\*\|`&\$!#\(\)\[\]\{\}:'"]/) {
        return (1);
    } else {
        return (0);
    }
}

sub escape_dangerous_chars
{
    my $string = shift;

    $string =~ s/([;<>\*\|`&\$!#\(\)\[\]\{\}:'"])/\\$1/g;

    return $string;
}




sub _error
{
    my ($self, $message) = @_;

    $self->{error_status}  = 1;
    $self->{error_message} = $message;
}

sub _determine_package
{
    my $self = shift;
    my ($frame, $this_package, $find_package);

    $frame = -1;
    ($this_package) = split (/=/, $self);

    do {
    $find_package = caller (++$frame);
    } until ($find_package !~ /^$this_package/);

    return ($find_package);
}




sub _decode_url_encoded_data
{
    my ($self, $reference_data, $type) = @_;
    my $code;

    $code = <<'End_of_URL_Decode';

    my (@key_value_pairs, $delimiter, $key_value, $key, $value);

    @key_value_pairs = ();

    return unless ($$reference_data);

    if ($type eq 'cookies') {
    $delimiter = ';\s+';
    } else {
    $delimiter = '&';
    }

    $$reference_data =~ tr/+/ /;
    @key_value_pairs = split (/$delimiter/, $$reference_data);

    foreach $key_value (@key_value_pairs) {
    ($key, $value) = split (/=/, $key_value, 2);

    $value = '' unless defined $value;

    $key   =~ s/%([\da-fA-F]{2})/chr (hex ($1))/eg;
    $value =~ s/%([\da-fA-F]{2})/chr (hex ($1))/eg;

    if ( defined ($self->{web_data}->{$key}) ) {
        $self->{web_data}->{$key} = [$self->{web_data}->{$key}]
            unless ( ref $self->{web_data}->{$key} );

        push (@{ $self->{web_data}->{$key} }, $value);
    } else {
        $self->{web_data}->{$key} = $value;
        push (@{ $self->{ordered_keys} }, $key);
    }
    }

End_of_URL_Decode

    eval ($code);
    $self->_error ($@) if $@;
}




sub _parse_multipart_data
{
    my ($self, $total_bytes, $boundary) = @_;
    my ($code, $files);

    local $^W = 0;
    $files    = {};

    $code = <<'End_of_Multipart';

    my ($seen, $buffer_size, $byte_count, $platform, $eol, $handle,
    $directory, $bytes_left, $buffer_size, $new_data, $old_data,
    $current_buffer, $changed, $store, $disposition, $headers,
        $mime_type, $convert, $field, $file, $new_name, $full_path);

    $seen        = {};
    $buffer_size = $self->{buffer_size};
    $byte_count  = 0;
    $platform    = $self->{platform};
    $eol         = $self->{eol}->{$platform};
    $handle      = 'CL00';
    $directory   = $self->{multipart_dir} || $self->{default_dir};

    while (1) {
    if ( ($byte_count < $total_bytes) &&
         (length ($current_buffer) < ($buffer_size * 2)) ) {

        $bytes_left  = $total_bytes - $byte_count;
        $buffer_size = $bytes_left if ($bytes_left < $buffer_size);

        read (STDIN, $new_data, $buffer_size);
            $self->_error ("Oh, Oh! I'm upset! Can't read what I want.")
        if (length ($new_data) != $buffer_size);

        $byte_count += $buffer_size;

        if ($old_data) {
        $current_buffer = join ('', $old_data, $new_data);
        } else {
        $current_buffer = $new_data;
        }

    } elsif ($old_data) {
        $current_buffer = $old_data;
        $old_data = undef;

    } else {
        last;
    }

    $changed = 0;







    if ($current_buffer =~
            /(.*?)(?:\015?\012)?-*$boundary-*[\015\012]*(?=(.*))/os) {

        ($store, $old_data) = ($1, $2);

            if ($current_buffer =~
             /[Cc]ontent-[Dd]isposition: ([^\015\012]+)\015?\012  # Disposition
              (?:([A-Za-z].*?)(?:\015?\012){2})?                  # Headers
              (?:\015?\012)?                                      # End
              (?=(.*))
             /xs) {

        ($disposition, $headers, $current_buffer) = ($1, $2, $3);
        $old_data = $current_buffer;

        ($mime_type) = $headers =~ /[Cc]ontent-[Tt]ype: (\S+)/;

        $self->_store ($platform, $file, $convert, $handle, $eol,
                   $field, \$store, $seen);

        close ($handle) if (fileno ($handle));

        if ($mime_type && $self->{convert}->{$mime_type}) {
            $convert = 1;
        } else {
            $convert = 0;
        }

        $changed = 1;

        ($field) = $disposition =~ /name="([^"]+)"/;
        ++$seen->{$field};

        $self->{'mime_types'}->{$field} = $mime_type;

                if ($seen->{$field} > 1) {
                    $self->{web_data}->{$field} = [$self->{web_data}->{$field}]
                        unless (ref $self->{web_data}->{$field});
                } else {
                    push (@{ $self->{ordered_keys} }, $field);
                }

                if (($file) = $disposition =~ /filename="(.*)"/) {
                    $file =~ s|.*[:/\\](.*)|$1|;

                    $new_name = $self->_get_file_name ($platform,
                                                       $directory, $file);

                    $self->{web_data}->{$field} = $new_name;

                    $full_path = join ($self->{file}->{$platform},
                                       $directory, $new_name);

                    open (++$handle, ">$full_path")
                    || $self->_error ("Can't create file: $full_path!");

                    $files->{$new_name} = $full_path;
                }
            }

    } elsif ($old_data) {
            $store    = $old_data;
            $old_data = $new_data;

    } else {
        $store          = $current_buffer;
            $current_buffer = $new_data;
        }

        unless ($changed) {
           $self->_store ($platform, $file, $convert, $handle, $eol,
                          $field, \$store, $seen);
        }
    }

    close ($handle) if (fileno ($handle));

End_of_Multipart

    eval ($code);
    $self->_error ($@) if $@;

    $self->_create_handles ($files) if ($self->{file_type} eq 'handle');
}

sub _store
{
    my ($self, $platform, $file, $convert, $handle, $eol, $field,
    $info, $seen) = @_;

    if ($file) {
    if ($convert) {
        $$info =~ s/\015\012/$eol/og  if ($platform ne 'PC');
        $$info =~ s/\015/$eol/og      if ($platform ne 'Mac');
        $$info =~ s/\012/$eol/og      if ($platform ne 'Unix');
    }

        print $handle $$info;

    } elsif ($field) {
    if ($seen->{$field} > 1) {
        $self->{web_data}->{$field}->[$seen->{$field}-1] .= $$info;
    } else {
        $self->{web_data}->{$field} .= $$info;
        }
    }
}

sub _get_file_name
{
    my ($self, $platform, $directory, $file) = @_;
    my ($filtered_name, $filename, $timestamp, $path);

    $filtered_name = &{ $self->{filter} }($file)
        if (ref ($self->{filter}) eq 'CODE');

    $filename  = $filtered_name || $file;
    $timestamp = time . '__' . $filename;

    if (!$self->{timestamp}) {
    return $filename;

    } elsif ($self->{timestamp} == 1) {
    return $timestamp;

    } elsif ($self->{timestamp} == 2) {
    $path = join ($self->{file}->{$platform}, $directory, $filename);

    return (-e $path) ? $timestamp : $filename;
    }
}

sub _create_handles
{
    my ($self, $files) = @_;
    my ($package, $handle, $name, $path);

    $package = $self->_determine_package;

    while (($name, $path) = each %$files) {
    $handle = "$package\:\:$name";
    open ($handle, "<$path")
            || $self->_error ("Can't read file: $path!");

    push (@{ $self->{all_handles} }, $handle);
    }
}

sub close_all_files
{
    my $self = shift;
    my $handle;

    foreach $handle (@{ $self->{all_handles} }) {
    close $handle;
    }
}

1;


package htmlentity;

%htmlentity::subst;
@htmlentity::multibyte = ();
$htmlentity::multibytecnt = 0;

sub encode
{
    return undef unless defined $_[0];

    my ($str) = @_;
    return $str if(isHtmlSafe($str));
    my $char2entity = {
        '>' => '&gt;',
        '<' => '&lt;',
        "'" => '&apos;',
        '"' => '&quot;'
    };
    $str =~ s/&/&amp;/g;
    foreach my $char (keys %$char2entity){
        my $replacement = $char2entity->{$char};
        $str =~ s/$char/$replacement/g
    }
    return $str;
}

sub num_entity
{
    my $var = $_[0];

    if ($htmlentity::multibytecnt == 0)
    {
        my $int = ord($var);






        if (194 <= $int && $int <= 223)
        {
            push (@htmlentity::multibyte, $var);
            $htmlentity::multibytecnt = 2;
        }

        elsif (224 <= $int && $int <= 239)
        {
            push (@htmlentity::multibyte, $var);
            $htmlentity::multibytecnt = 3;
        }
        elsif (240 <= $int && $int <= 255)
        {
            push (@htmlentity::multibyte, $var);
            $htmlentity::multibytecnt = 4;
        }
        else
        {

            return sprintf("&#x%X", $int);
        }
    }
    else
    {
        push (@htmlentity::multibyte, $var);
        if (@htmlentity::multibyte == $htmlentity::multibytecnt)
        {
            my %codepoint = (2 => 0x1F, 3 => 0x0F, 4 => 0x07);
            my $firstbitmask = $codepoint{$htmlentity::multibytecnt};
            my $remainingbitmask = 0x3F;
            my $int = ord($htmlentity::multibyte[0]) & $firstbitmask;

            for (my $i = 1; $i < $htmlentity::multibytecnt; $i++)
            {
                $int <<= 6;
                $int |= ($remainingbitmask & ord($htmlentity::multibyte[$i]));
            }
            $htmlentity::multibytecnt = 0;
            @htmlentity::multibyte = ();
            return sprintf("&#x%X;", $int);
        }
    }
    return "";
}

sub decode
{
    my ($str) = @_;
    eval {
        require HTML::Entities;
        $str = HTML::Entities::decode_entities($str);
    };
    if($@){
        my $entity2char = {
            '&quot;' => '"',
            '&lt;' => '<',
            '&apos;' => "'",
            '&gt;' => '>',
            '&#39;' => "'"
        };
        foreach my $entity (keys %$entity2char){
            my $replacement = $entity2char->{$entity};
            $str =~ s/$entity/$replacement/g
        }
        $str =~ s/&amp;/&/g;
    }
    return $str;
}

sub isHtmlSafe
{
    my ($str) = @_;
    if($str =~ m/["'<>]/){

        return 0;
    }
    $str =~ s/&((amp;)|(quot;)|(lt;)|(gt;)|(apos;)|(#39;))//g;
    if($str =~ m/&/){

        return 0;
    }
    return 1;
}
