/*
SSI Web - Web Surveying System
Copyright Sawtooth Software, Inc. All rights reserved.
Orem, UT  USA  801-477-4700 
*/
function colorPalette() {
    return [
        '#F3C301',
        '#875693',
        '#A1CAF2',
        '#BE0034',
        '#C2B281',
        '#E68FAC',
        '#F99379',
        '#604E98',
        '#F6A600',
        '#B3446C',
        '#DCD300',
        '#882D17',
        '#8DB601',
        '#654522',
        '#E25822',
        '#2B3D26',
        '#F2F3F4',
        '#222223'
    ];
}
function chartjsBar(id_name, data_input, settings = {}) {
    let unit = '';
    if (settings.percent) {
        unit = '%';
    }
    const canvas = document.createElement('canvas');
    canvas.classList.add('chart_container');
    document.getElementById(id_name).appendChild(canvas);
    let singleSeries = true;
    if (data_input.length > 1) {
        // only enable legend if more than one series
        singleSeries = false;
    }
    const palette = colorPalette();
    const datasets = data_input.map((series, index) => {
        const ret = {
            label: series.key,
            data: series.values.map(val => val.value),
            minBarLength: 2,
            stack: series.key
        };
        if (singleSeries) {
            let colorNotFound = false;
            const colors = series.values.map((val, i) => {
                if (!val.hasOwnProperty('color')) {
                    return palette[i];
                }
                return val.color;
            });
            if (!colorNotFound) {
                ret['backgroundColor'] = colors;
            } else {
                ret['backgroundColor'] = palette;
            }
        } else {
            ret['backgroundColor'] = Array(series.values.length).fill(palette[index]);
        }
        return ret;
    });
    const labels = data_input[0].values.map(point => point.label);
    new Chart(canvas, {
        type: 'bar',
        data: {
            labels,
            datasets
        },
        options: {
            plugins: {
                legend: {
                    display: !singleSeries
                }
            },
            maintainAspectRatio: false,
            scales: {
                x: {
                    stacked: true
                },
                y: {
                    stacked: true,
                    ticks: {
                        callback: function (value, index, ticks) {
                            return value + unit;
                        }
                    }
                }
            }
        }
    });
}
function chartjsPie(id_name, data_input, settings = {}) {
    let unit = '';
    if (settings.percent) {
        unit = '%';
    }
    const canvas = document.createElement('canvas');
    canvas.classList.add('chart_container');
    document.getElementById(id_name).appendChild(canvas);
    new Chart(canvas, {
        type: 'pie',
        data: {
            labels: data_input[0].values.map(point => point.label),
            datasets: [
                {
                    label: data_input[0].key,
                    data: data_input[0].values.map(val => val.value)
                }
            ],
            backgroundColor: colorPalette()
        },
        options: {
            plugins: {
                legend: {
                    display: true
                }
            },
            maintainAspectRatio: false
        }
    });
}
function CreateBarChart(id_name, data_input, settings) {
    if (settings == null) {
        settings = {};
    }
    const key = settings.percent ? 'Percent' : 'Count';
    const data = [
        {
            key,
            values: data_input
        }
    ];
    chartjsBar(id_name, data, settings);
}

function CreateMultiBarChart(id_name, data_input, settings) {
    if (settings == null) {
        settings = {};
    }
    chartjsBar(id_name, data_input, settings);
}

function CreatePieChart(id_name, data_input, settings) {
    if (settings == null) {
        settings = {};
    }
    const data = [
        {
            key: 'Percent',
            values: data_input
        }
    ];
    chartjsPie(id_name, data, settings);
}

function SSI_ShowAlert(message, title, width, height, callback) {
    $('#alert_dialog').dialog({
        draggable: true,
        responsive: true,
        modal: true,
        width: 400,
        height: 300,
        buttons: [
            {
                text: 'OK',
                class: 'primary_button',
                id: 'alert_ok_button',
                click: function () {
                    $(this).dialog('close');
                }
            }
        ],
        open: function () {
            ResetFocusOnDialogOpen();
        }
    });

    $('#alert_dialog').dialog({ title: title });

    if (width) {
        $('#alert_dialog').dialog({ width: width });
    }

    if (height) {
        $('#alert_dialog').dialog({ height: height });
    }

    $('#alert_dialog').html(message);

    if (callback) {
        $('#alert_dialog').dialog({
            close: function (event, ui) {
                callback();
            }
        });
    } else {
        //Reset the close call back to do nothing (because might have been set above)
        $('#alert_dialog').dialog({
            close: function (event, ui) {}
        });
    }

    $('#alert_dialog').dialog('open');

    $('#alert_dialog').scrollTop('0');
}

function ResetFocusOnDialogOpen() {
    document.activeElement.blur();
}
