/*
Lighthouse Studio - Web Surveying System
Copyright Sawtooth Software, Inc. All rights reserved.
Orem, UT  USA  801-477-4700
*/

const ssiModuleReady = new Promise((resolve, reject) => {
    window.addEventListener('DOMContentLoaded', () => {
        // HTML is parsed and elements are created
        if (document.getElementById('ssi-page-data')) {
            import('./ssi-module9_16_14/main.js').then(module => {
                module.ssiModule().then(async () => {
                    window.ssi_formService = module.formService;
                    dispatchEvent(new Event('ssi_module_ready'));
                    resolve(true);
                });
            });
        } else {
            dispatchEvent(new Event('ssi_module_ready'));
            resolve(false);
        }
    });
});
const classNameToPath = {
    ssi_survey_log_html: () => Promise.resolve(surveyLogHTMLController)
};
const ssiControllersReady = new Promise((resolve, reject) => {
    window.addEventListener('DOMContentLoaded', () => {
        const promises = [];
        for (let className in classNameToPath) {
            const controllerElements = document.getElementsByClassName(className);
            if (!controllerElements.length) {
                continue;
            }

            promises.push(
                classNameToPath[className]().then(controller => {
                    [...controllerElements].forEach(controllerElement => {
                        controller(controllerElement);
                    });
                })
            );
        }
        Promise.all(promises).then(() => resolve());
    });
});
window.SSI_OnSSIModuleReady =
    /**
     * Invokes the callback when the SSI module is ready.
     * @example window.SSI_OnSSIModuleReady(containsModule => {
     *    if (containsModule) {
     *       console.log('SSI module is ready.');
     *   } else {
     *      console.log('SSI module is not present.');
     *  }
     */
    function (callback) {
        ssiControllersReady
            .then(() => ssiModuleReady)
            .then(containsModule => {
                callback(containsModule);
            });
    };
/**
 *
 * @param {HTMLElement} hostElement
 */
function surveyLogHTMLController(hostElement) {
    hostElement.querySelectorAll('.group_bar').forEach(groupBar => {
        if (!(groupBar instanceof HTMLElement)) {
            return;
        }
        const entriesContainerId = groupBar.dataset.entriesContainerId;
        if (!entriesContainerId) {
            console.error('entriesContainerId not found on group_bar');
            return;
        }
        const entriesContainer = document.getElementById(entriesContainerId);
        if (!entriesContainer) {
            console.error('entriesContainer not found');
            return;
        }
        const groupButton = groupBar.querySelector('.group_button');
        if (!(groupButton instanceof HTMLElement)) {
            console.error('groupButton not found');
            return;
        }
        let isOpen = true;
        const toggle = () => {
            isOpen = !isOpen;
            entriesContainer.classList.toggle('element_display_none', !isOpen);
            groupButton.classList.toggle('right', !isOpen);
        };
        toggle();
        groupBar.addEventListener('click', toggle);
    });
}
